/*
 * Decompiled with CFR 0.152.
 */
package com.rmtheis.yandtran.translate;

import com.rmtheis.yandtran.YandexTranslatorAPI;
import com.rmtheis.yandtran.language.Language;
import java.net.URL;
import java.net.URLEncoder;

public final class Translate
extends YandexTranslatorAPI {
    private static final String SERVICE_URL = "https://translate.yandex.net/api/v1.5/tr.json/translate?";
    private static final String TRANSLATION_LABEL = "text";

    private Translate() {
    }

    public static String execute(String text, Language from, Language to) throws Exception {
        Translate.validateServiceState(text);
        String params = "key=" + URLEncoder.encode(apiKey, "UTF-8") + "&lang=" + URLEncoder.encode(from.toString(), "UTF-8") + URLEncoder.encode("-", "UTF-8") + URLEncoder.encode(to.toString(), "UTF-8") + "&text=" + URLEncoder.encode(text, "UTF-8");
        URL url = new URL(SERVICE_URL + params);
        return Translate.retrievePropArrString(url, TRANSLATION_LABEL).trim();
    }

    private static void validateServiceState(String text) throws Exception {
        int byteLength = text.getBytes("UTF-8").length;
        if (byteLength > 10240) {
            throw new RuntimeException("TEXT_TOO_LARGE");
        }
        Translate.validateServiceState();
    }
}

