/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender;

import com.github.ipixeli.gender.References;
import com.github.ipixeli.gender.UpdateChecker;
import com.github.ipixeli.gender.common.CommandListenerGender;
import com.github.ipixeli.gender.common.Common;
import com.github.ipixeli.gender.common.EventHandler;
import com.github.ipixeli.gender.common.FlatListServer;
import com.github.ipixeli.gender.common.PacketHandler;
import com.github.ipixeli.gender.common.PlayerSettingsManager;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

@Mod(modid="gender", name="Gender", version="1.2.8", acceptedMinecraftVersions="[1.11.2]")
public class Gender {
    @Mod.Instance(value="gender")
    public static Gender instance;
    @SidedProxy(clientSide="com.github.ipixeli.gender.client.Client", serverSide="com.github.ipixeli.gender.common.Common")
    public static Common proxy;
    private static File dir;
    private static Logger log;

    public static void logErr(String s) {
        log.log(Level.ERROR, s);
    }

    public static void logDbg(String s) {
        log.log(Level.DEBUG, s);
    }

    public static void logInfo(String s) {
        log.log(Level.INFO, s);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        dir = new File(event.getModConfigurationDirectory().getAbsolutePath() + "/" + "Gender" + "/");
        log = event.getModLog();
        this.checkVersion();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        new PlayerSettingsManager();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        FMLCommonHandler.instance().bus().register((Object)this);
        proxy.preInit(event.getModConfigurationDirectory());
    }

    @Mod.EventHandler
    public void onInit(FMLInitializationEvent event) {
        proxy.onInit();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        FMLEventChannel packetHandler = NetworkRegistry.INSTANCE.newEventDrivenChannel("gender");
        packetHandler.register((Object)new PacketHandler(packetHandler));
        proxy.postInit();
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        new FlatListServer(dir, "serverlist.txt");
        event.registerServerCommand((ICommand)new CommandListenerGender());
    }

    public File getDir() {
        return dir;
    }

    private void checkVersion() {
        Gender.logInfo("Running version 1.2.8");
        String modversionUpToDate = UpdateChecker.executePost(true, "[Gender] ", "https://dl.dropboxusercontent.com/u/39121275/mods/gender/v");
        if (modversionUpToDate != null && !modversionUpToDate.contains("html")) {
            Gender.logInfo("Latest version of Gender: " + modversionUpToDate + "    (http://gender.ipixeli.net/)");
            References.latest = modversionUpToDate;
        } else {
            modversionUpToDate = null;
        }
    }
}

