/*
 * Decompiled with CFR 0.152.
 */
package com.github.ipixeli.gender.common;

import com.github.ipixeli.gender.client.Config;
import java.util.ArrayList;

public class PlayerSettingsManager {
    protected static PlayerSettingsManager instance;
    private static ArrayList<PlayerSettingKeeper> keepers;

    public PlayerSettingsManager() {
        instance = this;
    }

    public static PlayerSettingsManager getInstance() {
        return instance;
    }

    public static ArrayList<PlayerSettingKeeper> getKeepers() {
        return keepers;
    }

    public static PlayerSettingKeeper get(String string) {
        for (int i = 0; i < keepers.size(); ++i) {
            PlayerSettingKeeper k = keepers.get(i);
            if (!k.getUsername().equalsIgnoreCase(string)) continue;
            return k;
        }
        return null;
    }

    private PlayerSettingKeeper newKeeper(String username) {
        PlayerSettingKeeper g = PlayerSettingsManager.get(username);
        if (g == null) {
            PlayerSettingKeeper k = new PlayerSettingKeeper(username);
            keepers.add(k);
            return k;
        }
        return g;
    }

    public PlayerSettingKeeper getOrCreate(String name) {
        PlayerSettingKeeper k = PlayerSettingsManager.get(name);
        if (k == null) {
            k = this.newKeeper(name);
        }
        return k;
    }

    public PlayerSettingKeeper getOrCreateForClientWithDefaultSettings(String username) {
        PlayerSettingKeeper k = this.getOrCreate(username);
        byte gender = (byte)(Config.config().defaultSettingPlayerGenderFemale ? 1 : 0);
        byte age = (byte)(Config.config().defaultSettingPlayerAgeChild ? 1 : 0);
        byte model = Config.config().defaultSettingPlayerModel;
        k.setOrCreateForSideWithSettings((byte)0, gender, age, model);
        return k;
    }

    public PlayerSettingKeeper getOrCreateForServerWithDefaultSettings(String username) {
        PlayerSettingKeeper k = this.getOrCreate(username);
        k.setOrCreateForSideWithSettings((byte)2, (byte)(Config.config().defaultSettingPlayerGenderFemale ? 1 : 0), (byte)(Config.config().defaultSettingPlayerAgeChild ? 1 : 0), Config.config().defaultSettingPlayerModel);
        return k;
    }

    public ArrayList<PlayerSettingKeeper> getKeepersWithClientSetting() {
        ArrayList<PlayerSettingKeeper> list = new ArrayList<PlayerSettingKeeper>();
        for (PlayerSettingKeeper k : keepers) {
            if (k == null || k.psClient == null) continue;
            list.add(k);
        }
        return list;
    }

    static {
        keepers = new ArrayList();
    }

    public class PlayerSettingKeeper {
        private String username;
        private PSObj psServer;
        private PSObj psClient;
        private PSObj psTemp;

        private PlayerSettingKeeper(String username) {
            this.username = username;
        }

        public void setOrCreateForSideWithSettings(byte side, byte f, byte c, byte m) {
            if (side == 0) {
                if (this.psClient == null) {
                    this.psClient = new PSObj(f, c, m);
                } else {
                    this.psClient.isF = f;
                    this.psClient.isC = c;
                    this.psClient.model = m;
                }
            } else if (side == 1) {
                if (this.psTemp == null) {
                    this.psTemp = new PSObj(f, c, m);
                } else {
                    this.psTemp.isF = f;
                    this.psTemp.isC = c;
                    this.psTemp.model = m;
                }
            } else if (side == 2) {
                if (this.psServer == null) {
                    this.psServer = new PSObj(f, c, m);
                } else {
                    this.psServer.isF = f;
                    this.psServer.isC = c;
                    this.psServer.model = m;
                }
            }
        }

        public void resetForSide(boolean self, byte side) {
            if (side == 0 && !self) {
                this.psClient = null;
            } else {
                this.psClient.isF = (byte)(Config.config().defaultSettingPlayerGenderFemale ? 1 : -1);
                this.psClient.isC = (byte)(Config.config().defaultSettingPlayerAgeChild ? 1 : -1);
                this.psClient.model = Config.config().defaultSettingPlayerModel;
            }
        }

        public String getUsername() {
            return this.username;
        }

        public PSObj getServer() {
            return this.psServer;
        }

        public PSObj getClient() {
            return this.psClient;
        }

        public PSObj getTemp() {
            return this.psTemp;
        }

        public class PSObj {
            private byte isF = (byte)-1;
            private byte isC = (byte)-1;
            private byte model = (byte)-1;

            private PSObj() {
                if (Config.config().defaultSettingPlayerGenderFemale) {
                    this.isF = 1;
                }
                if (Config.config().defaultSettingPlayerAgeChild) {
                    this.isC = 1;
                }
                this.model = Config.config().defaultSettingPlayerModel;
            }

            public PSObj(byte isF, byte isC, byte model) {
                this.isF = isF;
                this.isC = isC;
                this.model = model;
            }

            public byte isFemale() {
                return this.isF;
            }

            public byte isChild() {
                return this.isC;
            }

            public byte getModel() {
                return this.model;
            }

            public void setF(byte f) {
                this.isF = f;
            }

            public void setC(byte c) {
                this.isC = c;
            }

            public void setM(byte m) {
                this.model = m;
            }

            public void toggleGender() {
                if (PlayerSettingKeeper.this.username.equals("iPixeli") || PlayerSettingKeeper.this.username.equals("jjw123")) {
                    return;
                }
                this.isF = this.isF > -1 ? (this.isF == 0 ? (byte)1 : 0) : (byte)1;
            }

            public void toggleAge() {
                this.isC = this.isC > -1 ? (this.isC == 0 ? (byte)1 : 0) : (byte)1;
            }

            public void incrementModel() {
                this.model = this.model > -1 ? (this.model == 2 ? (byte)0 : (byte)(this.model + 1)) : Config.config().defaultSettingPlayerModel;
            }
        }
    }
}

