/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translate;

import com.ringosham.translate.ChatTranslator;
import com.ringosham.translate.Log;
import com.rmtheis.yandtran.language.Language;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.Level;

public final class Reference {
    public static final String MODID = "translatemod";
    public static final String VERSION = "4.3";
    public static final String NAME = "Real-time translation mod";
    public static Configuration config;

    public static void showCredits() {
        TextComponentString serviceUrl = new TextComponentString("http://translate.yandex.com");
        TextComponentString wrapperUrl = new TextComponentString("https://github.com/rmtheis/yandex-translator-java-api");
        TextComponentString forumUrl = new TextComponentString("http://bit.ly/1PJuaOF");
        serviceUrl.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "http://translate.yandex.com"));
        wrapperUrl.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://github.com/rmtheis/yandex-translator-java-api"));
        forumUrl.func_150256_b().func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "http://bit.ly/1PJuaOF"));
        ChatTranslator.sendChatMessage("Real-time translation mod by Ringosham. Version 4.3", false, TextFormatting.AQUA);
        ChatTranslator.sendChatMessage((ITextComponent)forumUrl);
        ChatTranslator.sendChatMessage("Online translation services are provided by Yandex.Translate", false, TextFormatting.AQUA);
        ChatTranslator.sendChatMessage((ITextComponent)serviceUrl);
        ChatTranslator.sendChatMessage("Yandex translator Java wrapper is provided by Robert Theis", false, TextFormatting.AQUA);
        ChatTranslator.sendChatMessage((ITextComponent)wrapperUrl);
        ChatTranslator.sendChatMessage("Thanks for downloading my mod! Translation results may not be 100% accurate", false, TextFormatting.AQUA);
    }

    public static final class LanguageMap {
        static String[] configLanguage;
        public static String[][] GuiLangPages;
        private static Map<Language, String> GuiLangName;
        private static Map<String, Language> GuiGetLang;
        private static Map<Language, String> languageName;
        private static Map<String, Language> reverseLanguageName;

        static void init() {
            int langCount = 0;
            ArrayList<String> configList = new ArrayList<String>();
            for (Language type : Language.values()) {
                languageName.put(type, type.name().toLowerCase());
                configList.add(type.name());
                ++langCount;
            }
            configLanguage = configList.toArray(new String[configList.size()]);
            GuiLangName.put(Language.AFRIKAANS, "Afrikaans");
            GuiLangName.put(Language.ALBANIAN, "Albanian (Shqiptare)");
            GuiLangName.put(Language.ARABIC, "Arabic (\u0627\u0644\u0639\u0631\u0628\u064a\u0629)");
            GuiLangName.put(Language.ARMENIAN, "Armenian (\u0540\u0561\u0575\u0565\u0580\u0565\u0576)");
            GuiLangName.put(Language.AZERBAIJAN, "Azerbaijan (Az\u0259rbaycan)");
            GuiLangName.put(Language.BASHKIR, "Bashkir (\u0411\u0430\u0448\u04a1\u043e\u0440\u0442 \u0442\u0435\u043b\u0435)");
            GuiLangName.put(Language.BASQUE, "Basque (Euskal)");
            GuiLangName.put(Language.BELARUSIAN, "Belarusian (\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f)");
            GuiLangName.put(Language.BENGALI, "Bengali (\u09ac\u09be\u0982\u09b2\u09be)");
            GuiLangName.put(Language.BOSNIAN, "Bosnian (Bosanskih)");
            GuiLangName.put(Language.BULGARIAN, "Bulgarian (\u0411\u044a\u043b\u0433\u0430\u0440\u0441\u043a\u0438)");
            GuiLangName.put(Language.CATALAN, "Catalan (Catal\u00e0)");
            GuiLangName.put(Language.CEBUANO, "Cebuano");
            GuiLangName.put(Language.CHINESE, "Chinese (\u4e2d\u6587)");
            GuiLangName.put(Language.CROATIAN, "Croatian (Hrvatski)");
            GuiLangName.put(Language.CZECH, "Czech (\u010cesk\u00e9)");
            GuiLangName.put(Language.DANISH, "Danish (Dansk)");
            GuiLangName.put(Language.DUTCH, "Dutch (Nederlandse)");
            GuiLangName.put(Language.ENGLISH, "English");
            GuiLangName.put(Language.ESPERANTO, "Esperanto");
            GuiLangName.put(Language.ESTONIAN, "Estonian (Eesti)");
            GuiLangName.put(Language.FINNISH, "Finnish (Suomen)");
            GuiLangName.put(Language.FRENCH, "French (Fran\u00e7ais)");
            GuiLangName.put(Language.GALICIAN, "Galician (Galego)");
            GuiLangName.put(Language.GEORGIAN, "Georgian (\u10e5\u10d0\u10e0\u10d7\u10e3\u10da\u10d8)");
            GuiLangName.put(Language.GERMAN, "German (Deutsch)");
            GuiLangName.put(Language.GREEK, "Greek (\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ae)");
            GuiLangName.put(Language.GUJARATI, "Gujarati (\u0a97\u0ac1\u0a9c\u0ab0\u0abe\u0aa4\u0ac0)");
            GuiLangName.put(Language.HAITIAN, "Haitian (Creole) (Ayisyen)");
            GuiLangName.put(Language.HEBREW, "Hebrew (\u05e2\u05d1\u05e8\u05d9\u05ea)");
            GuiLangName.put(Language.HINDI, "Hindi (\u0939\u093f\u0902\u0926\u0940)");
            GuiLangName.put(Language.HUNGARIAN, "Hungarian (Magyar)");
            GuiLangName.put(Language.ICELANDIC, "Icelandic (\u00cdslensk)");
            GuiLangName.put(Language.INDONESIAN, "Indonesian (Indonesia)");
            GuiLangName.put(Language.IRISH, "Irish (Gaeilge)");
            GuiLangName.put(Language.ITALIAN, "Italian (Italiano)");
            GuiLangName.put(Language.JAPANESE, "Japanese (\u65e5\u672c\u8a9e)");
            GuiLangName.put(Language.JAVANESE, "Javanese (Jawa)");
            GuiLangName.put(Language.KANNADA, "Kannada (\u0c95\u0ca8\u0ccd\u0ca8\u0ca1)");
            GuiLangName.put(Language.KAZAKH, "Kazakh (\u049a\u0430\u0437\u0430\u049b)");
            GuiLangName.put(Language.KOREAN, "Korean (\ud55c\uad6d\uc5b4)");
            GuiLangName.put(Language.KYRGYZ, "Kyrgyz (\u041a\u044b\u0440\u0433\u044b\u0437)");
            GuiLangName.put(Language.LATIN, "Latin (Latinae)");
            GuiLangName.put(Language.LATVIAN, "Latvian (Latvie\u0161u)");
            GuiLangName.put(Language.LITHUANIAN, "Lithuanian (Lietuvi\u0173)");
            GuiLangName.put(Language.MACEDONIAN, "Macedonian (\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0438)");
            GuiLangName.put(Language.MALAGASY, "Malagasy");
            GuiLangName.put(Language.MALAY, "Malay (Melayu)");
            GuiLangName.put(Language.MALAYALAM, "Malayalam (\u0d2e\u0d32\u0d2f\u0d3e\u0d33\u0d02)");
            GuiLangName.put(Language.MALTESE, "Maltese (Malti)");
            GuiLangName.put(Language.MAORI, "Maori (M\u0101ori)");
            GuiLangName.put(Language.MARATHI, "Marathi (\u092e\u0930\u093e\u0920\u0940)");
            GuiLangName.put(Language.MONGOLIAN, "Mongolian (\u041c\u043e\u043d\u0433\u043e\u043b \u0443\u043b\u0441\u044b\u043d)");
            GuiLangName.put(Language.NEPALI, "Nepali (\u0928\u0947\u092a\u093e\u0932\u0940)");
            GuiLangName.put(Language.NORWEGIAN, "Norwegian (Norsk)");
            GuiLangName.put(Language.PERSIAN, "Persian (\u0641\u0627\u0631\u0633\u06cc)");
            GuiLangName.put(Language.POLISH, "Polish (Polski)");
            GuiLangName.put(Language.PORTUGUESE, "Portuguese (Portuguesa)");
            GuiLangName.put(Language.PUNJABI, "Punjabi (\u0a2a\u0a70\u0a1c\u0a3e\u0a2c\u0a40)");
            GuiLangName.put(Language.ROMANIAN, "Romanian (Rom\u00e2n\u0103)");
            GuiLangName.put(Language.RUSSIAN, "Russian (\u0420\u0443\u0441\u0441\u043a\u0438\u0439)");
            GuiLangName.put(Language.SCOTTISH, "Scottish Gaelic (Na h-alba)");
            GuiLangName.put(Language.SERBIAN, "Serbian (\u0420\u0443\u0441\u043a\u0438)");
            GuiLangName.put(Language.SINHALA, "Sinhala (\u0dc3\u0dd2\u0d82\u0dc4\u0dbd)");
            GuiLangName.put(Language.SLOVAKIAN, "Slovakian (Slovensk\u00fd)");
            GuiLangName.put(Language.SLOVENIAN, "Slovenian (Slovenski)");
            GuiLangName.put(Language.SPANISH, "Spanish (Espa\u00f1ol)");
            GuiLangName.put(Language.SUNDANESE, "Sundanese (Basa sunda)");
            GuiLangName.put(Language.SWAHILI, "Swahili (Kiswahili)");
            GuiLangName.put(Language.SWEDISH, "Swedish (Svenska)");
            GuiLangName.put(Language.TAGALOG, "Tagalog");
            GuiLangName.put(Language.TAJIK, "Tajik (\u0422\u043e\u04b7\u0438\u043a)");
            GuiLangName.put(Language.TAMIL, "Tamil (\u0ba4\u0bae\u0bbf\u0bb4\u0bcd)");
            GuiLangName.put(Language.TATAR, "Tatar (\u0422\u0430\u0442\u0430\u0440)");
            GuiLangName.put(Language.TELUGU, "Telugu (\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41)");
            GuiLangName.put(Language.THAI, "Thai (\u0e44\u0e17\u0e22)");
            GuiLangName.put(Language.TURKISH, "Turkish (T\u00fcrk)");
            GuiLangName.put(Language.UDMURT, "Udmurt (\u0423\u0434\u043c\u0443\u0440\u0442)");
            GuiLangName.put(Language.UKRAINIAN, "Ukrainian (\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0438\u0439)");
            GuiLangName.put(Language.URDU, "Urdu (\u0627\u0631\u062f\u0648)");
            GuiLangName.put(Language.UZBEK, "Uzbek (O'zbek)");
            GuiLangName.put(Language.VIETNAMESE, "Vietnamese (Vi\u1ec7t nam)");
            GuiLangName.put(Language.WELSH, "Welsh (Cymru)");
            GuiLangName.put(Language.YIDDISH, "Yiddish (\u05d9\u05d9\u05b4\u05d3\u05d9\u05e9)");
            for (Map.Entry<Language, String> entry : languageName.entrySet()) {
                reverseLanguageName.put(entry.getValue(), entry.getKey());
            }
            GuiLangPages = new String[(int)Math.ceil((double)langCount / 12.0)][12];
            ArrayList<String> guiLang = new ArrayList<String>();
            for (Map.Entry<Language, String> entry : GuiLangName.entrySet()) {
                GuiGetLang.put(entry.getValue(), entry.getKey());
                guiLang.add(entry.getValue());
            }
            int index = 0;
            int page = 0;
            Collections.sort(guiLang);
            Iterator i$ = guiLang.iterator();
            while (i$.hasNext()) {
                String i;
                LanguageMap.GuiLangPages[page][index] = i = (String)i$.next();
                if (++index != 12) continue;
                ++page;
                index = 0;
            }
            Collections.unmodifiableMap(languageName);
            Collections.unmodifiableMap(reverseLanguageName);
            Collections.unmodifiableMap(GuiLangName);
            Collections.unmodifiableMap(GuiGetLang);
            Log.log(Level.INFO, "Language list: " + langCount + " languages loaded");
        }

        public static String getLangString(Language lang) {
            return languageName.get((Object)lang);
        }

        public static Language getLang(String langName) {
            return reverseLanguageName.get(langName);
        }

        public static String getGuiLangName(Language lang) {
            return GuiLangName.get((Object)lang);
        }

        public static Language getGuiLang(String langName) {
            return GuiGetLang.get(langName);
        }

        public static String capitalize(String string) {
            return string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
        }

        static {
            GuiLangName = new HashMap<Language, String>();
            GuiGetLang = new HashMap<String, Language>();
            languageName = new HashMap<Language, String>();
            reverseLanguageName = new HashMap<String, Language>();
        }
    }

    public static final class defaultConfig {
        static boolean translateSign = false;
        public static final String translateChat = "english";
        public static final String translateMeFrom = "english";
        public static final String translateMeTo = "spanish";
        public static final String errorLogging = "normal";
        public static final String[] errorLoggingOptions = new String[]{"off", "normal", "debug"};
        public static final int msgColor = 7;
        public static final boolean msgStyle = false;
        public static final String[] chatRegex = new String[]{"<%name%> ", "\\(From %name%\\):( )?", "%name% whispers ", "(\\[\\S+\\]( )?){0,2}%name%( )?\u00bb( )?", "(\\[\\S+\\]( )?){0,2}%name%( )?:( )?(Eye\\[\\d\\] )?", "\\d{1,3} (\\w+ )?%name% ", "Dead (\\d+ )?(\\w+ )?%name% ", "%name% > \\w+ ", "%name% whispers to you: ", "(\\(Team\\) )?(\\[\\w+\\] ){1,2}%name%: ", "(\\w+ )?\\w+: %name% > ", "\\[Lvl \\d+\\] \u25b6 (\\w+: )?%name% > ", "\u25b6 \\[\\d+\\] (\\w+: )?%name% > ", "\u25b6 (\\w+: )?%name% > ", "(\\[\\w+\\])?\\[Level \\d+\\] \\[%name%\\] ", "%name% tells you: ", "\\[%name% -> \\w+\\] ", "(\\w+ )?(\\w+-)?%name%(\\*)?(\\+){0,2}:"};
    }

    public static final class configGet {
        public static Property loggingLevel = config.get("general", "Error logging level", "normal", "Error logging levels. Change to debug if you want to send an bug report", defaultConfig.errorLoggingOptions);
        public static Property translateChat = config.get("general", "Translation language(Chat)", "english", "The language you want your chat to be translated to.", LanguageMap.configLanguage);
        public static Property translateFrom = config.get("general", "Message language", "english", "What language your messages are?", LanguageMap.configLanguage);
        public static Property translateTo = config.get("general", "Translation language(Player)", "spanish", "What language you want your message to be translated.", LanguageMap.configLanguage);
        public static Property userKey = config.get("general", "User translation key", "", "User translation key");
        public static Property msgColor = config.get("general", "Message color", 7, "Setting for message color");
        public static Property msgBold = config.get("general", "Bold message", false, "Bold the translated messages");
        public static Property msgItalic = config.get("general", "Italic message", false, "Translated messages will be italic");
        public static Property msgUnderline = config.get("general", "Underline message", false, "Underlines the translated messages");
        public static Property chatRegex = config.get("general", "Chat regex", defaultConfig.chatRegex, "Regex for the mod to detect the chat");
        public static Property translateSign = config.get("general", "Translate signs", defaultConfig.translateSign, "Translates signs when you look at them for 1 second");
    }

    public static final class GUI {
        public static final int buttonWidth = 100;
        public static final int buttonHeight = 20;
    }
}

