/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.events;

import com.ringosham.translationmod.common.ChatUtil;
import com.ringosham.translationmod.common.ConfigManager;
import com.ringosham.translationmod.common.Log;
import com.ringosham.translationmod.events.KeyBind;
import com.ringosham.translationmod.gui.TranslateGui;
import com.ringosham.translationmod.translate.SignTranslate;
import com.ringosham.translationmod.translate.Translator;
import com.ringosham.translationmod.translate.types.SignText;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.input.Keyboard;

public class Handler {
    private static Thread readSign;
    private SignText lastSign;
    private boolean hintShown = false;
    private int ticks = 0;

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.getGui() == null) {
            Keyboard.enableRepeatEvents((boolean)false);
        }
    }

    @SubscribeEvent
    public void chatReceived(ClientChatReceivedEvent event) {
        ITextComponent eventMessage = event.getMessage();
        String message = eventMessage.func_150260_c().replaceAll("\u00c2\u00a7(.)", "");
        Translator translate = new Translator(message, null, ConfigManager.INSTANCE.getTargetLanguage());
        translate.start();
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player == null) {
            return;
        }
        if (!this.hintShown) {
            this.hintShown = true;
            ChatUtil.printChatMessage(true, "Press [" + TextFormatting.AQUA + Keyboard.getKeyName((int)KeyBind.translateKey.func_151463_i()) + TextFormatting.WHITE + "] for translation settings", TextFormatting.WHITE);
            if (ConfigManager.INSTANCE.getRegexList().size() == 0) {
                Log.logger.warn("No chat regex in the configurations");
                ChatUtil.printChatMessage(true, "The mod needs chat regex to function. Check the mod options to add one", TextFormatting.RED);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world == null) {
            return;
        }
        if (ConfigManager.INSTANCE.isTranslateSign() && event.phase == TickEvent.Phase.END) {
            this.processSign(event.world);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        ConfigManager.INSTANCE.saveConfig();
    }

    @SubscribeEvent
    public void onKeybind(InputEvent.KeyInputEvent event) {
        if (KeyBind.translateKey.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new TranslateGui());
        }
    }

    private void processSign(World world) {
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver == null) {
            return;
        }
        if (mouseOver.field_72313_a != RayTraceResult.Type.BLOCK) {
            this.lastSign = null;
            this.ticks = 0;
            return;
        }
        BlockPos blockPos = mouseOver.func_178782_a();
        if (world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        if (world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150472_an || world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150444_as) {
            if (this.lastSign != null && this.lastSign.getText() != null) {
                if (this.lastSign.sameSign(blockPos)) {
                    ++this.ticks;
                    if (this.ticks >= 20 && readSign != null && readSign.getState() == Thread.State.NEW) {
                        readSign.start();
                    }
                } else {
                    readSign = this.getSignThread(world, blockPos);
                }
            } else {
                readSign = this.getSignThread(world, blockPos);
            }
        } else {
            this.lastSign = null;
            this.ticks = 0;
        }
    }

    private SignTranslate getSignThread(World world, BlockPos pos) {
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            ITextComponent line = ((TileEntitySign)Objects.requireNonNull(world.func_175625_s((BlockPos)pos))).field_145915_a[i];
            text.append(" ").append(line);
        }
        if ((text = new StringBuilder(text.toString().replaceAll("\u00c2\u00a7(.)", ""))).length() == 0) {
            return null;
        }
        this.lastSign = new SignText();
        this.lastSign.setSign(text.toString(), pos);
        return new SignTranslate(text.toString(), pos);
    }
}

