/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.gui;

import com.ringosham.translationmod.client.LangManager;
import com.ringosham.translationmod.client.types.Language;
import com.ringosham.translationmod.common.ChatUtil;
import com.ringosham.translationmod.common.ConfigManager;
import com.ringosham.translationmod.gui.AddKeyGui;
import com.ringosham.translationmod.gui.CommonGui;
import com.ringosham.translationmod.gui.LanguageSelectGui;
import com.ringosham.translationmod.gui.RegexGui;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public class ConfigGui
extends CommonGui {
    private static final int guiWidth = 250;
    private static final int guiHeight = 206;
    private static final String targetTooltip = "The language your chat will be translated to";
    private static final List<String> selfTooltip = new ArrayList<String>();
    private static final List<String> speakAsTooltip = new ArrayList<String>();
    private static final List<String> regexTooltip = new ArrayList<String>();
    private static final List<String> apiKeyTooltip = new ArrayList<String>();
    private static final List<String> colorTooltip = new ArrayList<String>();
    private static final List<String> boldTooltip = new ArrayList<String>();
    private static final List<String> underlineTooltip = new ArrayList<String>();
    private static final List<String> italicTooltip = new ArrayList<String>();
    private static final List<String> signTooltip = new ArrayList<String>();
    private boolean isTransition = false;
    private Language targetLang;
    private Language speakAsLang;
    private Language selfLang;
    private String color;
    private boolean bold;
    private boolean italic;
    private boolean underline;
    private boolean translateSign;

    ConfigGui() {
        super(206, 250);
    }

    ConfigGui(ConfigGui instance, int langSelect, Language lang) {
        super(206, 250);
        this.targetLang = instance.targetLang;
        this.speakAsLang = instance.speakAsLang;
        this.selfLang = instance.selfLang;
        this.color = instance.color;
        this.bold = instance.bold;
        this.italic = instance.italic;
        this.underline = instance.underline;
        this.translateSign = instance.translateSign;
        this.isTransition = true;
        if (lang != null) {
            switch (langSelect) {
                case 0: {
                    this.targetLang = lang;
                    break;
                }
                case 1: {
                    this.selfLang = lang;
                    break;
                }
                case 2: {
                    this.speakAsLang = lang;
                }
            }
        }
    }

    @Override
    public void func_73863_a(int x, int y, float tick) {
        super.func_73863_a(x, y, tick);
        this.field_146289_q.func_78276_b("Real time translation mod - Settings", this.getLeftMargin(), this.getYOrigin() + 5, 0x555555);
        this.field_146289_q.func_78276_b("Regex list:", this.getLeftMargin(), this.getYOrigin() + 25, 0x555555);
        this.field_146289_q.func_78276_b("Target language:", this.getLeftMargin(), this.getYOrigin() + 55, 0x555555);
        this.field_146289_q.func_78276_b("Self language:", this.getLeftMargin(), this.getYOrigin() + 75, 0x555555);
        this.field_146289_q.func_78276_b("Speak as language:", this.getLeftMargin(), this.getYOrigin() + 95, 0x555555);
        if (((GuiButton)this.field_146292_n.get(2)).func_146115_a()) {
            this.func_146279_a(targetTooltip, x, y);
        }
        if (((GuiButton)this.field_146292_n.get(3)).func_146115_a()) {
            this.func_146283_a(selfTooltip, x, y);
        }
        if (((GuiButton)this.field_146292_n.get(4)).func_146115_a()) {
            this.func_146283_a(speakAsTooltip, x, y);
        }
        if (((GuiButton)this.field_146292_n.get(11)).func_146115_a()) {
            this.func_146283_a(regexTooltip, x, y);
        }
        if (((GuiButton)this.field_146292_n.get(6)).func_146115_a()) {
            this.func_146283_a(apiKeyTooltip, x, y);
        }
        if (((GuiButton)this.field_146292_n.get(5)).func_146115_a()) {
            this.func_146283_a(signTooltip, x, y);
        }
        if (((GuiButton)this.field_146292_n.get(7)).func_146115_a()) {
            this.func_146283_a(colorTooltip, x, y);
        }
        if (((GuiButton)this.field_146292_n.get(8)).func_146115_a()) {
            this.func_146283_a(boldTooltip, x, y);
        }
        if (((GuiButton)this.field_146292_n.get(9)).func_146115_a()) {
            this.func_146283_a(italicTooltip, x, y);
        }
        if (((GuiButton)this.field_146292_n.get(10)).func_146115_a()) {
            this.func_146283_a(underlineTooltip, x, y);
        }
    }

    public void func_73866_w_() {
        if (!this.isTransition) {
            this.color = ConfigManager.INSTANCE.getColor();
            this.bold = ConfigManager.INSTANCE.isBold();
            this.italic = ConfigManager.INSTANCE.isItalic();
            this.underline = ConfigManager.INSTANCE.isUnderline();
            this.translateSign = ConfigManager.INSTANCE.isTranslateSign();
            this.targetLang = ConfigManager.INSTANCE.getTargetLanguage();
            this.selfLang = ConfigManager.INSTANCE.getSelfLanguage();
            this.speakAsLang = ConfigManager.INSTANCE.getSpeakAsLanguage();
        }
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.add(new GuiButton(0, this.getLeftMargin(), this.getYOrigin() + 206 - 5 - 20, 100, 20, "Save and close"));
        this.field_146292_n.add(new GuiButton(1, this.getRightMargin(100), this.getYOrigin() + 206 - 5 - 20, 100, 20, "Reset to default"));
        this.field_146292_n.add(new GuiButton(2, this.getRightMargin(100), this.getYOrigin() + 50, 100, 20, this.targetLang.getName()));
        this.field_146292_n.add(new GuiButton(3, this.getRightMargin(100), this.getYOrigin() + 70, 100, 20, this.selfLang.getName()));
        this.field_146292_n.add(new GuiButton(4, this.getRightMargin(100), this.getYOrigin() + 90, 100, 20, this.speakAsLang.getName()));
        this.field_146292_n.add(new GuiButton(5, this.getLeftMargin(), this.getYOrigin() + 206 - 15 - 60, 100, 20, this.translateSign ? TextFormatting.GREEN + "Translate signs" : TextFormatting.RED + "Translate signs"));
        this.field_146292_n.add(new GuiButton(6, this.getLeftMargin(), this.getYOrigin() + 206 - 10 - 40, 100, 20, "User key"));
        this.field_146292_n.add(new GuiButton(7, this.getRightMargin(100), this.getYOrigin() + 206 - 10 - 40, 100, 20, TextFormatting.func_96300_b((String)this.color) + "Message color"));
        this.field_146292_n.add(new GuiButton(8, this.getLeftMargin() + 100 + 10, this.getYOrigin() + 206 - 15 - 60, 20, 20, this.bold ? "\u00a7a" + TextFormatting.BOLD + "B" : "\u00a7c" + TextFormatting.BOLD + "B"));
        this.field_146292_n.add(new GuiButton(9, this.getLeftMargin() + 100 + 10, this.getYOrigin() + 206 - 10 - 40, 20, 20, this.italic ? "\u00a7a" + TextFormatting.ITALIC + "I" : "\u00a7c" + TextFormatting.ITALIC + "I"));
        this.field_146292_n.add(new GuiButton(10, this.getLeftMargin() + 100 + 10, this.getYOrigin() + 206 - 5 - 20, 20, 20, this.underline ? "\u00a7a" + TextFormatting.UNDERLINE + "U" : "\u00a7c" + TextFormatting.UNDERLINE + "U"));
        this.field_146292_n.add(new GuiButton(11, this.getRightMargin(100), this.getYOrigin() + 20, 100, 20, "View / Add"));
    }

    public void func_146284_a(GuiButton button) {
        Keyboard.enableRepeatEvents((boolean)false);
        switch (button.field_146127_k) {
            case 0: {
                this.applySettings();
                this.field_146297_k.func_147108_a(null);
                break;
            }
            case 1: {
                this.resetDefault();
                break;
            }
            case 2: {
                this.field_146297_k.func_147108_a((GuiScreen)new LanguageSelectGui(this, 0));
                break;
            }
            case 3: {
                this.field_146297_k.func_147108_a((GuiScreen)new LanguageSelectGui(this, 1));
                break;
            }
            case 4: {
                this.field_146297_k.func_147108_a((GuiScreen)new LanguageSelectGui(this, 2));
                break;
            }
            case 5: {
                button.field_146126_j = this.translateSign ? TextFormatting.RED + "Translate signs" : TextFormatting.GREEN + "Translate signs";
                this.translateSign = !this.translateSign;
                break;
            }
            case 6: {
                this.field_146297_k.func_147108_a((GuiScreen)new AddKeyGui());
                break;
            }
            case 7: {
                TextFormatting formatColor = TextFormatting.func_96300_b((String)this.color);
                int colorCode = Objects.requireNonNull(formatColor).func_175746_b();
                if (++colorCode == 16) {
                    colorCode = 0;
                }
                TextFormatting newColor = TextFormatting.func_175744_a((int)colorCode);
                assert (newColor != null);
                this.color = newColor.func_96297_d();
                ((GuiButton)this.field_146292_n.get((int)7)).field_146126_j = newColor + "Message color";
                break;
            }
            case 8: {
                this.bold = !this.bold;
                ((GuiButton)this.field_146292_n.get((int)8)).field_146126_j = this.bold ? "\u00a7a" + TextFormatting.BOLD + "B" : "\u00a7c" + TextFormatting.BOLD + "B";
                break;
            }
            case 9: {
                this.italic = !this.italic;
                ((GuiButton)this.field_146292_n.get((int)9)).field_146126_j = this.italic ? "\u00a7a" + TextFormatting.ITALIC + "I" : "\u00a7c" + TextFormatting.ITALIC + "I";
                break;
            }
            case 10: {
                this.underline = !this.underline;
                ((GuiButton)this.field_146292_n.get((int)10)).field_146126_j = this.underline ? "\u00a7a" + TextFormatting.UNDERLINE + "U" : "\u00a7c" + TextFormatting.UNDERLINE + "U";
                break;
            }
            case 11: {
                this.field_146297_k.func_147108_a((GuiScreen)new RegexGui());
            }
        }
    }

    private void applySettings() {
        ConfigManager.INSTANCE.setTargetLanguage(this.targetLang);
        ConfigManager.INSTANCE.setSelfLanguage(this.selfLang);
        ConfigManager.INSTANCE.setSpeakAsLanguage(this.speakAsLang);
        ConfigManager.INSTANCE.setColor(this.color);
        ConfigManager.INSTANCE.setBold(this.bold);
        ConfigManager.INSTANCE.setItalic(this.italic);
        ConfigManager.INSTANCE.setUnderline(this.underline);
        ConfigManager.INSTANCE.setTranslateSign(this.translateSign);
        ChatUtil.printChatMessage(true, "Settings applied.", TextFormatting.WHITE);
    }

    private void resetDefault() {
        this.color = "gray";
        this.bold = false;
        this.italic = false;
        this.underline = false;
        this.translateSign = true;
        this.selfLang = this.targetLang = LangManager.getInstance().findLanguageFromName("English");
        this.speakAsLang = LangManager.getInstance().findLanguageFromName("Japanese");
        ((GuiButton)this.field_146292_n.get((int)2)).field_146126_j = "English";
        ((GuiButton)this.field_146292_n.get((int)3)).field_146126_j = "English";
        ((GuiButton)this.field_146292_n.get((int)4)).field_146126_j = "Japanese";
        ((GuiButton)this.field_146292_n.get((int)7)).field_146126_j = TextFormatting.func_96300_b((String)this.color) + "Message color";
        ((GuiButton)this.field_146292_n.get((int)8)).field_146126_j = this.bold ? "\u00a7a" : "\u00a7c" + TextFormatting.BOLD + "B";
        ((GuiButton)this.field_146292_n.get((int)9)).field_146126_j = this.italic ? "\u00a7a" : "\u00a7c" + TextFormatting.ITALIC + "I";
        ((GuiButton)this.field_146292_n.get((int)10)).field_146126_j = this.underline ? "\u00a7a" : "\u00a7c" + TextFormatting.UNDERLINE + "U";
        ((GuiButton)this.field_146292_n.get((int)5)).field_146126_j = TextFormatting.GREEN + "Translate signs";
    }

    static {
        selfTooltip.add("The language you speak in game");
        selfTooltip.add("This will be utilised when you want to translate what you speak");
        speakAsTooltip.add("The language your messages will be translated to.");
        speakAsTooltip.add("After you typed your messages through this mod,");
        speakAsTooltip.add("it will be translated to the language you specified");
        regexTooltip.add("Regex are patterns for the mod to detect chat messages.");
        regexTooltip.add("If you notice the mod doesn't do anything on a server,");
        regexTooltip.add("chances are you need to add one here.");
        apiKeyTooltip.add("Use your own API key for translation");
        colorTooltip.add("Changes the color of the translated message");
        boldTooltip.add("Bolds the translated message");
        italicTooltip.add("Italics the translated message");
        underlineTooltip.add("Underlines the translated message");
        signTooltip.add("Translates signs when you look at them");
    }
}

