/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.translate;

import com.ringosham.translationmod.common.ChatUtil;
import com.ringosham.translationmod.common.ConfigManager;
import com.ringosham.translationmod.common.Log;
import com.ringosham.translationmod.translate.Translator;
import com.ringosham.translationmod.translate.types.SignText;
import com.ringosham.translationmod.translate.types.TranslateResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class SignTranslate
extends Thread {
    private final String text;
    private final BlockPos pos;

    public SignTranslate(String text, BlockPos pos) {
        this.text = text;
        this.pos = pos;
    }

    @Override
    public void run() {
        Log.logger.debug("Sign detected. Translating");
        SignText signData = new SignText();
        signData.setSign(this.text, this.pos);
        Translator translator = new Translator(this.text, null, ConfigManager.INSTANCE.getTargetLanguage());
        TranslateResult translatedMessage = translator.translate(this.text);
        if (translatedMessage == null) {
            return;
        }
        String chatMessage = "[Sign] --> " + translatedMessage.getFromLanguage().getName() + ": " + translatedMessage.getMessage();
        String hoverText = "Sign location: " + this.pos.func_177958_n() + ", " + this.pos.func_177956_o() + ", " + this.pos.func_177952_p() + "\nTranslation: " + translatedMessage.getFromLanguage().getName() + " -> " + ConfigManager.INSTANCE.getTargetLanguage().getName();
        ChatUtil.printChatMessageAdvanced(chatMessage, hoverText, ConfigManager.INSTANCE.isBold(), ConfigManager.INSTANCE.isItalic(), ConfigManager.INSTANCE.isUnderline(), TextFormatting.func_96300_b((String)ConfigManager.INSTANCE.getColor()));
    }
}

