/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.ringosham.translationmod.client.LangManager;
import com.ringosham.translationmod.client.types.Language;
import com.ringosham.translationmod.client.types.RequestResult;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class GoogleClient {
    private static final String baseUrl = "https://translate.googleapis.com/translate_a/single";
    private static boolean accessDenied = false;

    public static boolean isAccessDenied() {
        return accessDenied;
    }

    public RequestResult translateAuto(String message, Language to) {
        return this.translate(message, LangManager.getInstance().getAutoLang(), to);
    }

    public RequestResult translate(String message, Language from, Language to) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpUriRequest request = RequestBuilder.get().setUri(baseUrl).setHeader("Content-Type", ContentType.APPLICATION_JSON.getMimeType()).addParameter("client", "gtx").addParameter("sl", from.getGoogleCode()).addParameter("tl", to.getGoogleCode()).addParameter("dt", "t").addParameter("q", message).build();
        try {
            HttpResponse response = client.execute(request);
            if (response.getStatusLine().getStatusCode() != 200) {
                accessDenied = true;
                Timeout timeout = new Timeout();
                timeout.start();
                return new RequestResult(429, "Access to Google Translate denied", null, null);
            }
            InputStream in = response.getEntity().getContent();
            String responseString = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            Gson gson = new GsonBuilder().setLenient().create();
            JsonArray json = (JsonArray)gson.fromJson(responseString, JsonArray.class);
            Language detectedSource = LangManager.getInstance().findLanguageFromGoogle(json.get(2).getAsString());
            JsonArray lines = json.get(0).getAsJsonArray();
            StringBuilder stringBuilder = new StringBuilder();
            for (JsonElement sentenceObj : lines) {
                JsonArray sentence = sentenceObj.getAsJsonArray();
                stringBuilder.append(sentence.get(0).getAsString());
                stringBuilder.append(" ");
            }
            return new RequestResult(200, stringBuilder.toString(), detectedSource, to);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RequestResult(1, "Connection error", null, null);
        }
    }

    private static class Timeout
    extends Thread {
        private Timeout() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(300000L);
                accessDenied = false;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

