/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.client;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.ringosham.translationmod.client.LangManager;
import com.ringosham.translationmod.client.types.Language;
import com.ringosham.translationmod.client.types.RequestResult;
import com.ringosham.translationmod.client.types.google.TranslateError;
import com.ringosham.translationmod.client.types.google.TranslateResponse;
import com.ringosham.translationmod.common.ConfigManager;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class GooglePaidClient {
    private static final String baseUrl = "https://translation.googleapis.com/language/translate/v2";
    private static boolean disable = false;

    public static void setDisable() {
        disable = true;
    }

    public static boolean getDisable() {
        return disable;
    }

    public RequestResult translateAuto(String message, Language to) {
        return this.translate(message, LangManager.getInstance().getAutoLang(), to);
    }

    public RequestResult translate(String message, Language from, Language to) {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        RequestBuilder builder = RequestBuilder.post();
        builder.setUri(baseUrl);
        builder.addParameter("q", message);
        builder.addParameter("target", to.getGoogleCode());
        builder.addParameter("format", "text");
        builder.addParameter("key", (String)ConfigManager.config.userKey.get());
        if (from != LangManager.getInstance().getAutoLang()) {
            builder.addParameter("source", from.getGoogleCode());
        }
        HttpUriRequest request = builder.build();
        try {
            HttpResponse response = client.execute(request);
            InputStream in = response.getEntity().getContent();
            String responseString = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            Gson gson = new Gson();
            if (response.getStatusLine().getStatusCode() == 200) {
                TranslateResponse transResponse = (TranslateResponse)gson.fromJson(responseString, TranslateResponse.class);
                String translatedText = transResponse.getData().getTranslations()[0].getTranslatedText();
                Language sourceLang = LangManager.getInstance().findLanguageFromGoogle(transResponse.getData().getTranslations()[0].getDetectedSourceLanguage());
                if (sourceLang == null) {
                    sourceLang = from;
                }
                return new RequestResult(200, translatedText, sourceLang, to);
            }
            try {
                TranslateError error = (TranslateError)gson.fromJson(responseString, TranslateError.class);
                return new RequestResult(error.getError().getCode(), error.getError().getMessage(), null, null);
            }
            catch (JsonSyntaxException e) {
                return new RequestResult(2, "Unknown response: " + responseString, null, null);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return new RequestResult(1, "Connection error", null, null);
        }
    }
}

