/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.events;

import com.ringosham.translationmod.client.LangManager;
import com.ringosham.translationmod.common.ChatUtil;
import com.ringosham.translationmod.common.ConfigManager;
import com.ringosham.translationmod.common.Log;
import com.ringosham.translationmod.events.KeyBind;
import com.ringosham.translationmod.gui.TranslateGui;
import com.ringosham.translationmod.translate.SignTranslate;
import com.ringosham.translationmod.translate.Translator;
import com.ringosham.translationmod.translate.types.SignText;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.tileentity.SignTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;

public class Handler {
    private static Thread readSign;
    private SignText lastSign;
    private boolean hintShown = false;
    private int ticks = 0;
    private static final Block[] signBlocks;

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.getGui() == null) {
            Minecraft.func_71410_x().field_195559_v.func_197967_a(false);
        }
    }

    @SubscribeEvent
    public void chatReceived(ClientChatReceivedEvent event) {
        ITextComponent eventMessage = event.getMessage();
        String message = eventMessage.getString().replaceAll("\u00c2\u00a7(.)", "");
        Translator translate = new Translator(message, null, LangManager.getInstance().findLanguageFromName((String)ConfigManager.config.targetLanguage.get()));
        translate.start();
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player == null) {
            return;
        }
        if (!this.hintShown) {
            this.hintShown = true;
            ChatUtil.printChatMessage(true, "Press [" + TextFormatting.AQUA + ((ITextComponent)KeyBinding.func_193626_b((String)KeyBind.translateKey.func_151464_g()).get()).func_150261_e() + TextFormatting.WHITE + "] for translation settings", TextFormatting.WHITE);
            if (((List)ConfigManager.config.regexList.get()).size() == 0) {
                Log.logger.warn("No chat regex in the configurations");
                ChatUtil.printChatMessage(true, "The mod needs chat regex to function. Check the mod options to add one", TextFormatting.RED);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world == null) {
            return;
        }
        if (((Boolean)ConfigManager.config.translateSign.get()).booleanValue() && event.phase == TickEvent.Phase.END) {
            this.processSign(event.world);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ModConfig.Reloading event) {
        ConfigManager.saveConfig();
    }

    @SubscribeEvent
    public void onKeybind(InputEvent.KeyInputEvent event) {
        if (KeyBind.translateKey.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((Screen)new TranslateGui());
        }
    }

    private void processSign(World world) {
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver == null) {
            return;
        }
        if (mouseOver.func_216346_c() != RayTraceResult.Type.BLOCK) {
            this.lastSign = null;
            this.ticks = 0;
            return;
        }
        Vector3d vec = mouseOver.func_216347_e();
        BlockPos blockPos = new BlockPos(vec);
        if (world.func_180495_p(blockPos).func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        boolean isSign = false;
        for (Block signBlock : signBlocks) {
            if (world.func_180495_p(blockPos).func_177230_c() != signBlock) continue;
            if (this.lastSign != null && this.lastSign.getText() != null) {
                if (this.lastSign.sameSign(blockPos)) {
                    ++this.ticks;
                    if (this.ticks >= 20 && readSign != null && readSign.getState() == Thread.State.NEW) {
                        readSign.start();
                    }
                } else {
                    readSign = this.getSignThread(world, blockPos);
                }
            } else {
                readSign = this.getSignThread(world, blockPos);
            }
            isSign = true;
        }
        if (!isSign) {
            this.lastSign = null;
            this.ticks = 0;
        }
    }

    private SignTranslate getSignThread(World world, BlockPos pos) {
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            ITextComponent line = ((SignTileEntity)Objects.requireNonNull(world.func_175625_s(pos))).func_212366_a(i);
            text.append(" ").append(line);
        }
        if ((text = new StringBuilder(text.toString().replaceAll("\u00c2\u00a7(.)", ""))).length() == 0) {
            return null;
        }
        this.lastSign = new SignText();
        this.lastSign.setSign(text.toString(), pos);
        return new SignTranslate(text.toString(), pos);
    }

    static {
        signBlocks = new Block[]{Blocks.field_222389_ca, Blocks.field_196697_eJ, Blocks.field_222386_bZ, Blocks.field_222394_cj, Blocks.field_222391_cc, Blocks.field_222397_cm, Blocks.field_222390_cb, Blocks.field_222396_cl, Blocks.field_222384_bX, Blocks.field_222392_ch, Blocks.field_222385_bY, Blocks.field_222393_ci};
    }
}

