/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.ringosham.translationmod.gui.CommonGui;
import com.ringosham.translationmod.gui.LanguageSelectGui;
import com.ringosham.translationmod.gui.TextButton;
import com.ringosham.translationmod.translate.Translator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;

public class RetranslateGui
extends CommonGui {
    private static final String title;
    private static final int guiHeight;
    private static final int guiWidth;
    private final List<Translator.TranslationLog> logs = Translator.getTranslationLog();

    public RetranslateGui() {
        super(title, guiHeight, guiWidth);
    }

    @Override
    public void func_230430_a_(MatrixStack stack, int x, int y, float tick) {
        super.func_230430_a_(stack, x, y, tick);
        this.drawStringLine(stack, title, new String[]{"Translations are in the incorrect language?", "Select the messages below to retranslate."}, 0);
        for (int i = 0; i < this.field_230710_m_.size(); ++i) {
            TextButton button = (TextButton)((Object)this.field_230710_m_.get(i));
            if (!button.func_230449_g_()) continue;
            ArrayList<StringTextComponent> hoverText = new ArrayList<StringTextComponent>();
            hoverText.add(new StringTextComponent("Sender: " + this.logs.get(i).getSender()));
            hoverText.add(new StringTextComponent("Message: " + this.logs.get(i).getMessage()));
            this.func_243308_b(stack, hoverText, x, y);
        }
    }

    public void func_231160_c_() {
        int offset = 0;
        for (Translator.TranslationLog log : this.logs) {
            String buttonText = log.getMessage();
            if (this.getTextWidth(buttonText) > guiWidth - 15) {
                buttonText = buttonText + "...";
                while (this.getTextWidth(buttonText) > guiWidth - 15) {
                    buttonText = buttonText.substring(0, buttonText.length() - 4) + "...";
                }
            }
            this.func_230480_a_((Widget)new TextButton(this.getLeftMargin(), this.getTopMargin() + 40 + offset, this.getTextWidth(buttonText), (ITextComponent)new StringTextComponent(buttonText), button -> this.selectLanguage(log.getSender(), log.getMessage()), 0));
            offset += 10;
        }
    }

    private void selectLanguage(String sender, String message) {
        this.getMinecraft().func_147108_a((Screen)new LanguageSelectGui(sender, message));
    }

    static {
        String modName = ((ModContainer)ModList.get().getModContainerById("translationmod").get()).getModInfo().getDisplayName();
        title = modName + " - Retranslate";
        guiHeight = 200;
        guiWidth = 350;
    }
}

