/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.translate;

import com.ringosham.translationmod.client.LangManager;
import com.ringosham.translationmod.client.types.Language;
import com.ringosham.translationmod.common.ChatUtil;
import com.ringosham.translationmod.common.ConfigManager;
import com.ringosham.translationmod.common.Log;
import com.ringosham.translationmod.translate.Translator;
import com.ringosham.translationmod.translate.types.SignText;
import com.ringosham.translationmod.translate.types.TranslateResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;

public class SignTranslate
extends Thread {
    private String text;
    private final BlockPos pos;

    public SignTranslate(String text, BlockPos pos) {
        this.text = text;
        this.pos = pos;
    }

    @Override
    public void run() {
        Log.logger.debug("Sign detected. Translating");
        SignText signData = new SignText();
        signData.setSign(this.text, this.pos);
        Language targetLanguage = LangManager.getInstance().findLanguageFromName((String)ConfigManager.config.targetLanguage.get());
        Translator translator = new Translator(this.text, null, targetLanguage);
        TranslateResult translatedMessage = translator.translate(this.text);
        if (translatedMessage == null) {
            return;
        }
        String chatMessage = "[Sign] --> " + translatedMessage.getFromLanguage().getName() + ": " + translatedMessage.getMessage();
        String hoverText = "Sign location: " + this.pos.func_177958_n() + ", " + this.pos.func_177956_o() + ", " + this.pos.func_177952_p() + "\nTranslation: " + translatedMessage.getFromLanguage().getName() + " -> " + targetLanguage.getName();
        ChatUtil.printChatMessageAdvanced(chatMessage, hoverText, (Boolean)ConfigManager.config.bold.get(), (Boolean)ConfigManager.config.italic.get(), (Boolean)ConfigManager.config.underline.get(), TextFormatting.func_96300_b((String)((String)ConfigManager.config.color.get())));
    }
}

