/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.translate;

import com.ringosham.translationmod.client.GoogleClient;
import com.ringosham.translationmod.client.GooglePaidClient;
import com.ringosham.translationmod.client.types.Language;
import com.ringosham.translationmod.client.types.RequestResult;
import com.ringosham.translationmod.common.ChatUtil;
import com.ringosham.translationmod.common.ConfigManager;
import com.ringosham.translationmod.common.Log;
import com.ringosham.translationmod.translate.types.TranslateResult;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.text.TextFormatting;

public class Translator
extends Thread {
    private final String message;
    private final Language from;
    private final Language to;
    private static final LinkedList<TranslationLog> translationLog = new LinkedList();

    public Translator(String message, Language from, Language to) {
        this.message = message;
        this.from = from;
        this.to = to;
    }

    public static LinkedList<TranslationLog> getTranslationLog() {
        return translationLog;
    }

    public TranslateResult translate(String rawMessage) {
        if (this.from == this.to) {
            return null;
        }
        if ((rawMessage = rawMessage.trim()).length() == 0) {
            return null;
        }
        if (!((String)ConfigManager.config.userKey.get()).equals("") && !GooglePaidClient.getDisable()) {
            GooglePaidClient google = new GooglePaidClient();
            RequestResult transRequest = this.from == null ? google.translateAuto(rawMessage, this.to) : google.translate(rawMessage, this.from, this.to);
            if (transRequest.getCode() != 200) {
                this.logException(transRequest);
                return null;
            }
            return new TranslateResult(transRequest.getMessage(), transRequest.getFrom());
        }
        if (!GoogleClient.isAccessDenied()) {
            GoogleClient google = new GoogleClient();
            RequestResult transRequest = this.from == null ? google.translateAuto(rawMessage, this.to) : google.translate(rawMessage, this.from, this.to);
            if (transRequest.getCode() != 200) {
                this.logException(transRequest);
                return null;
            }
            return new TranslateResult(transRequest.getMessage(), transRequest.getFrom());
        }
        return null;
    }

    private String findPlayerName(String message, int regexIndex) {
        Pattern pattern = Pattern.compile((String)((List)ConfigManager.config.regexList.get()).get(regexIndex));
        Matcher matcher = pattern.matcher(message);
        matcher.find();
        return matcher.group((Integer)((List)ConfigManager.config.groupList.get()).get(regexIndex));
    }

    private void logException(RequestResult transRequest) {
        switch (transRequest.getCode()) {
            case 1: {
                Log.logger.error("Cannot connect to translation server. Is player offline?");
                break;
            }
            case 2: {
                Log.logger.error(transRequest.getMessage());
            }
            case 429: {
                Log.logger.warn("Google denied access to translation API. Pausing translation for 5 minutes");
                ChatUtil.printChatMessage(true, "Google translate has stopped responding. Pausing translations", TextFormatting.YELLOW);
                break;
            }
            case 403: {
                Log.logger.error("Exceeded API quota");
                ChatUtil.printChatMessage(true, "You have exceeded your quota. Please check your quota settings", TextFormatting.RED);
                ChatUtil.printChatMessage(true, "Falling back to free version until you restart the game", TextFormatting.RED);
                GooglePaidClient.setDisable();
                break;
            }
            case 400: {
                Log.logger.error("API key invalid");
                ChatUtil.printChatMessage(true, "API key invalid. If you do not wish to use a key, please remove it from the settings", TextFormatting.RED);
                break;
            }
            case 500: {
                Log.logger.error("Failed to determine source language: " + transRequest.getMessage());
                break;
            }
            default: {
                Log.logger.error("Unknown error: " + transRequest.getMessage());
            }
        }
    }

    @Override
    public void run() {
        int regexIndex = 0;
        if (this.message.trim().isEmpty()) {
            return;
        }
        String messageTrim = this.message.replaceAll("\u00a7(.)", "");
        String headerMatch = null;
        Iterator iterator = ((List)ConfigManager.config.regexList.get()).iterator();
        while (iterator.hasNext()) {
            Pattern pattern;
            Matcher matcher;
            String regex;
            String regexFixed = regex = (String)iterator.next();
            if (!regex.contains("^")) {
                regexFixed = "^" + regex;
            }
            if (!(matcher = (pattern = Pattern.compile(regexFixed)).matcher(messageTrim)).find()) continue;
            if (headerMatch == null) {
                headerMatch = matcher.group(0);
                regexIndex = ((List)ConfigManager.config.regexList.get()).indexOf(regex);
                continue;
            }
            if (headerMatch.length() >= matcher.group(0).length()) continue;
            headerMatch = matcher.group(0);
            regexIndex = ((List)ConfigManager.config.regexList.get()).indexOf(regex);
        }
        if (headerMatch == null) {
            return;
        }
        String sender = this.findPlayerName(headerMatch, regexIndex);
        if (sender == null) {
            return;
        }
        Pattern pattern = Pattern.compile((String)((List)ConfigManager.config.regexList.get()).get(regexIndex));
        Matcher matcher = pattern.matcher(messageTrim);
        matcher.find();
        String rawMessage = messageTrim.replace(matcher.group(0), "");
        TranslateResult translatedMessage = this.translate(rawMessage);
        this.addToLog(new TranslationLog(sender, rawMessage));
        if (translatedMessage == null) {
            return;
        }
        String fromStr = null;
        if (translatedMessage.getFromLanguage() != null) {
            fromStr = translatedMessage.getFromLanguage().getName();
        }
        String chatMessage = sender + " --> " + (fromStr == null ? "Unknown" : fromStr) + ": " + translatedMessage.getMessage();
        String hoverText = "Sender: " + sender + "\nTranslation: " + (fromStr == null ? "Unknown" : fromStr) + " -> " + this.to.getName();
        if (translatedMessage.getMessage().trim().equals(rawMessage.trim())) {
            return;
        }
        ChatUtil.printChatMessageAdvanced(chatMessage, hoverText, (Boolean)ConfigManager.config.bold.get(), (Boolean)ConfigManager.config.italic.get(), (Boolean)ConfigManager.config.underline.get(), TextFormatting.func_96300_b((String)((String)ConfigManager.config.color.get())));
    }

    private void addToLog(TranslationLog log) {
        translationLog.add(log);
        if (translationLog.size() > 15) {
            translationLog.pollFirst();
        }
    }

    public static class TranslationLog {
        private final String sender;
        private final String message;

        public TranslationLog(String sender, String message) {
            this.sender = sender;
            this.message = message;
        }

        public String getMessage() {
            return this.message;
        }

        public String getSender() {
            return this.sender;
        }
    }
}

