/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.common;

import com.google.common.primitives.Ints;
import com.ringosham.translationmod.client.LangManager;
import com.ringosham.translationmod.client.types.Language;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigManager {
    public static final ConfigManager INSTANCE = new ConfigManager();
    public static final String[] defaultRegex = new String[]{"<(\\w+)> ", "\\(From (\\w+)\\):( )?", "(\\w+) whispers ", "(\\[\\S+\\]( )?){0,2}(\\w+)( )?\u00bb( )?", "(\\[\\S+\\]( )?){0,2}(\\w+)( )?:( )?(Eye\\[\\d\\] )?", "\\d{1,3} (\\w+ )?(\\w+) ", "Dead (\\d+ )?(\\w+ )?(\\w+) ", "(\\w+) > \\w+ ", "(\\w+) whispers to you: ", "(\\(Team\\) )?(\\[\\w+\\] ){1,2}(\\w+): ", "(\\w+ )?\\w+: (\\w+) > ", "\\[Lvl \\d+\\] \u25b6 (\\w+: )?(\\w+) > ", "\u25b6 \\[\\d+\\] (\\w+: )?(\\w+) > ", "\u25b6 (\\w+: )?(\\w+) > ", "(\\[\\w+\\])?\\[Level \\d+\\] \\[(\\w+)\\] ", "(\\w+) tells you: ", "\\[(\\w+) -> \\w+\\] ", "(\\w+ )?(\\w+-)?(\\w+)(\\*)?(\\+){0,2}:"};
    public static final int[] defaultGroups = new int[]{1, 1, 1, 3, 3, 2, 3, 1, 1, 3, 2, 2, 2, 2, 2, 1, 1, 3};
    private static final int configMinVersion = 1;
    private Configuration config;
    private Language targetLanguage;
    private Language selfLanguage;
    private Language speakAsLanguage;
    private boolean bold;
    private boolean italic;
    private boolean underline;
    private String color;
    private boolean translateSign;
    private String userKey;
    private List<String> regexList;
    private List<Integer> groupList;

    private ConfigManager() {
    }

    public void init(FMLPreInitializationEvent e) {
        this.config = new Configuration(e.getSuggestedConfigurationFile());
        this.config.load();
        this.syncConfig();
    }

    public void syncConfig() {
        ArrayList colors;
        this.config.load();
        this.versionCheck();
        this.targetLanguage = LangManager.getInstance().findLanguageFromName(this.config.getString("targetLanguage", "general", "English", "Target language to translate for the chat"));
        this.selfLanguage = LangManager.getInstance().findLanguageFromName(this.config.getString("selfLanguage", "general", "English", "The language the user types"));
        this.speakAsLanguage = LangManager.getInstance().findLanguageFromName(this.config.getString("speakAsLanguage", "general", "Japanese", "The language the user wants their message to translate to"));
        this.bold = this.config.getBoolean("bold", "general", false, "Bold the translated message");
        this.italic = this.config.getBoolean("italic", "general", false, "Italic the translated message");
        this.underline = this.config.getBoolean("underline", "general", false, "Underline the translated message");
        this.color = this.config.getString("color", "general", "gray", "Changes the color of the translated message");
        this.translateSign = this.config.getBoolean("translateSign", "general", true, "Allows translating texts in sign by looking");
        this.userKey = this.config.getString("userKey", "general", "", "Your personal translation key");
        this.regexList = Arrays.asList(this.config.getStringList("regexList", "general", defaultRegex, "Your regex list"));
        this.groupList = Ints.asList((int[])this.config.get("groupList", "general", defaultGroups, "Your match group number to detect player names").getIntList());
        boolean valid = true;
        if (this.targetLanguage == null) {
            valid = false;
            this.setTargetLanguage(LangManager.getInstance().findLanguageFromName("English"));
        }
        if (this.selfLanguage == null) {
            valid = false;
            this.setSelfLanguage(LangManager.getInstance().findLanguageFromName("English"));
        }
        if (this.speakAsLanguage == null) {
            valid = false;
            this.setSpeakAsLanguage(LangManager.getInstance().findLanguageFromName("Japanese"));
        }
        Iterator<String> regexIt = this.regexList.iterator();
        int index = 0;
        while (regexIt.hasNext()) {
            String regex = regexIt.next();
            try {
                Pattern.compile(regex);
            }
            catch (PatternSyntaxException e) {
                valid = false;
                regexIt.remove();
                this.groupList.remove(index);
                --index;
            }
            if (this.groupList.get(index) < 0) {
                valid = false;
                regexIt.remove();
                this.groupList.remove(index);
                --index;
            }
            ++index;
        }
        regexIt = this.regexList.iterator();
        int iterAIndex = 0;
        while (regexIt.hasNext()) {
            String regex = regexIt.next();
            Iterator<String> regexIt2 = this.regexList.iterator();
            for (int i = 0; i <= iterAIndex; ++i) {
                regexIt2.next();
            }
            int iterBIndex = iterAIndex + 1;
            regexIt2.next();
            while (regexIt2.hasNext()) {
                String regex2 = regexIt2.next();
                if (regex.equals(regex2)) {
                    valid = false;
                    this.regexList.remove(iterBIndex);
                    this.groupList.remove(iterBIndex);
                    --iterBIndex;
                }
                ++iterBIndex;
            }
            if (++iterAIndex != this.regexList.size() - 1) continue;
            break;
        }
        if (!(colors = new ArrayList(EnumChatFormatting.func_96296_a((boolean)true, (boolean)false))).contains(this.color)) {
            this.color = "gray";
            valid = false;
        }
        if (!valid) {
            this.setRegexList(this.regexList);
            this.setGroupList(this.groupList);
            this.config.save();
            this.syncConfig();
        }
        this.config.save();
    }

    private void versionCheck() {
        Property prop = this.config.get("general", "configVersion", 0, "Config version check to ensure nothing's outdated");
        int configVersion = prop.getInt();
        if (1 > configVersion) {
            this.setTargetLanguage(LangManager.getInstance().findLanguageFromName("English"));
            this.setSelfLanguage(LangManager.getInstance().findLanguageFromName("English"));
            this.setSpeakAsLanguage(LangManager.getInstance().findLanguageFromName("Japanese"));
            this.setBold(false);
            this.setItalic(false);
            this.setUnderline(false);
            this.setTranslateSign(true);
            this.setColor("gray");
            this.setRegexList(Arrays.asList(defaultRegex));
            this.setGroupList(Ints.asList((int[])defaultGroups));
            prop.set(1);
        }
    }

    public Language getTargetLanguage() {
        return this.targetLanguage;
    }

    public void setTargetLanguage(Language targetLanguage) {
        this.targetLanguage = targetLanguage;
        this.config.get("general", "targetLanguage", "English", "Target language to translate for the chat").set(targetLanguage.getName());
        this.config.save();
    }

    public Language getSelfLanguage() {
        return this.selfLanguage;
    }

    public void setSelfLanguage(Language selfLanguage) {
        this.selfLanguage = selfLanguage;
        this.config.get("general", "selfLanguage", "English", "The language the user types").set(selfLanguage.getName());
        this.config.save();
    }

    public Language getSpeakAsLanguage() {
        return this.speakAsLanguage;
    }

    public void setSpeakAsLanguage(Language speakAsLanguage) {
        this.speakAsLanguage = speakAsLanguage;
        this.config.get("general", "speakAsLanguage", "Japanese", "The language the user wants their message to translate to").set(speakAsLanguage.getName());
        this.config.save();
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
        this.config.get("general", "bold", false, "Bold the translated message").set(bold);
        this.config.save();
    }

    public boolean isItalic() {
        return this.italic;
    }

    public void setItalic(boolean italic) {
        this.italic = italic;
        this.config.get("general", "italic", false, "Italic the translated message").set(italic);
        this.config.save();
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public void setUnderline(boolean underline) {
        this.underline = underline;
        this.config.get("general", "underline", false, "Underline the translated message").set(underline);
        this.config.save();
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
        this.config.get("general", "color", "gray", "Changes the color of the translated message").set(color);
        this.config.save();
    }

    public boolean isTranslateSign() {
        return this.translateSign;
    }

    public void setTranslateSign(boolean translateSign) {
        this.translateSign = translateSign;
        this.config.get("general", "translateSign", true, "Allows translating texts in sign by looking").set(translateSign);
        this.config.save();
    }

    public String getUserKey() {
        return this.userKey;
    }

    public void setUserKey(String userKey) {
        this.userKey = userKey;
        this.config.get("general", "userKey", "", "Your personal translation key").set(userKey);
        this.config.save();
    }

    public List<String> getRegexList() {
        return this.regexList;
    }

    public void setRegexList(List<String> regexList) {
        this.regexList = regexList;
        String[] array = regexList.toArray(new String[0]);
        this.config.get("general", "regexList", defaultRegex, "Your regex list").set(array);
        this.config.save();
    }

    public List<Integer> getGroupList() {
        return this.groupList;
    }

    public void setGroupList(List<Integer> groupList) {
        this.groupList = groupList;
        int[] array = Ints.toArray(groupList);
        this.config.get("groupList", "general", defaultGroups, "Your match group number to detect player names").set(array);
        this.config.save();
    }

    public void saveConfig() {
        this.config.save();
        this.syncConfig();
    }
}

