/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.events;

import com.ringosham.translationmod.common.ChatUtil;
import com.ringosham.translationmod.common.ConfigManager;
import com.ringosham.translationmod.common.Log;
import com.ringosham.translationmod.events.KeyBind;
import com.ringosham.translationmod.gui.TranslateGui;
import com.ringosham.translationmod.translate.SignTranslate;
import com.ringosham.translationmod.translate.Translator;
import com.ringosham.translationmod.translate.types.SignText;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.tileentity.TileEntitySign;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import org.lwjgl.input.Keyboard;

public class Handler {
    private static Thread readSign;
    private SignText lastSign;
    private boolean hintShown = false;
    private int ticks = 0;

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        if (event.gui == null) {
            Keyboard.enableRepeatEvents((boolean)false);
        }
    }

    @SubscribeEvent
    public void chatReceived(ClientChatReceivedEvent event) {
        IChatComponent eventMessage = event.message;
        String message = eventMessage.func_150260_c().replaceAll("\u00c2\u00a7(.)", "");
        Translator translate = new Translator(message, null, ConfigManager.INSTANCE.getTargetLanguage());
        translate.start();
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player == null) {
            return;
        }
        if (!this.hintShown) {
            this.hintShown = true;
            ChatUtil.printChatMessage(true, "Press [" + EnumChatFormatting.AQUA + Keyboard.getKeyName((int)KeyBind.translateKey.func_151463_i()) + EnumChatFormatting.WHITE + "] for translation settings", EnumChatFormatting.WHITE);
            if (ConfigManager.INSTANCE.getRegexList().size() == 0) {
                Log.logger.warn("No chat regex in the configurations");
                ChatUtil.printChatMessage(true, "The mod needs chat regex to function. Check the mod options to add one", EnumChatFormatting.RED);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.world == null) {
            return;
        }
        if (ConfigManager.INSTANCE.isTranslateSign() && event.phase == TickEvent.Phase.END) {
            this.processSign(event.world);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        ConfigManager.INSTANCE.saveConfig();
    }

    @SubscribeEvent
    public void onKeybind(InputEvent.KeyInputEvent event) {
        if (KeyBind.translateKey.func_151468_f()) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new TranslateGui());
        }
    }

    private void processSign(World world) {
        MovingObjectPosition mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver == null) {
            return;
        }
        if (mouseOver.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            this.lastSign = null;
            this.ticks = 0;
            return;
        }
        int x = mouseOver.field_72311_b;
        int y = mouseOver.field_72312_c;
        int z = mouseOver.field_72309_d;
        if (world.func_147439_a(x, y, z) == Block.func_149729_e((int)0)) {
            return;
        }
        if (world.func_147439_a(x, y, z) == Block.func_149729_e((int)63) || world.func_147439_a(x, y, z) == Block.func_149729_e((int)68)) {
            if (this.lastSign != null && this.lastSign.getText() != null) {
                if (this.lastSign.sameSign(x, y, z)) {
                    ++this.ticks;
                    if (this.ticks >= 20 && readSign != null && readSign.getState() == Thread.State.NEW) {
                        readSign.start();
                    }
                } else {
                    readSign = this.getSignThread(world, x, y, z);
                }
            } else {
                readSign = this.getSignThread(world, x, y, z);
            }
        } else {
            this.lastSign = null;
            this.ticks = 0;
        }
    }

    private SignTranslate getSignThread(World world, int x, int y, int z) {
        StringBuilder text = new StringBuilder();
        for (int i = 0; i < 4; ++i) {
            String line = ((TileEntitySign)world.func_147438_o((int)x, (int)y, (int)z)).field_145915_a[i];
            text.append(" ").append(line);
        }
        if ((text = new StringBuilder(text.toString().replaceAll("\u00c2\u00a7(.)", ""))).length() == 0) {
            return null;
        }
        this.lastSign = new SignText();
        this.lastSign.setSign(text.toString(), x, y, z);
        return new SignTranslate(text.toString(), x, y, z);
    }
}

