/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.gui;

import com.ringosham.translationmod.client.LangManager;
import com.ringosham.translationmod.client.types.Language;
import cpw.mods.fml.client.GuiScrollingList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.Tessellator;

public class LangList
extends GuiScrollingList {
    private final List<Language> langList = LangManager.getInstance().getAllLanguages();
    private GuiScreen parent;
    private int selectedIndex;

    public LangList(Minecraft client, GuiScreen parent, int width, int height, int top, int bottom, int left, int entryHeight) {
        super(client, width, height, top, bottom, left, entryHeight);
        Collections.sort(this.langList, new Comparator<Language>(){

            @Override
            public int compare(Language o1, Language o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.parent = parent;
    }

    protected int getSize() {
        return this.langList.size();
    }

    protected void elementClicked(int index, boolean doubleClick) {
        this.selectedIndex = index;
    }

    protected boolean isSelected(int index) {
        return index == this.selectedIndex;
    }

    protected void drawBackground() {
    }

    protected void drawSlot(int listIndex, int right, int top, int height, Tessellator var5) {
        Language lang = this.langList.get(listIndex);
        String langName = lang.getNameUnicode() != null ? lang.getName() + " (" + lang.getNameUnicode() + ")" : lang.getName();
        if (top < this.top) {
            return;
        }
        if (top > this.top + this.listHeight) {
            return;
        }
        this.parent.field_146297_k.field_71466_p.func_78276_b(langName, this.left + 5, top, 0xFFFFFF);
    }

    public Language getSelected() {
        return this.langList.get(this.selectedIndex);
    }
}

