/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.gui;

import com.google.common.primitives.Ints;
import com.ringosham.translationmod.common.ChatUtil;
import com.ringosham.translationmod.common.ConfigManager;
import com.ringosham.translationmod.common.Log;
import com.ringosham.translationmod.gui.CommonGui;
import com.ringosham.translationmod.gui.TextButton;
import cpw.mods.fml.common.ObfuscationReflectionHelper;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class RegexGui
extends CommonGui
implements GuiYesNoCallback {
    private static final String testMessage = "Notch --> English: Hello!";
    private static final int guiWidth = 400;
    private static final int guiHeight = 230;
    private static final List<String> cheatsheet = new ArrayList<String>();
    private static final List<List<String>> cheatsheetDesc = new ArrayList<List<String>>();
    private static final String regexTest = "https://regexr.com";
    private int index;
    private LinkedList<String> regexes = new LinkedList();
    private LinkedList<Integer> groups = new LinkedList();
    private GuiTextField regexTextbox;
    private GuiTextField groupTextBox;

    RegexGui() {
        super(230, 400);
        this.regexes.addAll(ConfigManager.INSTANCE.getRegexList());
        this.groups.addAll(ConfigManager.INSTANCE.getGroupList());
        this.index = this.regexes.size() - 1;
    }

    @Override
    public void func_73863_a(int x, int y, float tick) {
        int group;
        super.func_73863_a(x, y, tick);
        this.field_146289_q.func_78276_b("Real time translation mod - Regex list", this.getLeftMargin(), this.getTopMargin(), 0x555555);
        this.field_146289_q.func_78276_b("Regex(Regular expression) are search patterns used to detect messages.", this.getLeftMargin(), this.getYOrigin() + 15, 0x555555);
        this.field_146289_q.func_78276_b("You can use this website to test your regex.", this.getLeftMargin(), this.getYOrigin() + 25, 0x555555);
        this.field_146289_q.func_78276_b("Cheatsheet: (Hover your mouse to see explanation)", this.getLeftMargin(), this.getYOrigin() + 35, 0x555555);
        this.field_146289_q.func_78276_b("TIP: Combine classes and quantifiers together to match several characters", this.getLeftMargin(), this.getYOrigin() + 230 - 40, 0x555555);
        this.field_146289_q.func_78276_b(this.index + 1 + " of " + Math.max(this.index + 1, this.regexes.size()), this.getLeftMargin() + 15 + 40, this.getYOrigin() + 230 - 20, 0x555555);
        String regex = this.regexTextbox.func_146179_b();
        int n = group = this.groupTextBox.func_146179_b().isEmpty() ? -1 : Integer.parseInt(this.groupTextBox.func_146179_b());
        if (this.validateRegex(regex)) {
            if (!this.isRegexConflict(regex)) {
                int groupCount = this.countGroups(regex);
                if (groupCount == 0) {
                    this.field_146289_q.func_78276_b(EnumChatFormatting.YELLOW + "Regex valid, but it needs at least 1 group to detect player names", this.getLeftMargin(), this.getYOrigin() + 230 - 120, 0x555555);
                } else {
                    this.field_146289_q.func_78276_b(EnumChatFormatting.GREEN + "Regex valid! The regex should stop at before the message content", this.getLeftMargin(), this.getYOrigin() + 230 - 120, 0x555555);
                }
                this.field_146289_q.func_78276_b("Possible match: " + this.findMatch(this.getChatLog(), regex), this.getLeftMargin(), this.getYOrigin() + 230 - 110, 0x555555);
                if (groupCount > 0) {
                    this.field_146289_q.func_78276_b("Group number: (1 - " + groupCount + ")", this.getLeftMargin(), this.getYOrigin() + 230 - 80, 0x555555);
                } else {
                    this.field_146289_q.func_78276_b("Group number: (?)", this.getLeftMargin(), this.getYOrigin() + 230 - 80, 0x555555);
                }
                this.field_146289_q.func_78276_b("Matching username: " + this.matchUsername(this.findMatch(this.getChatLog(), regex), regex, group), this.getLeftMargin(), this.getYOrigin() + 230 - 70, 0x555555);
            } else {
                this.field_146289_q.func_78276_b(EnumChatFormatting.RED + "Regex conflict with the mod messages! Please be more specific", this.getLeftMargin(), this.getYOrigin() + 230 - 120, 0x555555);
                this.field_146289_q.func_78276_b("Possible match: ---", this.getLeftMargin(), this.getYOrigin() + 230 - 110, 0x555555);
                this.field_146289_q.func_78276_b("Matching username: ---", this.getLeftMargin(), this.getYOrigin() + 230 - 70, 0x555555);
                this.field_146289_q.func_78276_b("Group number: (?)", this.getLeftMargin(), this.getYOrigin() + 230 - 80, 0x555555);
            }
        } else {
            this.field_146289_q.func_78276_b(EnumChatFormatting.RED + "Regex invalid! Please check your syntax", this.getLeftMargin(), this.getYOrigin() + 230 - 120, 0x555555);
            this.field_146289_q.func_78276_b("Possible match: ---", this.getLeftMargin(), this.getYOrigin() + 230 - 110, 0x555555);
            this.field_146289_q.func_78276_b("Matching username: ---", this.getLeftMargin(), this.getYOrigin() + 230 - 70, 0x555555);
            this.field_146289_q.func_78276_b("Group number: (?)", this.getLeftMargin(), this.getYOrigin() + 230 - 80, 0x555555);
        }
        this.regexTextbox.func_146194_f();
        this.groupTextBox.func_146194_f();
        for (int i = 5; i < this.field_146292_n.size(); ++i) {
            HoveringText button = (HoveringText)((Object)this.field_146292_n.get(i));
            if (!button.func_146115_a()) continue;
            this.func_146283_a(button.getHoverText(), x, y);
        }
    }

    public void func_73866_w_() {
        this.regexTextbox = new GuiTextField(this.field_146289_q, this.getLeftMargin(), this.getYOrigin() + 230 - 100, 390, 15);
        this.regexTextbox.func_146205_d(true);
        this.regexTextbox.func_146203_f(200);
        this.regexTextbox.func_146185_a(true);
        this.regexTextbox.func_146180_a(this.regexes.get(this.index));
        this.regexTextbox.func_146195_b(true);
        this.groupTextBox = new GuiTextField(this.field_146289_q, this.getLeftMargin(), this.getYOrigin() + 230 - 60, 390, 15);
        this.groupTextBox.func_146205_d(true);
        this.groupTextBox.func_146203_f(10);
        this.groupTextBox.func_146185_a(true);
        this.groupTextBox.func_146180_a(Integer.toString(this.groups.get(this.index)));
        Keyboard.enableRepeatEvents((boolean)true);
        this.field_146292_n.add(new TextButton(0, this.getRightMargin(150), this.getYOrigin() + 25, this.getTextWidth(regexTest), regexTest, 170));
        this.field_146292_n.add(new GuiButton(1, this.getLeftMargin() + 5 + 20, this.getYOrigin() + 230 - 5 - 20, 20, 20, "+"));
        this.field_146292_n.add(new GuiButton(2, this.getRightMargin(100), this.getYOrigin() + 230 - 5 - 20, 100, 20, "Save and close"));
        this.field_146292_n.add(new GuiButton(3, this.getLeftMargin(), this.getYOrigin() + 230 - 5 - 20, 20, 20, "<"));
        this.field_146292_n.add(new GuiButton(4, this.getRightMargin(100) - 5 - 100, this.getYOrigin() + 230 - 5 - 20, 100, 20, "Reset to default"));
        this.field_146292_n.add(new HoveringText(5, this.getLeftMargin(), this.getYOrigin() + 45, cheatsheet.get(0), cheatsheetDesc.get(0)));
        this.field_146292_n.add(new HoveringText(6, this.getLeftMargin(), this.getYOrigin() + 55, cheatsheet.get(1), cheatsheetDesc.get(1)));
        this.field_146292_n.add(new HoveringText(7, this.getLeftMargin(), this.getYOrigin() + 65, cheatsheet.get(2), cheatsheetDesc.get(2)));
        this.field_146292_n.add(new HoveringText(8, this.getLeftMargin(), this.getYOrigin() + 75, cheatsheet.get(3), cheatsheetDesc.get(3)));
        this.field_146292_n.add(new HoveringText(9, this.getLeftMargin(), this.getYOrigin() + 85, cheatsheet.get(4), cheatsheetDesc.get(4)));
        this.field_146292_n.add(new HoveringText(10, this.getLeftMargin(), this.getYOrigin() + 95, cheatsheet.get(5), cheatsheetDesc.get(5)));
        this.field_146292_n.add(new HoveringText(11, this.getLeftMargin() + 210, this.getYOrigin() + 45, cheatsheet.get(6), cheatsheetDesc.get(6)));
        this.field_146292_n.add(new HoveringText(12, this.getLeftMargin() + 210, this.getYOrigin() + 55, cheatsheet.get(7), cheatsheetDesc.get(7)));
        this.field_146292_n.add(new HoveringText(13, this.getLeftMargin() + 210, this.getYOrigin() + 65, cheatsheet.get(8), cheatsheetDesc.get(8)));
        this.field_146292_n.add(new HoveringText(14, this.getLeftMargin() + 210, this.getYOrigin() + 75, cheatsheet.get(9), cheatsheetDesc.get(9)));
        this.field_146292_n.add(new HoveringText(15, this.getLeftMargin() + 210, this.getYOrigin() + 85, cheatsheet.get(10), cheatsheetDesc.get(10)));
    }

    public void func_146284_a(GuiButton button) {
        Keyboard.enableRepeatEvents((boolean)false);
        switch (button.field_146127_k) {
            case 0: {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, regexTest, 0, false));
                break;
            }
            case 1: {
                this.regexes.set(this.index, this.regexTextbox.func_146179_b());
                if (this.groupTextBox.func_146179_b().trim().isEmpty()) {
                    this.groups.set(this.index, 0);
                } else {
                    this.groups.set(this.index, Integer.parseInt(this.groupTextBox.func_146179_b()));
                }
                ++this.index;
                if (this.index == this.regexes.size()) {
                    button.field_146124_l = false;
                    this.regexes.add("");
                    this.groups.add(1);
                    this.regexTextbox.func_146180_a("");
                    this.groupTextBox.func_146180_a("1");
                } else {
                    this.regexTextbox.func_146180_a(this.regexes.get(this.index));
                    this.groupTextBox.func_146180_a(this.groups.get(this.index).toString());
                    button.field_146126_j = ">";
                    button.field_146124_l = true;
                }
                if (this.index >= this.regexes.size() - 1) {
                    button.field_146126_j = "+";
                }
                ((GuiButton)this.field_146292_n.get((int)3)).field_146124_l = true;
                this.regexTextbox.func_146195_b(true);
                this.regexTextbox.func_146202_e();
                Keyboard.enableRepeatEvents((boolean)true);
                break;
            }
            case 2: {
                this.regexes.set(this.index, this.regexTextbox.func_146179_b());
                if (this.groupTextBox.func_146179_b().trim().isEmpty()) {
                    this.groups.set(this.index, 0);
                } else {
                    this.groups.set(this.index, Integer.parseInt(this.groupTextBox.func_146179_b()));
                }
                this.applySettings();
                this.field_146297_k.func_147108_a(null);
                break;
            }
            case 3: {
                if (this.regexTextbox.func_146179_b().trim().isEmpty() || this.groupTextBox.func_146179_b().isEmpty()) {
                    this.regexes.remove(this.index);
                    this.groups.remove(this.index);
                } else {
                    this.regexes.set(this.index, this.regexTextbox.func_146179_b());
                    this.groups.set(this.index, Integer.parseInt(this.groupTextBox.func_146179_b()));
                }
                --this.index;
                if (this.index == 0) {
                    button.field_146124_l = false;
                }
                ((GuiButton)this.field_146292_n.get((int)1)).field_146126_j = this.regexes.size() - 1 == this.index ? "+" : ">";
                ((GuiButton)this.field_146292_n.get((int)1)).field_146124_l = true;
                this.regexTextbox.func_146180_a(this.regexes.get(this.index));
                this.groupTextBox.func_146180_a(this.groups.get(this.index).toString());
                this.regexTextbox.func_146195_b(true);
                this.regexTextbox.func_146202_e();
                Keyboard.enableRepeatEvents((boolean)true);
                break;
            }
            case 4: {
                ((GuiButton)this.field_146292_n.get((int)3)).field_146124_l = true;
                ((GuiButton)this.field_146292_n.get((int)1)).field_146126_j = "+";
                this.regexes.clear();
                this.regexes.addAll(Arrays.asList(ConfigManager.defaultRegex));
                this.groups.clear();
                this.groups.addAll(Ints.asList((int[])ConfigManager.defaultGroups));
                this.index = this.regexes.size() - 1;
                this.regexTextbox.func_146180_a(this.regexes.get(this.index));
                this.groupTextBox.func_146180_a(this.groups.get(this.index).toString());
                this.regexTextbox.func_146195_b(true);
                this.regexTextbox.func_146202_e();
                Keyboard.enableRepeatEvents((boolean)true);
            }
        }
    }

    public void func_73869_a(char typedchar, int keycode) {
        this.regexTextbox.func_146201_a(typedchar, keycode);
        if (this.groupTextBox.func_146206_l() && (typedchar >= '0' && typedchar <= '9' || typedchar == '\b')) {
            if (this.groupTextBox.func_146179_b().isEmpty() && typedchar != '0') {
                this.groupTextBox.func_146201_a(typedchar, keycode);
            } else if (!this.groupTextBox.func_146179_b().isEmpty()) {
                this.groupTextBox.func_146201_a(typedchar, keycode);
            }
        }
        if (keycode == 18 && !this.regexTextbox.func_146206_l()) {
            this.field_146297_k.func_147108_a(null);
        } else {
            super.func_73869_a(typedchar, keycode);
        }
    }

    public void func_73864_a(int x, int y, int state) {
        super.func_73864_a(x, y, state);
        this.regexTextbox.func_146192_a(x, y, state);
        this.groupTextBox.func_146192_a(x, y, state);
    }

    public void func_73878_a(boolean userClicked, int userResponse) {
        if (userResponse == 0) {
            if (userClicked) {
                this.openLink();
            }
            this.field_146297_k.func_147108_a((GuiScreen)this);
        }
    }

    private void openLink() {
        if (!Desktop.isDesktopSupported()) {
            Log.logger.error("Cannot open link");
            return;
        }
        Desktop desktop = Desktop.getDesktop();
        try {
            desktop.browse(new URI(regexTest));
        }
        catch (IOException | URISyntaxException e) {
            Log.logger.error("Cannot open link");
        }
    }

    private boolean validateRegex(String regex) {
        if (regex == null) {
            return false;
        }
        if (regex.trim().isEmpty()) {
            return false;
        }
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            return false;
        }
        return true;
    }

    private int countGroups(String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher("Reality is a shitty game! -Katsuragi Keima");
        return matcher.groupCount();
    }

    private boolean isRegexConflict(String regex) {
        if (!regex.contains("^")) {
            regex = "^" + regex;
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(testMessage);
        return matcher.find();
    }

    private List<String> getChatLog() {
        List fullChatLog = (List)ObfuscationReflectionHelper.getPrivateValue(GuiNewChat.class, (Object)Minecraft.func_71410_x().field_71456_v.func_146158_b(), (String[])new String[]{"field_146252_h"});
        ArrayList<String> chatLog = new ArrayList<String>();
        for (int i = 0; i < Math.min(fullChatLog.size(), 20); ++i) {
            chatLog.add(((ChatLine)fullChatLog.get(i)).func_151461_a().func_150260_c().replaceAll("\u00c2\u00a7(.)", ""));
        }
        return chatLog;
    }

    private String findMatch(List<String> chatLog, String regex) {
        if (!regex.contains("^")) {
            regex = "^" + regex;
        }
        Pattern pattern = Pattern.compile(regex);
        for (String message : chatLog) {
            String matchMessage;
            Matcher matcher = pattern.matcher(message);
            if (!matcher.find()) continue;
            String shorten = matchMessage = EnumChatFormatting.GREEN + matcher.group(0) + EnumChatFormatting.DARK_GRAY + message.replace(matcher.group(0), "");
            for (int i = this.getTextWidth(matchMessage); i > 120; --i) {
                shorten = shorten.substring(0, matchMessage.length() - 1);
            }
            shorten = shorten + "...";
            return matchMessage.length() < shorten.length() ? matchMessage : shorten;
        }
        return EnumChatFormatting.RED + "No match from chat log :(";
    }

    private String matchUsername(String message, String regex, int group) {
        if (group == -1 || group > this.countGroups(regex) || message.equals(EnumChatFormatting.RED + "Can't find player username :(")) {
            return "---";
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(message);
        if (!matcher.find()) {
            return EnumChatFormatting.RED + "Can't find player username :(";
        }
        return matcher.group(group);
    }

    private void applySettings() {
        for (int i = 0; i < this.regexes.size(); ++i) {
            if (!this.validateRegex(this.regexes.get(i)) || this.isRegexConflict(this.regexes.get(i))) {
                this.regexes.remove(i);
                this.groups.remove(i);
                --i;
                continue;
            }
            int groupCount = this.countGroups(this.regexes.get(i));
            if (groupCount >= this.groups.get(i)) continue;
            this.regexes.remove(i);
            this.groups.remove(i);
            --i;
        }
        ConfigManager.INSTANCE.setRegexList(this.regexes);
        ConfigManager.INSTANCE.setGroupList(this.groups);
        ConfigManager.INSTANCE.syncConfig();
        ChatUtil.printChatMessage(true, "Regex list applied", EnumChatFormatting.WHITE);
    }

    static {
        for (int i = 0; i < 12; ++i) {
            cheatsheetDesc.add(new ArrayList());
        }
        cheatsheet.add(". - Matches any character");
        cheatsheetDesc.get(0).add("Matches any character");
        cheatsheetDesc.get(0).add("The only exception is the newline character (\\n)");
        cheatsheetDesc.get(0).add("Newlines are not used in chat so it doesn't matter");
        cheatsheet.add("\\w - Matches word");
        cheatsheetDesc.get(1).add("Matches all alphabets (Both capital and small), numbers and underscore");
        cheatsheetDesc.get(1).add("Minecraft usernames are based on words. They are perfect to detect player names");
        cheatsheet.add("\\d - Digit");
        cheatsheetDesc.get(2).add("Matches all numbers");
        cheatsheet.add("[a-g] - Match character in range");
        cheatsheetDesc.get(3).add("Matches any characters in tis specific range");
        cheatsheetDesc.get(3).add("Example: [a-g]");
        cheatsheetDesc.get(3).add("\u2713 " + EnumChatFormatting.GREEN + "a");
        cheatsheetDesc.get(3).add("\u2713 " + EnumChatFormatting.GREEN + "b");
        cheatsheetDesc.get(3).add("\u2717 " + EnumChatFormatting.RED + "z");
        cheatsheet.add("* - Matches 0 or more");
        cheatsheetDesc.get(4).add("Matches 0 or more of its character class");
        cheatsheetDesc.get(4).add("Example: N\\w*");
        cheatsheetDesc.get(4).add("\u2713 " + EnumChatFormatting.GREEN + "N");
        cheatsheetDesc.get(4).add("\u2713 " + EnumChatFormatting.GREEN + "No");
        cheatsheetDesc.get(4).add("\u2713 " + EnumChatFormatting.GREEN + "Notch");
        cheatsheet.add("+ - Matches 1 or more");
        cheatsheetDesc.get(5).add("Matches 1 or more of a character/group");
        cheatsheetDesc.get(5).add("Example: N\\w+");
        cheatsheetDesc.get(5).add("\u2717 " + EnumChatFormatting.RED + "N");
        cheatsheetDesc.get(5).add("\u2713 " + EnumChatFormatting.GREEN + "No");
        cheatsheetDesc.get(5).add("\u2713 " + EnumChatFormatting.GREEN + "Notch");
        cheatsheet.add("? - Optional");
        cheatsheetDesc.get(6).add("Exactly as the name suggests");
        cheatsheetDesc.get(6).add("Example: (VIP )?\\w+");
        cheatsheetDesc.get(6).add("\u2713 " + EnumChatFormatting.GREEN + "VIP PlayerName");
        cheatsheetDesc.get(6).add("\u2713 " + EnumChatFormatting.GREEN + "PlayerName");
        cheatsheet.add("{2,} - Matches n or more");
        cheatsheetDesc.get(7).add("Matches a group/character n times or more");
        cheatsheetDesc.get(7).add("Add a number after the comma if you want the it match x to y times");
        cheatsheetDesc.get(7).add("Or omit the comma if you want the it match exactly n times");
        cheatsheetDesc.get(7).add("Example: Level \\d{1,3}");
        cheatsheetDesc.get(7).add("\u2713 " + EnumChatFormatting.GREEN + "Level 1");
        cheatsheetDesc.get(7).add("\u2713 " + EnumChatFormatting.GREEN + "Level 420");
        cheatsheetDesc.get(7).add("\u2717 " + EnumChatFormatting.RED + "Level 42069");
        cheatsheet.add("| - Either");
        cheatsheetDesc.get(8).add("Must match either of them, but not both.");
        cheatsheetDesc.get(8).add("Example: (Dead)|(Alive) (\\w+)");
        cheatsheetDesc.get(8).add("\u2713 " + EnumChatFormatting.GREEN + "Dead PlayerName");
        cheatsheetDesc.get(8).add("\u2713 " + EnumChatFormatting.GREEN + "Alive PlayerName");
        cheatsheetDesc.get(8).add("\u2717 " + EnumChatFormatting.RED + "DeadAlive PlayerName");
        cheatsheet.add("() - Group");
        cheatsheetDesc.get(9).add("Think of groups as parentheses like in mathematics");
        cheatsheetDesc.get(9).add("They also have a second function. Capture groups.");
        cheatsheetDesc.get(9).add("By specifying the group number below, the mod can know which group");
        cheatsheetDesc.get(9).add(" contains the player's username");
        cheatsheet.add("\\ - Escape character");
        cheatsheetDesc.get(10).add("If you need to capture special characters mentioned in this list,");
        cheatsheetDesc.get(10).add(" you will need to add an extra backslash to escape them.");
        cheatsheetDesc.get(10).add("Correct:" + EnumChatFormatting.GREEN + " \\(VIP\\) \\w+");
        cheatsheetDesc.get(10).add("Wrong:" + EnumChatFormatting.RED + " (VIP) \\w+");
    }

    public class HoveringText
    extends GuiButton {
        private final List<String> hoverText;

        public HoveringText(int buttonId, int x, int y, String buttonText, List<String> hoverText) {
            super(buttonId, x, y, buttonText);
            this.hoverText = hoverText;
            this.field_146121_g = 10;
            this.field_146120_f = RegexGui.this.getTextWidth(buttonText);
        }

        public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            mc.field_71466_p.func_85187_a(this.field_146126_j, this.field_146128_h, this.field_146129_i, 0x555555, false);
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
        }

        List<String> getHoverText() {
            return this.hoverText;
        }
    }
}

