/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.translate;

import com.ringosham.translationmod.client.types.Language;
import com.ringosham.translationmod.common.ChatUtil;
import com.ringosham.translationmod.common.ConfigManager;
import com.ringosham.translationmod.translate.Translator;
import com.ringosham.translationmod.translate.types.TranslateResult;
import net.minecraft.util.EnumChatFormatting;

public class Retranslate
extends Thread {
    private final String message;
    private final Language from;
    private final Language to;
    private final String sender;

    public Retranslate(String sender, String message, Language from, Language to) {
        this.sender = sender;
        this.message = message;
        this.from = from;
        this.to = to;
    }

    @Override
    public void run() {
        Translator translator = new Translator(this.message, this.from, this.to);
        if (this.from == this.to) {
            return;
        }
        TranslateResult translatedMessage = translator.translate(this.message.trim());
        if (translatedMessage == null) {
            ChatUtil.printChatMessage(true, "An error occurred during translation", EnumChatFormatting.RED);
            return;
        }
        String fromStr = null;
        if (translatedMessage.getFromLanguage() != null) {
            fromStr = translatedMessage.getFromLanguage().getName();
        }
        String chatMessage = this.sender + " --> " + (fromStr == null ? "Unknown" : fromStr) + ": " + translatedMessage.getMessage();
        String hoverText = "Sender: " + this.sender + "\nTranslation: " + (fromStr == null ? "Unknown" : fromStr) + " -> " + this.to.getName();
        if (translatedMessage.getMessage().trim().equals(this.message.trim())) {
            ChatUtil.printChatMessage(true, "Translation failed. Try another language maybe?", EnumChatFormatting.RED);
            return;
        }
        ChatUtil.printChatMessageAdvanced(chatMessage, hoverText, ConfigManager.INSTANCE.isBold(), ConfigManager.INSTANCE.isItalic(), ConfigManager.INSTANCE.isUnderline(), EnumChatFormatting.func_96300_b((String)ConfigManager.INSTANCE.getColor()));
    }
}

