/*
 * Decompiled with CFR 0.152.
 */
package com.ringosham.translationmod.translate;

import com.ringosham.translationmod.common.ChatUtil;
import com.ringosham.translationmod.common.ConfigManager;
import com.ringosham.translationmod.common.Log;
import com.ringosham.translationmod.translate.Translator;
import com.ringosham.translationmod.translate.types.SignText;
import com.ringosham.translationmod.translate.types.TranslateResult;
import net.minecraft.util.EnumChatFormatting;

public class SignTranslate
extends Thread {
    private String text;
    private int x;
    private int y;
    private int z;

    public SignTranslate(String text, int x, int y, int z) {
        this.text = text;
        if (this.x == x && this.y == y && this.z == z) {
            return;
        }
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public void run() {
        Log.logger.debug("Sign detected. Translating");
        SignText signData = new SignText();
        signData.setSign(this.text, this.x, this.y, this.z);
        Translator translator = new Translator(this.text, null, ConfigManager.INSTANCE.getTargetLanguage());
        TranslateResult translatedMessage = translator.translate(this.text);
        if (translatedMessage == null) {
            return;
        }
        String chatMessage = "[Sign] --> " + translatedMessage.getFromLanguage().getName() + ": " + translatedMessage.getMessage();
        String hoverText = "Sign location: " + this.x + ", " + this.y + ", " + this.z + "\nTranslation: " + translatedMessage.getFromLanguage().getName() + " -> " + ConfigManager.INSTANCE.getTargetLanguage().getName();
        ChatUtil.printChatMessageAdvanced(chatMessage, hoverText, ConfigManager.INSTANCE.isBold(), ConfigManager.INSTANCE.isItalic(), ConfigManager.INSTANCE.isUnderline(), EnumChatFormatting.func_96300_b((String)ConfigManager.INSTANCE.getColor()));
    }
}

