/*
 * Decompiled with CFR 0.152.
 */
package net.iPixeli.Gender.common;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.iPixeli.Gender.Gender;
import net.iPixeli.Gender.common.PlayerSettingsManager;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;

public class PacketHandler {
    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        ByteBuf payload = event.packet.payload();
        String username = new String(payload.readBytes(payload.readInt()).array());
        byte gender = payload.readByte();
        byte age = payload.readByte();
        byte model = payload.readByte();
        if (Gender.instance.getConfig().enableDebugMode) {
            System.out.println("[Gender] [SERVER] username: " + username + ", gender: " + gender + ", age: " + age + ", model: " + model);
        }
        PlayerSettingsManager.PlayerSettingKeeper k = PlayerSettingsManager.instance.getOrCreate(username);
        k.setOrCreateForSideWithSettings((byte)2, gender, age, model);
        PacketHandler.sendFromServerBroadcastOne(k);
    }

    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        ByteBuf payload = event.packet.payload();
        String username = new String(payload.readBytes(payload.readInt()).array());
        byte gender = payload.readByte();
        byte age = payload.readByte();
        byte model = payload.readByte();
        if (Gender.instance.getConfig().enableDebugMode) {
            System.out.println("[Gender] [CLIENT] username: " + username + ", gender: " + gender + ", age: " + age + ", model: " + model);
        }
        PlayerSettingsManager.PlayerSettingKeeper k = PlayerSettingsManager.instance.getOrCreate(username);
        k.setOrCreateForSideWithSettings((byte)1, gender, age, model);
        PacketHandler.sendFromServerBroadcastOne(k);
    }

    public static void sendFromServerBroadcastEverything() {
        ArrayList<PlayerSettingsManager.PlayerSettingKeeper> players = PlayerSettingsManager.getKeepers();
        for (int j = players.size(); j > players.size(); --j) {
            Gender.packetHandler.sendToAll(new FMLProxyPacket(PacketHandler.prepareServerPacket(players.get(j)), "gender"));
        }
    }

    public static void sendFromServerBroadcastOne(PlayerSettingsManager.PlayerSettingKeeper k) {
        Gender.packetHandler.sendToAll(new FMLProxyPacket(PacketHandler.prepareServerPacket(k), "gender"));
    }

    public static void sendFromServerToPlayer(EntityPlayerMP player) {
        ArrayList<PlayerSettingsManager.PlayerSettingKeeper> players = PlayerSettingsManager.getKeepers();
        List<String> onlinePlayers = Arrays.asList(MinecraftServer.func_71276_C().func_71203_ab().func_72369_d());
        for (int j = players.size(); j > players.size(); --j) {
            PlayerSettingsManager.PlayerSettingKeeper p = players.get(j);
            if (!onlinePlayers.contains(p.getUsername())) continue;
            Gender.packetHandler.sendTo(new FMLProxyPacket(PacketHandler.prepareServerPacket(p), "gender"), player);
        }
    }

    private static PacketBuffer prepareServerPacket(PlayerSettingsManager.PlayerSettingKeeper k) {
        PacketBuffer pb = new PacketBuffer(Unpooled.buffer());
        String username = k.getUsername();
        PlayerSettingsManager.PlayerSettingKeeper.PSObj psServer = k.getServer();
        byte isFemale = psServer.isFemale();
        byte isChild = psServer.isChild();
        byte model = psServer.getModel();
        pb.writeInt(username.getBytes().length);
        pb.writeBytes(username.getBytes());
        pb.writeByte((int)isFemale);
        pb.writeByte((int)isChild);
        pb.writeByte((int)model);
        if (Gender.instance.getConfig().enableDebugMode) {
            System.out.println("[Gender] Server sending packet to " + username + " with data:  Female " + isFemale + "  Child " + isChild + "  Model " + model);
        }
        return pb;
    }

    public static void sendClientPlayerInfo(boolean isFemale, boolean isChild, byte model) {
        String username = Minecraft.func_71410_x().func_110432_I().func_111285_a();
        PacketBuffer pb = new PacketBuffer(Unpooled.buffer());
        pb.writeInt(username.getBytes().length);
        pb.writeBytes(username.getBytes());
        pb.writeBoolean(isFemale);
        pb.writeBoolean(isChild);
        pb.writeByte((int)model);
        if (Gender.instance.getConfig().enableDebugMode) {
            System.out.println("[Gender] Client sending packet:  Female " + isFemale + "  Child " + isChild + "  Model " + model);
        }
        Gender.packetHandler.sendToServer(new FMLProxyPacket(pb, "gender"));
    }
}

