/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge;

import com.endertech.minecraft.forge.math.ForgeMath;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.units.BlockState;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class ForgeWorld {
    public static void explodeBlock(World world, BlockPos pos, @Nullable Entity exploder, float strength, boolean fire) {
        world.func_72885_a(exploder, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), strength, fire, fire);
        world.func_175698_g(pos);
    }

    public static boolean isServerSide(World world) {
        return world != null && !world.field_72995_K;
    }

    public static boolean isClientSide(World world) {
        return world != null && world.field_72995_K;
    }

    @Nullable
    public static Entity findEntity(World world, int id) {
        return world != null ? world.func_73045_a(id) : null;
    }

    public static Block getBlock(World world, BlockPos pos) {
        if (world != null && pos != null) {
            return world.func_180495_p(pos).func_177230_c();
        }
        return Blocks.field_150350_a;
    }

    public static Vect3d getBlockCenter(BlockPos pos) {
        return Vect3d.from(pos).add(ForgeMath.getBBCenter(Block.field_185505_j));
    }

    public static int getBlockMeta(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return ForgeWorld.getBlock(world, pos).func_176201_c(state);
    }

    public static BlockState getBlockState(World world, BlockPos pos) {
        return BlockState.from(world.func_180495_p(pos));
    }

    public static boolean isVerticalOpaque(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) && state.isSideSolid((IBlockAccess)world, pos, EnumFacing.DOWN);
    }

    public static boolean isHorizOpaque(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return state.isSideSolid((IBlockAccess)world, pos, EnumFacing.WEST) && state.isSideSolid((IBlockAccess)world, pos, EnumFacing.EAST) && state.isSideSolid((IBlockAccess)world, pos, EnumFacing.SOUTH) && state.isSideSolid((IBlockAccess)world, pos, EnumFacing.NORTH);
    }

    @Nullable
    public static TileEntity getTileEntity(World world, BlockPos pos) {
        return world != null && pos != null ? world.func_175625_s(pos) : null;
    }

    public static void spawnParticle(World world, EnumParticleTypes type, Vect3d pos, Vect3d motion) {
        if (world != null) {
            world.func_175688_a(type, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z, new int[0]);
        }
    }

    @Nullable
    public static RayTraceResult rayTraceBlocks(World world, Vect3d curPos, Vect3d nextPos, boolean includeLiquids) {
        return world.func_72901_a(curPos.toVec3d(), nextPos.toVec3d(), includeLiquids);
    }

    public static class SnowMelter {
        public static boolean isSnow(World world, BlockPos pos) {
            return world.func_180495_p(pos).func_177230_c() == Blocks.field_150431_aC;
        }

        private static BlockPos getSnowTopPos(World world, BlockPos startPos) {
            int offset = 1;
            while (SnowMelter.isSnow(world, startPos.func_177981_b(offset))) {
                ++offset;
            }
            return startPos.func_177981_b(offset - 1);
        }

        public static void meltLayerAt(World world, BlockPos pos) {
            if (SnowMelter.isSnow(world, pos)) {
                BlockPos meltPos = SnowMelter.getSnowTopPos(world, pos);
                IBlockState state = world.func_180495_p(meltPos);
                int layersAmount = (Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a);
                if (layersAmount > 1) {
                    world.func_175656_a(meltPos, state.func_177226_a((IProperty)BlockSnow.field_176315_a, (Comparable)Integer.valueOf(layersAmount - 1)));
                } else {
                    world.func_175698_g(meltPos);
                }
            }
        }
    }

    public static class Position {
        public static List<BlockPos> getAllAround(BlockPos pos, boolean includeCorners) {
            ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
            posList.add(pos.func_177976_e());
            posList.add(pos.func_177974_f());
            posList.add(pos.func_177978_c());
            posList.add(pos.func_177968_d());
            if (includeCorners) {
                posList.add(pos.func_177976_e().func_177978_c());
                posList.add(pos.func_177976_e().func_177968_d());
                posList.add(pos.func_177974_f().func_177978_c());
                posList.add(pos.func_177974_f().func_177968_d());
            }
            return posList;
        }

        public static double getDistance(BlockPos posA, BlockPos posB) {
            return Vect3d.distance(Vect3d.from(posA), Vect3d.from(posB));
        }
    }
}

