/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.economy;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.ForgeStack;
import com.endertech.minecraft.forge.units.ItemState;
import com.endertech.minecraft.forge.units.UnitId;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.fml.common.registry.VillagerRegistry;

public abstract class ForgeTrades {
    public static final float USED_ITEM_DISCOUNT = 0.75f;
    protected static final String KEY_BARGAINS = "bargains";
    protected final ForgeMod mod;
    private final Map<Careers, UnitConfig> configs = new EnumMap<Careers, UnitConfig>(Careers.class);
    private final Map<Careers, Map<Skills, List<Bargain>>> bargains = ForgeTrades.newCareersEnumMap();
    public final Definitions definitions = new Definitions();

    public ForgeTrades(ForgeMod mod) {
        this.mod = mod;
        Path baseDir = mod.getConfig().getConfigDir().resolve("Trades");
        for (Careers career : Careers.values()) {
            UnitConfig config = new UnitConfig(baseDir, career.name());
            this.configs.put(career, config);
        }
    }

    protected static <B> Map<Careers, Map<Skills, List<B>>> newCareersEnumMap() {
        EnumMap<Careers, Map<Skills, List<B>>> careersMap = new EnumMap<Careers, Map<Skills, List<B>>>(Careers.class);
        for (Careers career : Careers.values()) {
            EnumMap skillsMap = new EnumMap(Skills.class);
            for (Skills skill : Skills.values()) {
                skillsMap.put(skill, new ArrayList());
            }
            careersMap.put(career, skillsMap);
        }
        return careersMap;
    }

    public void init() {
        for (Careers career : Careers.values()) {
            UnitConfig config = this.configs.get((Object)career);
            for (Skills skill : Skills.values()) {
                String[] array = config.getStrArray(skill.toString(), KEY_BARGAINS, this.definitions.toArray(career, skill), "List of all possible bargains for this career and skill.");
                if (array != null) {
                    for (String string : array) {
                        this.addBargain(career, skill, Bargain.from(string));
                    }
                }
                TradeList tradeList = new TradeList(skill, this.getBargainList(career, skill));
                career.instance.addTrade(skill.level, new EntityVillager.ITradeList[]{tradeList});
            }
            config.save();
        }
    }

    protected List<Bargain> getBargainList(Careers career, Skills skill) {
        return this.bargains.get((Object)career).get((Object)skill);
    }

    protected void addBargain(Careers career, Skills skill, ItemState buy, ItemState sell, Exchange exchange) {
        Bargain bargain = Bargain.from(buy.toStack(exchange.buyAmount), sell.toStack(exchange.sellAmount));
        this.addBargain(career, skill, bargain);
    }

    protected void addBargain(Careers career, Skills skill, Bargain bargain) {
        if (bargain != null && bargain.isValid()) {
            this.getBargainList(career, skill).add(bargain);
        } else {
            this.mod.getLogger().error("Invalid bargain: {}", new Object[]{bargain});
        }
    }

    public void clearVanillaTradesList(Careers career) {
        try {
            Field field = career.instance.getClass().getDeclaredField("trades");
            field.setAccessible(true);
            field.set(career.instance, Lists.newArrayList());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<Careers, UnitConfig> getConfigs() {
        return Collections.unmodifiableMap(this.configs);
    }

    public List<Bargain> getBargains(Careers career, Skills skill) {
        return Collections.unmodifiableList(this.getBargainList(career, skill));
    }

    protected static class TradeList
    implements EntityVillager.ITradeList {
        private final Skills skill;
        private final List<Bargain> bargains;

        public TradeList(Skills skill, List<Bargain> bargains) {
            this.skill = skill;
            this.bargains = bargains;
        }

        public void func_179401_a(MerchantRecipeList recipeList, Random random) {
            ArrayList<Bargain> pickedBargains = new ArrayList<Bargain>();
            int amount = ForgeBounds.BARGAINS_PER_TRADER.getIntBounds().randomBetween() * this.skill.level;
            if (this.bargains.size() <= amount) {
                pickedBargains.addAll(this.bargains);
            } else {
                for (int count = 0; count < amount; ++count) {
                    Bargain randomBargain = CommonMath.Random.from(this.bargains);
                    if (pickedBargains.contains(randomBargain)) continue;
                    pickedBargains.add(randomBargain);
                }
            }
            recipeList.clear();
            for (Bargain bargain : pickedBargains) {
                recipeList.add((Object)new MerchantRecipe(bargain.sell.toItemStack(), bargain.buy.toItemStack()));
            }
        }
    }

    public static class Definitions {
        private Map<Careers, Map<Skills, List<String>>> definitions = ForgeTrades.newCareersEnumMap();
        private Careers career;
        private Skills skill;

        public Definitions forCareer(Careers career) {
            this.career = career;
            return this;
        }

        public Definitions withSkill(Skills skill) {
            this.skill = skill;
            return this;
        }

        public Definitions add(String definition) {
            this.definitions.get((Object)this.career).get((Object)this.skill).add(definition);
            return this;
        }

        public String[] toArray(Careers career, Skills skill) {
            return this.definitions.get((Object)career).get((Object)skill).toArray(new String[0]);
        }
    }

    public static class Bargain {
        public static final Bargain EMPTY = Bargain.from(ForgeStack.EMPTY, ForgeStack.EMPTY);
        public final ForgeStack buy;
        public final ForgeStack sell;

        protected Bargain(ForgeStack buy, ForgeStack sell) {
            this.buy = buy;
            this.sell = sell;
        }

        public static Bargain from(ForgeStack buy, ForgeStack sell) {
            return new Bargain(buy, sell);
        }

        public static String definition(UnitId buy, UnitId sell, Exchange exchange) {
            return Args.join(buy, exchange.buyAmount, sell, exchange.sellAmount);
        }

        public static Bargain from(String definition) {
            String[] args = Args.split(definition);
            try {
                int buyAmount = Integer.valueOf(args[1]);
                ForgeStack buy = UnitId.from(args[0]).getItemState().toStack(buyAmount);
                int sellAmount = Integer.valueOf(args[3]);
                ForgeStack sell = UnitId.from(args[2]).getItemState().toStack(sellAmount);
                if (buy.exists() && sell.exists()) {
                    return new Bargain(buy, sell);
                }
            }
            catch (Exception e) {
                ForgeMain.instance.getLogger().error("Wrong bargain info in string: '{}'", new Object[]{definition});
            }
            return EMPTY;
        }

        public boolean isValid() {
            return this.buy.exists() && ForgeBounds.STACK_SIZE.getIntBounds().encloses(this.buy.getAmount()) && this.sell.exists() && ForgeBounds.STACK_SIZE.getIntBounds().encloses(this.sell.getAmount());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Bargain) {
                Bargain bargain = (Bargain)obj;
                return bargain.buy.equals(this.buy) && bargain.sell.equals(this.sell);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.buy, this.sell);
        }

        public String toString() {
            return Bargain.class.getSimpleName() + Args.group(this.buy, this.sell);
        }
    }

    public static enum Skills {
        AMATEUR(1),
        FENCE(2),
        MAGNATE(3);

        public static final float BASE_DISCOUNT = 0.05f;
        public static final float BASE_USED_ITEM_FACTOR = 0.25f;
        private final int level;

        private Skills(int level) {
            this.level = level;
        }

        public float discountPrice(float price) {
            return price - price * 0.05f * (float)this.level;
        }

        public float usedItemPrice(float price) {
            return price * 0.25f * (float)this.level;
        }

        public String toString() {
            return String.format("LEVEL %d - %s", this.level, this.name());
        }
    }

    public static enum Careers {
        FARMER(Professions.FARMER, 0),
        FISHERMAN(Professions.FARMER, 1),
        SHEPHERD(Professions.FARMER, 2),
        FLETCHER(Professions.FARMER, 3),
        LIBRARIAN(Professions.LIBRARIAN, 0),
        CARTOGRAPHER(Professions.LIBRARIAN, 1),
        CLERIC(Professions.PRIEST, 0),
        ARMOR_SMITH(Professions.SMITH, 0),
        WEAPON_SMITH(Professions.SMITH, 1),
        TOOL_SMITH(Professions.SMITH, 2),
        BUTCHER(Professions.BUTCHER, 0),
        TANNER(Professions.BUTCHER, 1),
        NITWIT(Professions.NITWIT, 0);

        public final VillagerRegistry.VillagerCareer instance;

        private Careers(Professions profession, int id) {
            this.instance = profession.instance.getCareer(id);
        }
    }

    protected static enum Professions {
        FARMER,
        LIBRARIAN,
        PRIEST,
        SMITH,
        BUTCHER,
        NITWIT;

        public final VillagerRegistry.VillagerProfession instance = (VillagerRegistry.VillagerProfession)VillagerRegistry.instance().getRegistry().getValue(this.toResLoc());

        public ResourceLocation toResLoc() {
            UnitId id = UnitId.from("minecraft", this.name());
            return id.toResLoc();
        }
    }

    public class Exchange {
        public final int buyAmount;
        public final int sellAmount;

        public Exchange(float buyPrice, float sellPrice) {
            if (buyPrice < sellPrice) {
                this.buyAmount = Math.round(sellPrice / buyPrice);
                this.sellAmount = 1;
            } else {
                this.buyAmount = 1;
                this.sellAmount = Math.round(buyPrice / sellPrice);
            }
        }
    }
}

