/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.math;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.math.ForgeTime;

public class Combustion {
    private long ticksFireInfluenced = 0L;
    private long ticksBurning = 0L;
    private boolean burning = false;

    public void update(boolean fireInfluenced) {
        if (fireInfluenced) {
            ++this.ticksFireInfluenced;
        } else if (this.ticksFireInfluenced > 0L) {
            --this.ticksFireInfluenced;
        }
        this.ticksBurning = this.isBurning() ? ++this.ticksBurning : 0L;
    }

    public void fire() {
        this.setBurning(true);
    }

    public void extinguish() {
        this.setBurning(false);
    }

    public CommonTime.Time getFireInfluencedTime() {
        return ForgeTime.fromServerTicks(this.ticksFireInfluenced);
    }

    public CommonTime.Time getBurningTime() {
        return ForgeTime.fromServerTicks(this.ticksBurning);
    }

    public boolean isBurning() {
        return this.burning;
    }

    public void setBurning(boolean burning) {
        this.burning = burning;
    }
}

