/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.ForgeWorld;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.materials.CraftingRecipe;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.messages.UpdateBlockMsg;
import com.endertech.minecraft.forge.units.ForgeBlock;
import com.endertech.minecraft.forge.units.IRelatedUnitId;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.Main;
import com.endertech.minecraft.mods.adchimneys.WorldData;
import com.endertech.minecraft.mods.adchimneys.smoke.Conductor;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.smoke.SmokeParticle;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Chimney
extends ForgeBlock
implements IRelatedUnitId {
    protected static final double WALL_THICKNESS = 0.125;
    protected static final AxisAlignedBB AABB_WALL_NORTH = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.125);
    protected static final AxisAlignedBB AABB_WALL_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.875, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_EAST = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB AABB_WALL_WEST = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 1.0, 1.0);
    private final Conductor conductor;
    public static int MAX_ACTIVE_THREADS_AMOUNT = 0;
    private static AtomicInteger activeThreadsAmount = new AtomicInteger(0);

    public Chimney(ForgeMod mod, UnitConfig config, String name, UnitId relatedBlockId, float patency, ColorARGB smokeAddColor, int stackSize) {
        super(mod, config, name, Material.field_151576_e, (CreativeTabs)Main.CHIMNEYS_TAB);
        this.conductor = new Conductor(config, relatedBlockId, smokeAddColor, patency);
        this.func_149675_a(true);
        this.func_149663_c(UnitId.buildRegName((String[])new String[]{this.getId().getRegName(), ((Object)((Object)this)).getClass().getSimpleName()}));
        CraftingRecipe recipe = CraftingRecipe.CreateMain((ForgeConfig)config, (String)"101 101 101", (String)this.getStringId(), (int)stackSize, (String[])new String[]{this.getConductor().getRelatedUnitId().toString()});
        this.getMod().getRegistrator().addCrafting(recipe);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entityIn) {
        Chimney.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_WEST);
        Chimney.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_NORTH);
        Chimney.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_EAST);
        Chimney.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_WALL_SOUTH);
    }

    public String getClassRegName() {
        return "";
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        switch (side) {
            case DOWN: 
            case UP: {
                return false;
            }
        }
        return true;
    }

    public boolean isReadyToRegister() {
        return this.getConductor().getRelatedUnitId().getBlockState().exists();
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        this.func_180650_b(worldIn, pos, state, (Random)CommonMath.RANDOM);
        super.func_176213_c(worldIn, pos, state);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        WorldData.activeChimneys.remove(pos);
        WorldData.renderChimneys.remove(pos);
        super.func_176206_d(worldIn, pos, state);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        WorldData.activeChimneys.remove(pos);
        WorldData.renderChimneys.remove(pos);
        super.func_180652_a(worldIn, pos, explosionIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        this.func_180650_b(worldIn, pos, stateIn, rand);
        super.func_180655_c(stateIn, worldIn, pos, rand);
    }

    public void func_180650_b(World worldIn, BlockPos mutualPos, IBlockState state, Random rand) {
        BlockPos pos = mutualPos.func_185334_h();
        if (MAX_ACTIVE_THREADS_AMOUNT > 0) {
            if (activeThreadsAmount.get() < MAX_ACTIVE_THREADS_AMOUNT) {
                new Updater(worldIn, pos);
            }
        } else {
            Chimney.updateOn(worldIn, pos);
        }
        if (this.isServerSide(worldIn)) {
            worldIn.func_175684_a(pos, (Block)this, Smoke.serverScheduleTickInterval);
        }
        super.func_180650_b(worldIn, pos, state, rand);
    }

    private static void updateOn(World world, BlockPos pos) {
        Smoke smoke;
        boolean covered;
        boolean bl = covered = WorldData.coveredByChimney(world, pos) || WorldData.coveredBySmoketightBlock(world, pos);
        if (ForgeWorld.isServerSide((World)world) && !covered && ((smoke = WorldData.activeChimneys.get(pos)) == null || smoke.getLifeTime().inMillis() >= (long)Smoke.serverToClientUpdateInterval)) {
            smoke = WorldData.getSmokeFrom(world, pos, 0);
            WorldData.activeChimneys.add(pos, smoke);
            if (smoke.hasParticles()) {
                Chimney.meltSnowAround(world, pos, smoke);
                UpdateBlockMsg message = new UpdateBlockMsg(pos);
                NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)Smoke.maxRenderDistance);
                ForgeMain.instance.getRegistrator().networkChannel.sendToAllAround((IMessage)message, point);
            }
        }
        if (ForgeWorld.isClientSide((World)world)) {
            if (!covered) {
                smoke = WorldData.getSmokeFrom(world, pos, 0);
                if (smoke != null && smoke.hasParticles()) {
                    WorldData.renderChimneys.add(pos, smoke);
                } else {
                    WorldData.renderChimneys.remove(pos);
                }
            } else {
                WorldData.renderChimneys.remove(pos);
            }
        }
    }

    private static void meltSnowAround(World world, BlockPos pos, Smoke smoke) {
        if (ForgeWorld.isServerSide((World)world)) {
            BlockPos startPos;
            boolean shouldMelt;
            boolean bl = shouldMelt = CommonMath.Random.between((float)0.0f, (float)Smoke.maxAmount) < smoke.getAmount();
            if (shouldMelt && (startPos = (BlockPos)CommonMath.Random.from((List)ForgeWorld.Position.getAllAround((BlockPos)pos, (boolean)true))) != null) {
                int maxOffset = Math.max(1, Math.round(smoke.getIntencity()));
                for (int offset = 0; offset <= maxOffset; ++offset) {
                    BlockPos snowPos = startPos.func_177981_b(offset);
                    if (ForgeWorld.SnowMelter.isSnow((World)world, (BlockPos)snowPos)) {
                        ForgeWorld.SnowMelter.meltLayerAt((World)world, (BlockPos)snowPos);
                        break;
                    }
                    BlockPos checkPos = pos.func_177981_b(offset + 1);
                    if (WorldData.isChimney(world, checkPos) || ForgeWorld.isVerticalOpaque((World)world, (BlockPos)checkPos) || world.func_180495_p(checkPos).func_177230_c() == Blocks.field_150359_w) break;
                }
            }
        }
    }

    public void onInit() {
        Block relatedBlock = this.getConductor().getRelatedUnitId().getBlockState().getBlock();
        if (relatedBlock != null) {
            int lightValue = relatedBlock.func_149750_m(relatedBlock.func_176223_P());
            this.setLightValue(lightValue);
            float resistance = relatedBlock.func_149638_a(null) * 5.0f;
            this.setResistance(resistance);
            float hardness = relatedBlock.func_176195_g(relatedBlock.func_176223_P(), null, null);
            this.func_149711_c(hardness);
        }
        super.onInit();
    }

    public String toString() {
        return Chimney.class.getSimpleName() + Args.group((Object[])new Object[]{this.getConductor()}) + Args.extend((Object)super.toString());
    }

    public UnitId getRelatedUnitId() {
        return this.getConductor().getRelatedUnitId();
    }

    public Conductor getConductor() {
        return this.conductor;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Renderer {
        private static final FloatBounds dyBounds = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(0.6f));
        private static final FloatBounds dxzBounds = new FloatBounds(Float.valueOf(0.4f), Float.valueOf(0.6f));
        private CommonTime.Stamp lastUpdate = CommonTime.Stamp.now();

        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (CommonTime.Time.passedFrom((CommonTime.Stamp)this.lastUpdate).inMillis() >= (long)Smoke.clientUpdateInterval) {
                for (Map.Entry<BlockPos, Smoke> entry : WorldData.renderChimneys.getMap().entrySet()) {
                    BlockPos pos = entry.getKey();
                    Smoke smoke = entry.getValue();
                    double distance = ForgeEntity.getCurPosition((Entity)Minecraft.func_71410_x().func_175606_aa()).distance(Vect3d.from((BlockPos)pos));
                    float totalParticlesAmount = WorldData.renderChimneys.getTotalParticlesAmount();
                    if (totalParticlesAmount > 0.0f && smoke.hasParticles() && smoke.getLifeTime().inMillis() <= (long)Smoke.clientWaitForUpdateTime && distance <= (double)Smoke.maxRenderDistance) {
                        float factor = WorldData.renderChimneys.getParticlesReductionFactor();
                        this.renderSmoke(event.player.field_70170_p, smoke, pos, factor);
                        continue;
                    }
                    WorldData.renderChimneys.remove(pos);
                }
                this.lastUpdate = CommonTime.Stamp.now();
            }
        }

        public void renderSmoke(World world, Smoke smoke, BlockPos pos, float factor) {
            int smokeAmount = Math.round(smoke.getAmount() * factor);
            for (int i = 0; i < smokeAmount; ++i) {
                double dx = dxzBounds.randomBetween().floatValue();
                double dy = dyBounds.randomBetween().floatValue();
                double dz = dxzBounds.randomBetween().floatValue();
                Vect3d smokePos = Vect3d.from((BlockPos)pos).move(dx, dy, dz);
                SmokeParticle smokeParticle = new SmokeParticle(world, smokePos, smoke.getIntencity(), smoke.getScale(), smoke.pickColor());
                Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)smokeParticle);
            }
        }
    }

    private static class Updater
    extends Thread {
        private final World world;
        private final BlockPos pos;

        public Updater(World world, BlockPos pos) {
            this.world = world;
            this.pos = pos.func_185334_h();
            this.setName("updater");
            this.setPriority(1);
            activeThreadsAmount.incrementAndGet();
            this.start();
        }

        @Override
        public void run() {
            Chimney.updateOn(this.world, this.pos);
            activeThreadsAmount.decrementAndGet();
        }
    }
}

