/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeGui;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.materials.CraftingRecipe;
import com.endertech.minecraft.forge.messages.TileSharedDataMsg;
import com.endertech.minecraft.forge.units.ForgeBlockContainer;
import com.endertech.minecraft.forge.units.ForgeTile;
import com.endertech.minecraft.mods.adchimneys.Main;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.smoke.IEmitter;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import java.awt.Color;
import java.awt.Rectangle;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Smoker
extends ForgeBlockContainer<Tile>
implements IEmitter {
    private static ColorARGB DEFAULT_COLOR = ColorARGB.from((int)-2004844416);
    private static Smoke DEFAULT_SMOKE = new Smoke();
    private static Emitter DEFAULT_EMITTER = new Emitter();
    private final Gui gui;

    public Smoker(ForgeMod mod, UnitConfig config) {
        super(mod, config, Tile.class, "", Material.field_151576_e, (CreativeTabs)Main.CHIMNEYS_TAB);
        this.gui = new Gui(mod);
        this.func_149711_c(1.5f);
        this.setResistance(30.0f);
        DEFAULT_SMOKE = new Smoke(config, 15.0f, 3.0f, 2.5f);
        DEFAULT_EMITTER = new Emitter(config, this.getId(), 0.9f, DEFAULT_SMOKE, DEFAULT_COLOR, false, true, true, null);
        CraftingRecipe recipe = CraftingRecipe.CreateMain((ForgeConfig)config, (String)"121 232 121", (String)this.getStringId(), (int)1, (String[])new String[]{"coal", "redstone", "furnace"});
        this.getMod().getRegistrator().addCrafting(recipe);
    }

    @Override
    public Emitter getEmitter(World world, BlockPos pos) {
        Tile tile;
        TileEntity tileEntity = this.getTileEntity(world, pos);
        if (tileEntity instanceof Tile && (!(tile = (Tile)tileEntity).isNeedRedstonePower() || world.func_175640_z(pos))) {
            return tile.getEmitter();
        }
        return new Emitter();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.gui.openFor(playerIn, 0, pos);
        return true;
    }

    public Gui getGui() {
        return this.gui;
    }

    public class Gui
    extends ForgeGui {
        public Gui(ForgeMod mod) {
            super(mod);
        }

        public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
            return null;
        }

        public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
            BlockPos pos;
            Tile tile;
            if (ID == 0 && (tile = (Tile)world.func_175625_s(pos = new BlockPos(x, y, z))) != null) {
                return new Screen(tile);
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public class Screen
        extends ForgeGui.Screen
        implements GuiSlider.ISlider {
            static final int ID = 0;
            private final Tile tile;
            private GuiSlider sliderAmount;
            private GuiSlider sliderIntencity;
            private GuiSlider sliderScale;
            private GuiSlider sliderColor;
            private GuiSlider sliderColorPercentage;
            private GuiSlider sliderPatency;
            private GuiCheckBox checkboxAllowGaps;
            private GuiCheckBox checkboxCanEmittUpward;
            private GuiCheckBox checkboxCanEmittAside;
            private GuiCheckBox checkboxNeedRedstonePower;

            public Screen(Tile tile) {
                super((ForgeGui)Gui.this);
                this.tile = tile;
            }

            public void func_73866_w_() {
                this.setColumnsAmount(2);
                Smoke smoke = this.tile.getEmitter().getSmoke();
                Emitter emitter = this.tile.getEmitter();
                this.addLabel("Smoke", Color.WHITE.getRGB());
                this.addLabel("Emitter", Color.WHITE.getRGB());
                this.sliderAmount = this.addSlider("Amount", new FloatBounds(Float.valueOf(0.0f), Float.valueOf(Smoke.maxAmount)), smoke.getAmount(), this);
                this.checkboxAllowGaps = this.addCheckBox("Allow gaps", emitter.isAllowGaps());
                this.sliderIntencity = this.addSlider("Intencity", new FloatBounds(Float.valueOf(0.0f), Float.valueOf(Smoke.maxIntencity)), smoke.getIntencity(), this);
                this.checkboxCanEmittUpward = this.addCheckBox("Can emitt upward", emitter.canEmitUpward());
                this.sliderScale = this.addSlider("Scale", new FloatBounds(Float.valueOf(1.0f), Float.valueOf(Smoke.maxScale)), smoke.getScale(), this);
                this.checkboxCanEmittAside = this.addCheckBox("Can emitt aside", emitter.canEmitAside());
                this.sliderColor = this.addSlider("Color", new IntBounds(Integer.valueOf(0), Integer.valueOf(0xFFFFFF)), emitter.getColor().getARGB() & 0xFFFFFF, this);
                this.checkboxNeedRedstonePower = this.addCheckBox("Need redstone power", this.tile.isNeedRedstonePower());
                this.sliderColorPercentage = this.addSlider("Color Percentage", new IntBounds(Integer.valueOf(0), Integer.valueOf(100)), Math.round(emitter.getColor().getAlpha().toFloat() * 100.0f), this);
                this.sliderPatency = this.addSlider("Patency", new FloatBounds(Float.valueOf(0.0f), Float.valueOf(5.0f)), emitter.getPatency(), this);
                super.func_73866_w_();
            }

            public void onChangeSliderValue(GuiSlider slider) {
                if (slider == this.sliderColor) {
                    Rectangle rect = this.getControlRect(slider.field_146127_k);
                    net.minecraft.client.gui.Gui.func_73734_a((int)rect.x, (int)rect.y, (int)(rect.x + rect.width), (int)(rect.y + rect.height), (int)(slider.getValueInt() | 0xFF000000));
                }
            }

            protected void onAccept() {
                ColorARGB.Channel alpha = ColorARGB.Channel.fromFloat((float)((float)this.sliderColorPercentage.getValue() / 100.0f));
                ColorARGB color = ColorARGB.from((int)this.sliderColor.getValueInt()).withAlpha(alpha);
                Smoke smoke = new Smoke(null, (float)this.sliderAmount.getValue(), (float)this.sliderIntencity.getValue(), (float)this.sliderScale.getValue());
                Emitter emitter = new Emitter((float)this.sliderPatency.getValue(), smoke, color, this.checkboxAllowGaps.isChecked(), this.checkboxCanEmittUpward.isChecked(), this.checkboxCanEmittAside.isChecked());
                this.tile.setNeedRedstonePower(this.checkboxNeedRedstonePower.isChecked());
                this.tile.setEmitter(emitter);
                TileSharedDataMsg message = new TileSharedDataMsg(this.tile.getSharedData(), this.tile.func_174877_v());
                ForgeMain.instance.getRegistrator().networkChannel.sendToServer((IMessage)message);
            }
        }
    }

    public static class Tile
    extends ForgeTile {
        private Emitter emitter;
        private boolean needRedstonePower = false;

        public Tile() {
            this.setEmitter(DEFAULT_EMITTER);
        }

        public void readSharedData(NBTTagCompound compound) {
            this.setEmitter(Emitter.getFromNBT(compound.func_74775_l(Tags.EMITTER.name())));
            this.setNeedRedstonePower(compound.func_74767_n(Tags.NEED_REDSTONE_POWER.name()));
        }

        public void writeSharedData(NBTTagCompound compound) {
            NBTTagCompound tagEmitter = new NBTTagCompound();
            this.getEmitter().writeToNBT(tagEmitter);
            compound.func_74782_a(Tags.EMITTER.name(), (NBTBase)tagEmitter);
            compound.func_74757_a(Tags.NEED_REDSTONE_POWER.name(), this.isNeedRedstonePower());
        }

        public Emitter getEmitter() {
            return this.emitter;
        }

        public void setEmitter(Emitter emitter) {
            this.emitter = emitter;
        }

        public boolean isNeedRedstonePower() {
            return this.needRedstonePower;
        }

        public void setNeedRedstonePower(boolean needRedstonePower) {
            this.needRedstonePower = needRedstonePower;
        }

        private static enum Tags {
            EMITTER,
            NEED_REDSTONE_POWER;

        }
    }
}

