/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.smoke;

import com.endertech.common.Args;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.IRelatedUnitId;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import javax.annotation.Nullable;

public class Conductor
implements IRelatedUnitId {
    public static final float MAX_PATENCY = 5.0f;
    private final ColorARGB addColor;
    private final UnitId relatedBlockId;
    private final float patency;

    public Conductor() {
        this(0.0f);
    }

    public Conductor(float patency) {
        this(null, UnitId.EMPTY, Smoke.defaultColor, patency);
    }

    public Conductor(@Nullable UnitConfig config, UnitId relatedBlockId, ColorARGB smokeAddColor, float patency) {
        String category = this.getClass().getSimpleName();
        this.patency = ForgeConfig.getFloat((ForgeConfig)config, (String)category, (String)"patency", (float)patency, (FloatBounds)new FloatBounds(Float.valueOf(0.0f), Float.valueOf(5.0f)), (String)"Defines how much smoke can be transferred through (1.0 means 100%)");
        this.addColor = ForgeConfig.getColorARGB((ForgeConfig)config, (String)category, (String)"color", (ColorARGB)smokeAddColor, (String)"Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb) which will be applied to the smoke.\nThe alpha channel of this color (aa) determines probability of applying (ff - always, 7f - 1/2, 00 - never).\n");
        this.relatedBlockId = ForgeConfig.getUnitId((ForgeConfig)config, (String)category, (String)"relatedBlockId", (UnitId)relatedBlockId, (String)"Id is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from private to common (example: black_iron_ore).\nUnit name will be automatically converted to ore dictionary name with reverse word order (example: oreIronBlack).\nUse '*' char as meta value to specify all possible values.\nAlso you may use just ore dictionary name as full id.\n");
    }

    public ColorARGB getColor() {
        return this.addColor;
    }

    public float getPatency() {
        return this.patency;
    }

    public Smoke getTransferredSmoke(Smoke smoke) {
        if (smoke == null || this.isSmoketight()) {
            return new Smoke();
        }
        return smoke.transferThrough(this.getPatency(), this.getColor());
    }

    public boolean isSmoketight() {
        return this.getPatency() < 1.0f / Smoke.maxAmount;
    }

    public String toString() {
        return Conductor.class.getSimpleName() + Args.group((Object[])new Object[]{Args.get((String)"patency", (Object)Float.valueOf(this.getPatency())), Args.get((String)"color", (Object)this.getColor().getHexARGB()), Args.get((String)"relatedUnitId", (Object)this.getRelatedUnitId())});
    }

    public UnitId getRelatedUnitId() {
        return this.relatedBlockId;
    }
}

