/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.smoke;

import com.endertech.common.Args;
import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.smoke.Conductor;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.google.common.base.Strings;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Emitter
extends Conductor {
    private final boolean allowGaps;
    private final boolean canEmitUpward;
    private final boolean canEmitAside;
    private final String nbtControlKey;
    private final Smoke smoke;

    public Emitter() {
        this(0.0f, Smoke.getNone(), Smoke.defaultColor, false, false, false);
    }

    public Emitter(float patency, Smoke smoke, ColorARGB color, boolean allowGaps, boolean canEmitUpward, boolean canEmitAside) {
        this(null, UnitId.EMPTY, patency, smoke, color, allowGaps, canEmitUpward, canEmitAside, null);
    }

    public Emitter(@Nullable UnitConfig config, UnitId relatedBlockId, float patency, Smoke smoke, ColorARGB color, boolean allowGaps, boolean canEmitUpward, boolean canEmitAside, @Nullable String nbtControlKey) {
        super(config, relatedBlockId, color, patency);
        String category = this.getClass().getSimpleName();
        this.smoke = new Smoke(config, smoke.getAmount(), smoke.getIntencity(), smoke.getScale(), this.getColor());
        this.allowGaps = ForgeConfig.getBool((ForgeConfig)config, (String)category, (String)"allowGaps", (boolean)allowGaps, (String)"If false, the emitter should be connected directly to a chimney to produce smoke.");
        this.canEmitUpward = ForgeConfig.getBool((ForgeConfig)config, (String)category, (String)"canEmitUpward", (boolean)canEmitUpward, (String)"If true, the smoke will be transferred to blocks above the emitter.");
        this.canEmitAside = ForgeConfig.getBool((ForgeConfig)config, (String)category, (String)"canEmitAside", (boolean)canEmitAside, (String)"If true, the smoke will be transferred to the chimneys directly connected from aside.");
        this.nbtControlKey = ForgeConfig.getStr((ForgeConfig)config, (String)category, (String)"nbtControlKey", (String)Strings.nullToEmpty((String)nbtControlKey), (String)"Defines the key name of NBT tag that needs to be checked.\nSmoke from this emitter will be gotten only if the returning value is > 0 or true.\nSet empty string for no checks");
    }

    public static Emitter getFromNBT(NBTTagCompound compound) {
        NBTTagCompound tag = compound.func_74775_l(Emitter.class.getSimpleName());
        UnitId relatedBlockId = UnitId.from((String)tag.func_74779_i(Tags.RELATED_BLOCK_ID.name()));
        float patency = tag.func_74760_g(Tags.PATENCY.name());
        Smoke smoke = Smoke.getFromNBT(tag);
        int intARGB = tag.func_74762_e(Tags.COLOR.name());
        boolean allowGaps = tag.func_74767_n(Tags.ALLOW_GAPS.name());
        boolean canEmitUpward = tag.func_74767_n(Tags.CAN_EMIT_UPWARD.name());
        boolean canEmitAside = tag.func_74767_n(Tags.CAN_EMIT_ASIDE.name());
        String nbtControlKey = tag.func_74779_i(Tags.NBT_CONTROL_KEY.name());
        return new Emitter(null, relatedBlockId, patency, smoke, ColorARGB.from((int)intARGB), allowGaps, canEmitUpward, canEmitAside, nbtControlKey);
    }

    public void writeToNBT(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a(Tags.RELATED_BLOCK_ID.name(), this.getRelatedUnitId().toString());
        tag.func_74776_a(Tags.PATENCY.name(), this.getPatency());
        this.getSmoke().writeToNBT(tag);
        tag.func_74768_a(Tags.COLOR.name(), this.getColor().getARGB());
        tag.func_74757_a(Tags.ALLOW_GAPS.name(), this.isAllowGaps());
        tag.func_74757_a(Tags.CAN_EMIT_UPWARD.name(), this.canEmitUpward());
        tag.func_74757_a(Tags.CAN_EMIT_ASIDE.name(), this.canEmitAside());
        tag.func_74778_a(Tags.NBT_CONTROL_KEY.name(), this.getNbtControlKey());
        compound.func_74782_a(this.getClass().getSimpleName(), (NBTBase)tag);
    }

    public Smoke getSmoke(World world, BlockPos pos, boolean useTopEmitter, boolean useSideEmitter) {
        if ((useTopEmitter && this.canEmitUpward() || useSideEmitter && this.canEmitAside()) && (!this.needToCheckNBT() || this.getNBTControlValue(world, pos))) {
            return new Smoke().combine(this.smoke);
        }
        return new Smoke();
    }

    public boolean needToCheckNBT() {
        return !CommonString.isNullOrEmpty((String)this.getNbtControlKey());
    }

    public boolean getNBTControlValue(World world, BlockPos pos) {
        TileEntity tile;
        if (world != null && pos != null && (tile = world.func_175625_s(pos)) != null) {
            NBTTagCompound compound = tile.func_189515_b(new NBTTagCompound());
            int intValue = compound.func_74762_e(this.getNbtControlKey());
            return intValue > 0;
        }
        return false;
    }

    @Override
    public String toString() {
        return Emitter.class.getSimpleName() + Args.group((Object[])new Object[]{Args.get((String)"allowGaps", (Object)this.isAllowGaps()), Args.get((String)"canEmitUpward", (Object)this.canEmitUpward()), Args.get((String)"canEmitAside", (Object)this.canEmitAside()), Args.get((String)"nbtControlKey", (Object)this.getNbtControlKey()), this.getSmoke()}) + Args.extend((Object)super.toString());
    }

    public boolean isAllowGaps() {
        return this.allowGaps;
    }

    public boolean canEmitUpward() {
        return this.canEmitUpward;
    }

    public boolean canEmitAside() {
        return this.canEmitAside;
    }

    public String getNbtControlKey() {
        return this.nbtControlKey;
    }

    public Smoke getSmoke() {
        return this.smoke;
    }

    private static enum Tags {
        RELATED_BLOCK_ID,
        PATENCY,
        COLOR,
        ALLOW_GAPS,
        CAN_EMIT_UPWARD,
        CAN_EMIT_ASIDE,
        NBT_CONTROL_KEY;

    }
}

