/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.smoke;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class Smoke {
    public static final float MIN_SCALE = 1.0f;
    public static ColorARGB defaultColor = ColorARGB.DEFAULT;
    public static float maxGapLength = 15.0f;
    public static float maxAmount = 50.0f;
    public static float maxIntencity = 10.0f;
    public static float maxScale = 5.0f;
    public static int maxRenderDistance = 128;
    public static float maxRenderedParticlesAmount = 400.0f;
    public static int serverScheduleTickInterval = 40;
    public static int serverToClientUpdateInterval = 1000;
    public static int clientUpdateInterval = 250;
    public static int clientWaitForUpdateTime = 2000;
    private final CommonTime.Stamp creationTime;
    private final float amount;
    private final float intencity;
    private final float scale;
    private List<ColorARGB> colors = new ArrayList<ColorARGB>();

    public static Smoke getNone() {
        return new Smoke();
    }

    public static Smoke getFromNBT(NBTTagCompound compound) {
        NBTTagCompound tag = compound.func_74775_l(Smoke.class.getSimpleName());
        float amount = tag.func_74760_g(Tags.AMOUNT.name());
        float intencity = tag.func_74760_g(Tags.INTENCITY.name());
        float scale = tag.func_74760_g(Tags.SCALE.name());
        int[] colors = tag.func_74759_k(Tags.COLORS.name());
        Smoke smoke = new Smoke(amount, intencity, scale);
        for (int color : colors) {
            smoke.addColor(ColorARGB.from((int)color));
        }
        return smoke;
    }

    public Smoke() {
        this(null, 0.0f, 0.0f, 1.0f);
    }

    public Smoke(UnitConfig config, Smoke smoke) {
        this(config, smoke != null ? smoke.getAmount() : new Smoke().getAmount(), smoke != null ? smoke.getIntencity() : new Smoke().getIntencity(), smoke != null ? smoke.getScale() : new Smoke().getScale());
        if (smoke != null) {
            this.colors.addAll(smoke.colors);
        }
    }

    public Smoke(float amount, float intencity, float scale) {
        this(null, amount, intencity, scale);
    }

    public Smoke(UnitConfig config, float amount, float intencity, float scale) {
        this(config, amount, intencity, scale, null);
    }

    public Smoke(UnitConfig config, float amount, float intencity, float scale, ColorARGB color) {
        String category = this.getClass().getSimpleName();
        this.amount = ForgeConfig.getFloat((ForgeConfig)config, (String)category, (String)"amount", (float)amount, (FloatBounds)new FloatBounds(Float.valueOf(0.0f), Float.valueOf(maxAmount)), (String)"Defines particles amount");
        this.intencity = ForgeConfig.getFloat((ForgeConfig)config, (String)category, (String)"intencity", (float)intencity, (FloatBounds)new FloatBounds(Float.valueOf(0.0f), Float.valueOf(maxIntencity)), (String)"Defines smoke blow out distance.");
        this.scale = ForgeConfig.getFloat((ForgeConfig)config, (String)category, (String)"scale", (float)scale, (FloatBounds)new FloatBounds(Float.valueOf(1.0f), Float.valueOf(maxScale)), (String)"Defines smoke particles scale.");
        this.addColor(color);
        this.creationTime = CommonTime.Stamp.now();
    }

    public Smoke combine(Smoke smoke) {
        if (smoke == null) {
            smoke = new Smoke();
        }
        Smoke combined = new Smoke(null, this.getAmount() + smoke.getAmount(), this.getIntencity() + smoke.getIntencity(), Math.max(this.getScale(), smoke.getScale()));
        combined.colors.addAll(this.colors);
        combined.colors.addAll(smoke.colors);
        return combined;
    }

    protected boolean addColor(ColorARGB color) {
        if (color == null || color.equals((Object)defaultColor) || color.isCompletelyTransparent()) {
            return false;
        }
        return this.colors.add(color);
    }

    public List<ColorARGB> getAllColors() {
        return Collections.unmodifiableList(this.colors);
    }

    public ColorARGB pickColor() {
        int chance = CommonMath.Random.between((int)0, (int)255);
        ArrayList<ColorARGB> picked = new ArrayList<ColorARGB>();
        for (int i = 0; i < this.colors.size(); ++i) {
            if (chance >= this.colors.get((int)i).getAlpha().value) continue;
            picked.add(this.colors.get(i));
        }
        if (!picked.isEmpty()) {
            return (ColorARGB)CommonMath.Random.from(picked);
        }
        return defaultColor;
    }

    public boolean hasParticles() {
        return CommonMath.getRounded((float)this.getAmount()) > 0;
    }

    public Smoke transferThrough(float patency, ColorARGB addColor) {
        Smoke transfered = new Smoke(null, this.getAmount() * patency, this.getIntencity() * patency, (float)((double)this.getScale() * CommonMath.raiseToPower((double)patency, (double)0.1111111111111111)));
        transfered.colors.addAll(this.colors);
        transfered.addColor(addColor);
        return transfered;
    }

    public String toString() {
        return this.getClass().getSimpleName() + Args.group((Object[])new Object[]{Args.get((String)"amount", (Object)Float.valueOf(this.getAmount())), Args.get((String)"intencity", (Object)Float.valueOf(this.getIntencity())), Args.get((String)"scale", (Object)Float.valueOf(this.getScale())), this.getAllColors()});
    }

    public CommonTime.Stamp getCreationTime() {
        return this.creationTime;
    }

    public CommonTime.Time getLifeTime() {
        return CommonTime.Time.passedFrom((CommonTime.Stamp)this.getCreationTime());
    }

    public float getAmount() {
        return this.amount;
    }

    public float getIntencity() {
        return this.intencity;
    }

    public float getScale() {
        return this.scale;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a(Tags.AMOUNT.name(), this.getAmount());
        tag.func_74776_a(Tags.INTENCITY.name(), this.getIntencity());
        tag.func_74776_a(Tags.SCALE.name(), this.getScale());
        int[] intColors = new int[this.colors.size()];
        for (int i = 0; i < intColors.length; ++i) {
            intColors[i] = this.colors.get(i).getARGB();
        }
        tag.func_74783_a(Tags.COLORS.name(), intColors);
        compound.func_74782_a(this.getClass().getSimpleName(), (NBTBase)tag);
        return compound;
    }

    private static enum Tags {
        AMOUNT,
        INTENCITY,
        SCALE,
        COLORS;

    }
}

