/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.common;

import com.endertech.common.CommonMath;
import com.endertech.common.IBounds;

public class FloatBounds
implements IBounds<Float> {
    public final Float min;
    public final Float max;

    public FloatBounds(Float bound1, Float bound2) {
        this.min = Float.valueOf(Math.min(bound1.floatValue(), bound2.floatValue()));
        this.max = Float.valueOf(Math.max(bound1.floatValue(), bound2.floatValue()));
    }

    @Override
    public boolean encloses(Float value) {
        return value.floatValue() >= this.min.floatValue() && value.floatValue() <= this.max.floatValue();
    }

    @Override
    public Float enclose(Float value) {
        return Float.valueOf(CommonMath.Range.enclose(value.floatValue(), this.min.floatValue(), this.max.floatValue()));
    }

    @Override
    public Float randomBetween() {
        return Float.valueOf(CommonMath.Random.between(this.min.floatValue(), this.max.floatValue()));
    }

    @Override
    public Float approxUp(float factor) {
        return Float.valueOf(CommonMath.Approx.strictUp(factor, this));
    }

    @Override
    public Float approxDown(float factor) {
        return Float.valueOf(CommonMath.Approx.strictDown(factor, this));
    }

    @Override
    public float approxFactor(Float value) {
        return CommonMath.notZero(this.length().floatValue()) ? (value.floatValue() - this.min.floatValue()) / this.length().floatValue() : 0.0f;
    }

    @Override
    public Float center() {
        return Float.valueOf(this.min.floatValue() + this.length().floatValue() * 0.5f);
    }

    @Override
    public Float length() {
        return Float.valueOf(this.max.floatValue() - this.min.floatValue());
    }
}

