/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.combat;

import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.materials.ForgeMaterial;
import com.endertech.minecraft.forge.materials.IMaterialBased;
import com.endertech.minecraft.forge.units.ForgeItem;
import com.endertech.minecraft.forge.units.IForgeUnit;
import com.endertech.minecraft.forge.units.UnitEnabled;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.units.UnitVariant;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ForgeArmor
extends ItemArmor
implements IForgeUnit,
IMaterialBased {
    private final ForgeConfig config;
    private final UnitId id;
    private final ForgeMod mod;
    private final UnitEnabled unitEnabled;
    private UnitVariant[] variants;
    private final ForgeMaterial material;

    public ForgeArmor(ForgeMod mod, UnitConfig config, ForgeMaterial material, ItemArmor.ArmorMaterial armorMaterial, EntityEquipmentSlot equipmentSlot) {
        super(armorMaterial, ItemArmor.ArmorMaterial.IRON.ordinal(), equipmentSlot);
        this.mod = mod;
        this.id = this.createId(mod.getId(), material.getName());
        this.config = config;
        this.unitEnabled = new UnitEnabled(config, this.getConfigCategory(), true);
        this.material = material;
        this.variants = this.createUnitVariants();
        this.func_77655_b(this.getId().getRegName());
        this.getMod().getRegistrator().addUnit(this);
    }

    protected static int[] calculateReductionAmounts(ForgeMaterial material) {
        float reduction = ForgeMaterial.calculateDamageReduction(material.getStrength());
        int[] amounts = new int[]{(int)(0.15f * reduction), (int)(0.3f * reduction), (int)(0.4f * reduction), (int)(0.15f * reduction)};
        return amounts;
    }

    public static ItemArmor.ArmorMaterial createArmorMaterial(ForgeMaterial material) {
        int durability = ForgeMaterial.calculateDurability(material.getStrength());
        int[] reductionAmounts = ForgeArmor.calculateReductionAmounts(material);
        int enchantability = ForgeMaterial.calculateEnchantability(material.getMagicability());
        float toughness = ForgeMaterial.calculateToughness(material.getHeaviness());
        String textureName = material.getId().toResLoc().toString();
        ItemArmor.ArmorMaterial armorMaterial = EnumHelper.addArmorMaterial((String)material.getName(), (String)textureName, (int)durability, (int[])reductionAmounts, (int)enchantability, (SoundEvent)SoundEvents.field_187725_r, (float)toughness);
        armorMaterial.setRepairItem(new ItemStack((Item)material));
        return armorMaterial;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return this.getMaterial().getId().getItemState().getItem() == repair.func_77973_b();
    }

    @Override
    public boolean isReadyToRegister() {
        return true;
    }

    @Override
    public ForgeConfig getConfig() {
        return this.config;
    }

    @Override
    public UnitId getId() {
        return this.id;
    }

    @Override
    public boolean isEnabled() {
        return this.unitEnabled.isEnabled();
    }

    @Override
    public boolean isRegistered() {
        return ForgeItem.isRegistered((Item)this);
    }

    @Override
    public void onInit() {
    }

    @Override
    public ForgeMaterial getMaterial() {
        return this.material;
    }

    @Override
    public ForgeMod getMod() {
        return this.mod;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onInitClient() {
    }

    @Override
    public UnitVariant[] getUnitVariants() {
        return this.variants;
    }
}

