/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.configs;

import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import java.io.File;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;

public class UnitConfig
extends ForgeConfig {
    public UnitConfig(Path baseDir, String folderName, String configName) {
        this(Paths.get(String.valueOf(baseDir), folderName), configName);
    }

    public UnitConfig(Path baseDir, String configName) {
        this(Paths.get(String.valueOf(baseDir), configName + ".cfg").toFile());
    }

    public UnitConfig(File file) {
        super(file);
    }

    public static List<Path> listCustomConfigs(Path searchDir, @Nullable Class<? extends IForgeEnum> exclude) {
        ArrayList<String> excludeList = new ArrayList<String>();
        if (exclude != null) {
            for (IForgeEnum e : exclude.getEnumConstants()) {
                excludeList.add(e.func_176610_l() + ".cfg");
            }
        }
        ArrayList<Path> configList = new ArrayList<Path>();
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(searchDir, "*.cfg");){
            for (Path path : dirStream) {
                if (excludeList.contains(String.valueOf(path.getFileName()))) continue;
                configList.add(path);
            }
        }
        catch (Exception e) {
            ForgeMain.instance.getLogger().error(e.toString());
        }
        return configList;
    }
}

