/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.coremod;

import com.endertech.minecraft.forge.coremod.signatures.FieldSignature;
import com.endertech.minecraft.forge.coremod.signatures.MethodSignature;
import org.apache.logging.log4j.LogManager;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class InstructList {
    public final MethodNode methodNode;
    public final MethodInsnNode instructNode;
    protected InsnList list = new InsnList();

    public InstructList(MethodNode methodNode, MethodInsnNode instructNode) {
        this.methodNode = methodNode;
        this.instructNode = instructNode;
    }

    protected void logInfo(String msg, Object ... params) {
        String loggerName = this.getClass().getSimpleName();
        LogManager.getLogger((String)loggerName).info("\t\t\t" + msg, params);
    }

    public InstructList loadObjFrom(int varIndex) {
        this.list.add((AbstractInsnNode)new VarInsnNode(25, varIndex));
        this.logInfo("ALOAD {}", varIndex);
        return this;
    }

    public InstructList saveObjTo(int varIndex) {
        this.list.add((AbstractInsnNode)new VarInsnNode(58, varIndex));
        this.logInfo("ASTORE {}", varIndex);
        return this;
    }

    public InstructList loadIntFrom(int varIndex) {
        this.list.add((AbstractInsnNode)new VarInsnNode(21, varIndex));
        this.logInfo("ILOAD {}", varIndex);
        return this;
    }

    public InstructList pushInt0() {
        this.list.add((AbstractInsnNode)new InsnNode(3));
        this.logInfo("ICONST_0", new Object[0]);
        return this;
    }

    protected MethodInsnNode methodNode(MethodSignature method, int opcode) {
        return new MethodInsnNode(opcode, method.className.normal, method.name.normal, method.descriptor.normal, false);
    }

    public InstructList invokeStatic(MethodSignature method) {
        this.list.add((AbstractInsnNode)this.methodNode(method, 184));
        this.logInfo("INVOKESTATIC {}", method.name.normal);
        return this;
    }

    public InstructList invokeVirtual(MethodSignature method) {
        this.list.add((AbstractInsnNode)this.methodNode(method, 182));
        this.logInfo("INVOKEVIRTUAL {}", method.name.normal);
        return this;
    }

    protected FieldInsnNode fieldNode(FieldSignature field, int opcode) {
        return new FieldInsnNode(opcode, field.className.normal, field.name.normal, field.descriptor.normal);
    }

    public InstructList getField(FieldSignature field) {
        this.list.add((AbstractInsnNode)this.fieldNode(field, 180));
        this.logInfo("GETFIELD {}", field.name.normal);
        return this;
    }

    public InstructList ifNotNullReturn() {
        LabelNode label = new LabelNode();
        this.list.add((AbstractInsnNode)new JumpInsnNode(198, label));
        this.list.add((AbstractInsnNode)new InsnNode(177));
        this.list.add((AbstractInsnNode)label);
        this.logInfo("IFNONNULL RETURN", new Object[0]);
        return this;
    }

    public InstructList insertBefore() {
        this.methodNode.instructions.insertBefore((AbstractInsnNode)this.instructNode, this.list);
        this.logInfo("insertBefore ", this.instructNode);
        return this;
    }

    public InstructList insertAfter() {
        this.methodNode.instructions.insert((AbstractInsnNode)this.instructNode, this.list);
        this.logInfo("insertAfter ", this.instructNode);
        return this;
    }

    public InstructList clear() {
        this.list.clear();
        this.logInfo("clear", new Object[0]);
        return this;
    }
}

