/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.units;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.units.UnitId;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;

public class UnitVariant {
    public static final String INVENTORY = "inventory";
    private final UnitId id;
    private final String variant;

    protected UnitVariant(UnitId id, String name, String value) {
        this(id, name + "=" + value);
    }

    public UnitVariant(UnitId id, String variant) {
        this.id = id;
        this.variant = variant;
    }

    public static UnitVariant from(UnitId id, IForgeEnum forgeEnum) {
        return new UnitVariant(id, forgeEnum.getClassName(), forgeEnum.func_176610_l());
    }

    public static UnitVariant inventory(UnitId id) {
        return new UnitVariant(id, INVENTORY);
    }

    public static UnitVariant from(ModelResourceLocation model) {
        UnitId id = UnitId.from((ResourceLocation)model, 0);
        return UnitVariant.inventory(id);
    }

    public String getVariant() {
        return this.variant;
    }

    public UnitId getId() {
        return this.id;
    }

    public ModelResourceLocation toModelResLoc() {
        return new ModelResourceLocation(this.getId().toResLoc(), this.getVariant());
    }
}

