/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.world.ChunkBounds;
import java.util.Objects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ChunkLoc {
    private final int dimensionId;
    private final ChunkPos pos;
    private final ChunkBounds bounds;

    public ChunkLoc(int dimensionId, ChunkPos pos) {
        this.pos = pos;
        this.dimensionId = dimensionId;
        this.bounds = ChunkBounds.from(pos);
    }

    public ChunkLoc(World world, ChunkPos pos) {
        this(world.field_73011_w.getDimension(), pos);
    }

    public static ChunkLoc from(Chunk chunk) {
        return new ChunkLoc(chunk.func_177412_p(), chunk.func_76632_l());
    }

    public static ChunkLoc fromLong(long value) {
        BlockPos pos = BlockPos.func_177969_a((long)value);
        return new ChunkLoc(pos.func_177956_o(), new ChunkPos(pos.func_177958_n(), pos.func_177952_p()));
    }

    public int getDimensionId() {
        return this.dimensionId;
    }

    public ChunkPos getPos() {
        return this.pos;
    }

    public ChunkBounds getBounds() {
        return this.bounds;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ChunkLoc) {
            ChunkLoc loc = (ChunkLoc)obj;
            return loc.getDimensionId() == this.getDimensionId() && this.getPos().equals((Object)loc.getPos());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getPos(), this.getDimensionId());
    }

    public long toLong() {
        return new BlockPos(this.getPos().field_77276_a, this.getDimensionId(), this.getPos().field_77275_b).func_177986_g();
    }

    public String toString() {
        return ChunkLoc.class.getSimpleName() + Args.group(Args.get("pos", this.getPos()), Args.get("dimensionId", this.getDimensionId()));
    }
}

