/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeCreativeTab;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ModConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.WorldData;
import com.endertech.minecraft.mods.adchimneys.blocks.Chimney;
import com.endertech.minecraft.mods.adchimneys.blocks.Smoker;
import com.endertech.minecraft.mods.adchimneys.init.Chimneys;
import com.endertech.minecraft.mods.adchimneys.init.Conductors;
import com.endertech.minecraft.mods.adchimneys.init.Emitters;
import com.endertech.minecraft.mods.adchimneys.smoke.Conductor;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="adchimneys", name="Advanced Chimneys", version="1.11.2-2.0.13.0", acceptedMinecraftVersions="[1.11.2]", dependencies="required-after:forgeendertech@[1.11.2-2.2.0.0,)")
public class Main
extends ForgeMod {
    public static final String ID = "adchimneys";
    public static final String NAME = "Advanced Chimneys";
    public static final ForgeCreativeTab CHIMNEYS_TAB = new ForgeCreativeTab("adchimneys");
    @Mod.Instance(value="adchimneys")
    public static Main instance;
    Smoker smoker;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        this.setConfig(new ModConfig(this.getId(), event));
        this.initSmokeGlobals();
        Chimneys.values();
        Chimneys.initCustom();
        this.smoker = new Smoker(this, new UnitConfig(this.getConfig().getConfigDir(), Smoker.class.getSimpleName().toLowerCase(Locale.ROOT)));
        super.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        CHIMNEYS_TAB.setIcon((Block)Chimneys.cobblestone.instance);
        super.init(event);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        this.getRegistrator().registerInEventBus((Object)new Chimney.Renderer());
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        Conductors.initCustom();
        for (Conductors conductors : Conductors.values()) {
            WorldData.smokeConductors.register(conductors.conductor);
        }
        for (Conductor conductor : Conductors.custom) {
            WorldData.smokeConductors.register(conductor);
        }
        Emitters.initCustom();
        for (Emitters emitters : Emitters.values()) {
            WorldData.smokeEmitters.register(emitters.emitter);
        }
        for (Emitter emitter : Emitters.custom) {
            WorldData.smokeEmitters.register(emitter);
        }
        super.postInit(event);
    }

    void initSmokeGlobals() {
        String category = Smoke.class.getSimpleName();
        Smoke.defaultColor = this.getConfig().getColorARGB(category, "defaultColor", ColorARGB.DEFAULT, "Default smoke color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)");
        Smoke.maxAmount = this.getConfig().getFloat(category, "maxAmount", Smoke.maxAmount, new FloatBounds(Float.valueOf(1.0f), Float.valueOf(100.0f)), "Maximum smoke particles amount per chimney");
        Smoke.maxIntencity = this.getConfig().getFloat(category, "maxIntencity", Smoke.maxIntencity, new FloatBounds(Float.valueOf(0.0f), Float.valueOf(20.0f)), "Maximum smoke blow out distance");
        Smoke.maxScale = this.getConfig().getFloat(category, "maxScale", Smoke.maxScale, new FloatBounds(Float.valueOf(1.0f), Float.valueOf(10.0f)), "Maximum smoke particles scale");
        Smoke.maxGapLength = this.getConfig().getFloat(category, "maxGapLength", Smoke.maxGapLength, new FloatBounds(Float.valueOf(0.0f), Float.valueOf(20.0f)), "If > 0 it allows smoke to blow through gaps in pipelines");
        Smoke.maxRenderDistance = this.getConfig().getInt(category, "maxRenderDistance", Smoke.maxRenderDistance, new IntBounds(Integer.valueOf(16), Integer.valueOf(256)), "Maximum smoke particles render distance");
        Smoke.maxRenderedParticlesAmount = this.getConfig().getFloat(category, "maxRenderedParticlesAmount", Smoke.maxRenderedParticlesAmount, new FloatBounds(Float.valueOf(0.0f), Float.valueOf(2000.0f)), "Maximum smoke particles that can be rendered at scene.\nIf exceeded, smoke amount will be reduced proportionally for each rendered chimney");
        Smoke.clientUpdateInterval = this.getConfig().getInt(category, "clientUpdateInterval", Smoke.clientUpdateInterval, new IntBounds(Integer.valueOf(1), Integer.valueOf(1000)), "Defines how frequently the smoke will be generated on clients (in milliseconds)");
        Smoke.clientWaitForUpdateTime = this.getConfig().getInt(category, "clientWaitForUpdateTime", Smoke.clientWaitForUpdateTime, new IntBounds(Integer.valueOf(100), Integer.valueOf(10000)), "Defines how long client will wait for server update before remove chimney from render list");
        Smoke.serverToClientUpdateInterval = this.getConfig().getInt(category, "serverToClientUpdateInterval", Smoke.serverToClientUpdateInterval, new IntBounds(Integer.valueOf(100), Integer.valueOf(10000)), "Defines how frequently the server will send data of chimneys that need to be updated (in milliseconds)");
        Smoke.serverScheduleTickInterval = this.getConfig().getInt(category, "serverScheduleTickInterval", Smoke.serverScheduleTickInterval, new IntBounds(Integer.valueOf(1), Integer.valueOf(1000)), "Defines delays between scheduled block updates");
        this.getConfig().save();
    }

    @Mod.EventHandler
    public void onMissingMappings(FMLMissingMappingsEvent event) {
        String chimneyStr = "chimney";
        HashMap<String, Chimney> chimneyMap = new HashMap<String, Chimney>();
        for (Object chimney : Chimneys.values()) {
            UnitId relatedUnitId = chimney.instance.getRelatedUnitId();
            chimneyMap.put("chimney" + relatedUnitId.getRegName().toLowerCase(Locale.ROOT), chimney.instance);
            chimneyMap.put("chimney" + relatedUnitId.getDictName().toLowerCase(Locale.ROOT), chimney.instance);
        }
        chimneyMap.put("chimneyendstone", Chimneys.end_stone.instance);
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.get()) {
            Object chimney;
            String oldName = mapping.resourceLocation.func_110623_a().toLowerCase(Locale.ROOT);
            chimney = (Chimney)((Object)chimneyMap.get(oldName));
            if (chimney == null) continue;
            switch (mapping.type) {
                case BLOCK: {
                    mapping.remap((Block)chimney);
                    break;
                }
                case ITEM: {
                    mapping.remap(Item.func_150898_a((Block)chimney));
                    break;
                }
            }
        }
    }

    public String getId() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    public ForgeMod getInstance() {
        return instance;
    }
}

