/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.smoke;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.ForgeWorld;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adchimneys.WorldData;
import com.endertech.minecraft.mods.adchimneys.smoke.Conductor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.ParticleSmokeNormal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SmokeParticle
extends ParticleSmokeNormal {
    private static final double ON_HIT_MOTION_REDICTION = 0.7;
    private static final double ON_HIT_KICK_BACK = 0.1;

    public SmokeParticle(World world, Vect3d pos, float intencity, float scale, ColorARGB color) {
        super(world, pos.x, pos.y, pos.z, 0.0, (double)intencity / 10.0 * CommonMath.Random.getDouble(), 0.0, scale);
        this.func_70538_b(color.getRed().toFloat(), color.getGreen().toFloat(), color.getBlue().toFloat());
        this.field_190017_n = true;
    }

    public Vect3d getPosition() {
        return Vect3d.from((double)this.field_187126_f, (double)this.field_187127_g, (double)this.field_187128_h);
    }

    public Vect3d getMotion() {
        return Vect3d.from((double)this.field_187129_i, (double)this.field_187130_j, (double)this.field_187131_k);
    }

    public void setMotion(Vect3d motion) {
        this.field_187129_i = motion.x;
        this.field_187130_j = motion.y;
        this.field_187131_k = motion.z;
    }

    public void setPosition(Vect3d pos) {
        this.func_187109_b(pos.x, pos.y, pos.z);
    }

    public void func_187110_a(double dx, double dy, double dz) {
        Conductor conductor;
        BlockPos pos;
        RayTraceResult rayTrace;
        Vect3d curPos = this.getPosition();
        Vect3d nextPos = curPos.move(dx, dy, dz);
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        if (!(!this.field_190017_n || (rayTrace = ForgeWorld.rayTraceBlocks((World)world, (Vect3d)curPos, (Vect3d)nextPos, (boolean)false)) == null || rayTrace.field_72313_a != RayTraceResult.Type.BLOCK || WorldData.isChimney((World)world, pos = rayTrace.func_178782_a()) || (conductor = WorldData.smokeConductors.find((World)world, pos)) != null && CommonMath.Random.result((float)conductor.getPatency()))) {
            CommonMath.Angle angle = CommonMath.Angle.random();
            double motion = this.field_187130_j * this.getOnHitMotionReduction();
            this.field_187129_i = angle.cos() * motion;
            this.field_187131_k = angle.sin() * motion;
            this.field_187132_l = true;
            this.field_187130_j = 0.0;
            nextPos = Vect3d.from((Vec3d)rayTrace.field_72307_f).move(0.0, -this.getOnHitKickBack(), 0.0).add(this.getMotion());
        }
        this.setPosition(nextPos);
    }

    protected double getOnHitMotionReduction() {
        return 0.7;
    }

    protected double getOnHitKickBack() {
        return 0.1;
    }
}

