/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.common.Args;
import com.endertech.common.CommonString;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.api.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.RelatedBlock;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.ForgeBlockItem;
import com.endertech.minecraft.forge.materials.CraftingRecipe;
import com.endertech.minecraft.forge.math.AABB;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.mods.adchimneys.Main;
import com.endertech.minecraft.mods.adchimneys.blocks.TileEntityPump;
import com.endertech.minecraft.mods.adchimneys.init.Groups;
import com.endertech.minecraft.mods.adchimneys.world.WorldData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Container
extends RelatedBlock
implements ISmokeContainer {
    public static boolean displayVents = true;
    public static boolean displayPumps = true;
    public static final PropertyEnum<Type> TYPE = Container.createPropertyEnum(Type.class);
    public static final float WALL_THICKNESS = 0.125f;
    static final List<AxisAlignedBB> AABB_WALLS = AABB.getWalls((float)0.125f);
    private final ColorARGB color;

    public Container(ForgeMod mod, UnitConfig config, String name, UnitId relatedBlockId, ColorARGB color, int stackSize) {
        super(mod, config, name, relatedBlockId, (CreativeTabs)Main.CREATIVE_TAB);
        this.color = ForgeConfig.getColorARGB((ForgeConfig)config, (String)this.getUnitCategory(), (String)"color", (ColorARGB)color, (String)"Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb) which will be applied to the smoke.\nThe alpha channel of this color (aa) determines probability of applying (ff - always, 7f - 1/2, 00 - never).\n");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)Type.CHIMNEY)));
        this.func_149675_a(true);
        this.setUnitVariants(Type.class);
        this.addCraftingRecipeFor(Type.CHIMNEY, "101 101 101", stackSize, this.getRelatedId().toString());
        this.addCraftingRecipeFor(Type.VENT, "101 000 101", 4, this.getIdFor(Type.CHIMNEY).toString());
        this.addCraftingRecipeFor(Type.PUMP, "121 232 121", 4, this.getIdFor(Type.VENT).toString(), "repeater", "blockCoal");
    }

    protected void addCraftingRecipeFor(Type type, String pattern, int amount, String ... components) {
        CraftingRecipe recipe = CraftingRecipe.CreateMain((String)type.getCategoryName(), (ForgeConfig)this.getConfig(), (String)pattern, (String)this.getIdFor(type).toString(), (int)amount, (String[])components);
        this.addCraftingRecipe(recipe);
    }

    protected IBlockState getStateFor(Type type) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)type));
    }

    protected UnitId getIdFor(Type type) {
        IBlockState state = this.getStateFor(type);
        int meta = this.func_176201_c(state);
        return this.getId().withMeta(meta);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (this.isChimney(state)) {
            for (AxisAlignedBB wall : AABB_WALLS) {
                Container.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)wall);
            }
        } else {
            super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(TYPE))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)Type.values()[meta]));
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (Type type : Type.values()) {
            boolean transparent;
            if (type == Type.VENT && !displayVents || type == Type.PUMP && !displayPumps) continue;
            Material material = this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)type)).func_185904_a();
            boolean bl = transparent = !material.func_76218_k() || material == Material.field_151592_s;
            if (type != Type.CHIMNEY && transparent || !this.isEnabled() || !this.getGroup().display) continue;
            items.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    public Groups getGroup() {
        String blockName = this.getId().getRegName();
        if (blockName.contains("hardened_clay")) {
            return Groups.TERRACOTTA;
        }
        for (Groups group : Groups.values()) {
            if (!blockName.contains(group.func_176610_l())) continue;
            return group;
        }
        return Groups.OTHER;
    }

    public ColorARGB getColor() {
        return this.color;
    }

    public ItemBlock createBlockItem() {
        ForgeBlockItem blockItem = new ForgeBlockItem((ForgeBlock)this){

            public String func_77667_c(ItemStack stack) {
                int meta = stack.func_77960_j();
                return super.func_77667_c(stack) + "." + Type.values()[meta].func_176610_l();
            }
        };
        return blockItem;
    }

    public boolean isEnabled() {
        return super.isEnabled() && this.getGroup().isEnabled();
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (this.isChimney(state)) {
            switch (side) {
                case DOWN: 
                case UP: {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    public String toString() {
        return Container.class.getSimpleName() + Args.group((Object[])new Object[]{Args.get((String)"color", (Object)this.getColor().getHexARGB()), Args.get((String)"relatedUnitId", (Object)this.getRelatedId())});
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.isSideSolid(state, world, pos, EnumFacing.UP);
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return this.isSideSolid(state, world, pos, facing) ? BlockFaceShape.SOLID : BlockFaceShape.BOWL;
    }

    public int func_149717_k(IBlockState state) {
        if (this.isOpaqueMaterial(state)) {
            return this.isChimney(state) ? 2 : 16;
        }
        return 0;
    }

    public boolean isOpaqueMaterial(IBlockState state) {
        return state.func_185904_a().func_76218_k() && state.func_185904_a() != Material.field_151592_s;
    }

    public boolean func_149662_c(IBlockState state) {
        if (this.isChimney(state)) {
            return false;
        }
        return this.isOpaqueMaterial(state);
    }

    public boolean func_185481_k(IBlockState state) {
        if (this.isChimney(state)) {
            return false;
        }
        return super.func_185481_k(state);
    }

    public boolean func_149686_d(IBlockState state) {
        return !this.isChimney(state);
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.isVent(state)) {
            switch (face) {
                case DOWN: 
                case UP: {
                    return true;
                }
            }
        } else if (this.isPump(state) && face == EnumFacing.DOWN) {
            return true;
        }
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149751_l(IBlockState state) {
        return this.func_180664_k() == BlockRenderLayer.TRANSLUCENT || state.func_185904_a() == Material.field_151592_s;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return this.isChimney(blockState) && !this.func_149751_l(blockState) ? super.func_176225_a(blockState, blockAccess, pos, side) : true;
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return this.isChimney(state);
    }

    public boolean isPump(IBlockState state) {
        Type value = (Type)((Object)state.func_177229_b(TYPE));
        return value == Type.PUMP;
    }

    public boolean isVent(IBlockState state) {
        return state.func_177229_b(TYPE) == Type.VENT;
    }

    public boolean isChimney(IBlockState state) {
        return state.func_177229_b(TYPE) == Type.CHIMNEY;
    }

    public boolean hasTileEntity(IBlockState state) {
        return this.isPump(state);
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return this.isPump(state) ? new TileEntityPump() : null;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile;
        IBlockState checkState = world.func_180495_p(pos);
        if (state != checkState) {
            return 0;
        }
        if (this.isPump(state) && (tile = world.func_175625_s(pos)) != null && this.isActive(tile.func_145831_w(), pos)) {
            return 1;
        }
        int value = super.getLightValue(state, world, pos);
        return value;
    }

    public boolean isActive(World world, BlockPos pos) {
        TileEntity tile;
        IBlockState state = world.func_180495_p(pos);
        if (this.isPump(state) && (tile = world.func_175625_s(pos)) instanceof TileEntityPump) {
            return ((TileEntityPump)tile).isActive();
        }
        return false;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (this.isServerSide(world)) {
            WorldData data = WorldData.getData(world);
            ForgeWorld.Position.getAroundHoriz((BlockPos)pos, (boolean)false, (BlockPos[])new BlockPos[]{pos.func_177977_b()}).forEach(data::updateSmokeEmitterAt);
        }
    }

    public static enum Type implements IForgeEnum
    {
        CHIMNEY,
        VENT,
        PUMP;


        public String func_176610_l() {
            return this.getLowerCase(this.name());
        }

        public String getCategoryName() {
            return CommonString.capitalizeFirstChar((String)this.func_176610_l());
        }
    }
}

