/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeGui;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.blocks.ForgeBlockContainer;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.messages.TileSharedDataMsg;
import com.endertech.minecraft.forge.units.ForgeTileEntity;
import com.endertech.minecraft.mods.adchimneys.Main;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.smoke.ISmokeEmitter;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import java.awt.Color;
import java.awt.Rectangle;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiSlider;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Smoker
extends ForgeBlockContainer<Tile>
implements ISmokeEmitter {
    private static ColorARGB DEFAULT_COLOR = ColorARGB.from((int)-2004844416);
    private static Smoke DEFAULT_SMOKE = new Smoke();
    private static Emitter DEFAULT_EMITTER = new Emitter();
    private final Gui gui;

    public Smoker(ForgeMod mod, UnitConfig config) {
        super(mod, config, Tile.class, "", Material.field_151576_e, (CreativeTabs)Main.CREATIVE_TAB);
        this.gui = new Gui(mod);
        this.func_149711_c(1.5f);
        this.setResistance(30.0f);
        DEFAULT_SMOKE = new Smoke(config, 5.0f, 1.0f, 2.0f);
        DEFAULT_EMITTER = new Emitter(config, this.getId(), DEFAULT_SMOKE, DEFAULT_COLOR, true, true, "", "", false, new String[0]);
        this.addCraftingRecipe("314 151 626", 4, new String[]{"repeater", "comparator", "blockIron", "blockGold", "blockRedstone", "blockCoal"});
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @Override
    public Emitter getEmitter(World world, BlockPos pos) {
        Tile tile;
        TileEntity tileEntity = this.getTileEntity(world, pos);
        if (tileEntity instanceof Tile && (!(tile = (Tile)tileEntity).isNeedRedstonePower() || world.func_175640_z(pos))) {
            return tile.getEmitter();
        }
        return new Emitter();
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        this.gui.openFor(playerIn, 0, pos);
        return true;
    }

    public Gui getGui() {
        return this.gui;
    }

    public class Gui
    extends ForgeGui {
        public Gui(ForgeMod mod) {
            super(mod);
        }

        public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
            return null;
        }

        public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
            BlockPos pos;
            Tile tile;
            if (ID == 0 && (tile = (Tile)world.func_175625_s(pos = new BlockPos(x, y, z))) != null) {
                return new Screen(tile);
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public class Screen
        extends ForgeGui.Screen
        implements GuiSlider.ISlider {
            static final int ID = 0;
            private final Tile tile;
            private GuiSlider sliderAmount;
            private GuiSlider sliderIntencity;
            private GuiSlider sliderScale;
            private GuiSlider sliderColor;
            private GuiSlider sliderColorPercentage;
            private GuiCheckBox checkboxCanEmittAside;
            private GuiCheckBox checkboxEmitWithoutChimney;
            private GuiCheckBox checkboxNeedRedstonePower;

            public Screen(Tile tile) {
                super((ForgeGui)Gui.this);
                this.tile = tile;
            }

            public void func_73866_w_() {
                this.setColumnsAmount(1);
                Smoke smoke = this.tile.getEmitter().getSmoke();
                Emitter emitter = this.tile.getEmitter();
                this.addLabel(Smoker.this.getClassCategory(), Color.WHITE.getRGB());
                this.sliderAmount = this.addSlider("Amount", new FloatBounds(Float.valueOf(0.0f), Float.valueOf(Smoke.maxAmount)), smoke.getAmount(), this);
                this.sliderIntencity = this.addSlider("Intencity", new FloatBounds(Float.valueOf(0.0f), Float.valueOf(Smoke.maxIntencity)), smoke.getIntencity(), this);
                this.sliderScale = this.addSlider("Scale", new FloatBounds(Float.valueOf(1.0f), Float.valueOf(Smoke.maxScale)), smoke.getScale(), this);
                this.sliderColor = this.addSlider("Color", new IntBounds(Integer.valueOf(0), Integer.valueOf(0xFFFFFF)), emitter.getColor().getARGB() & 0xFFFFFF, this);
                this.sliderColorPercentage = this.addSlider("Color Percentage", new IntBounds(Integer.valueOf(0), Integer.valueOf(100)), Math.round(emitter.getColor().getAlpha().toFloat() * 100.0f), this);
                this.checkboxCanEmittAside = this.addCheckBox("Can emitt aside", emitter.canEmitAside());
                this.checkboxEmitWithoutChimney = this.addCheckBox("Emit without chimney", emitter.emitWithoutChimney());
                this.checkboxNeedRedstonePower = this.addCheckBox("Need redstone power", this.tile.isNeedRedstonePower());
                super.func_73866_w_();
            }

            public void onChangeSliderValue(GuiSlider slider) {
                if (slider == this.sliderColor) {
                    Rectangle rect = this.getControlRect(slider.field_146127_k);
                    net.minecraft.client.gui.Gui.func_73734_a((int)rect.x, (int)rect.y, (int)(rect.x + rect.width), (int)(rect.y + rect.height), (int)(slider.getValueInt() | 0xFF000000));
                }
            }

            protected void onAccept() {
                ColorARGB.Channel alpha = ColorARGB.Channel.fromFloat((float)((float)this.sliderColorPercentage.getValue() / 100.0f));
                ColorARGB color = ColorARGB.from((int)this.sliderColor.getValueInt()).withAlpha(alpha);
                Smoke smoke = new Smoke(null, (float)this.sliderAmount.getValue(), (float)this.sliderIntencity.getValue(), (float)this.sliderScale.getValue());
                Emitter emitter = new Emitter(smoke, color, this.checkboxCanEmittAside.isChecked(), this.checkboxEmitWithoutChimney.isChecked());
                this.tile.setNeedRedstonePower(this.checkboxNeedRedstonePower.isChecked());
                this.tile.setEmitter(emitter);
                TileSharedDataMsg message = new TileSharedDataMsg(this.tile.getSharedData(), this.tile.func_174877_v());
                ForgeMain.instance.getConnection().sendToServer((IMessage)message);
            }
        }
    }

    public static class Tile
    extends ForgeTileEntity {
        private Emitter emitter;
        private boolean needRedstonePower = false;

        public Tile() {
            this.setEmitter(DEFAULT_EMITTER);
        }

        public void readSharedData(NBTTagCompound compound) {
            this.setEmitter(Emitter.getFromNBT(compound.func_74775_l(Tags.EMITTER.name())));
            this.setNeedRedstonePower(compound.func_74767_n(Tags.NEED_REDSTONE_POWER.name()));
        }

        public void writeSharedData(NBTTagCompound compound) {
            NBTTagCompound tagEmitter = new NBTTagCompound();
            this.getEmitter().writeToNBT(tagEmitter);
            compound.func_74782_a(Tags.EMITTER.name(), (NBTBase)tagEmitter);
            compound.func_74757_a(Tags.NEED_REDSTONE_POWER.name(), this.isNeedRedstonePower());
        }

        public Emitter getEmitter() {
            return this.emitter;
        }

        public void setEmitter(Emitter emitter) {
            this.emitter = emitter;
        }

        public boolean isNeedRedstonePower() {
            return this.needRedstonePower;
        }

        public void setNeedRedstonePower(boolean needRedstonePower) {
            this.needRedstonePower = needRedstonePower;
        }

        private static enum Tags {
            EMITTER,
            NEED_REDSTONE_POWER;

        }
    }
}

