/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.network;

import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.messages.ForgeNetMsg;
import com.endertech.minecraft.forge.messages.ForgeNetMsgHandler;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.world.Events;
import com.endertech.minecraft.mods.adchimneys.world.SmokeLocations;
import com.endertech.minecraft.mods.adchimneys.world.WorldData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class SmokePosMsg
extends ForgeNetMsg {
    public BlockPos pos;
    public float amount;
    public float intencity;
    public float scale;
    public ColorARGB color;

    public SmokePosMsg() {
    }

    public SmokePosMsg(BlockPos pos, Smoke smoke) {
        this.pos = pos;
        this.amount = smoke.getAmount();
        this.intencity = smoke.getIntencity();
        this.scale = smoke.getScale();
        this.color = smoke.getFirstColorOrDefault();
    }

    public static class Handler
    extends ForgeNetMsgHandler<SmokePosMsg> {
        public IMessage onMessage(SmokePosMsg message, MessageContext ctx) {
            World world = this.getWorld(ctx);
            if (world != null) {
                this.addScheduledTask(ctx, () -> {
                    Smoke smoke = new Smoke(null, message.amount, message.intencity, message.scale, message.color);
                    SmokeLocations locations = WorldData.getData(world).getSmokeLocations();
                    Smoke existedSmoke = locations.get(message.pos);
                    if (existedSmoke != null && existedSmoke.getLifeTime().lessThan(Events.serverUpdateInterval.getInterval())) {
                        smoke = smoke.combine(existedSmoke);
                    }
                    locations.add(message.pos, smoke);
                });
            }
            return null;
        }
    }
}

