/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.smoke;

import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.api.ISmokeContainer;
import com.endertech.minecraft.forge.api.IWind;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.endertech.minecraft.forge.world.Wind;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleSmokeNormal;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class SmokeParticle
extends ParticleSmokeNormal {
    protected static final IntBounds TEXTURE_INDEX_BOUNDS = new IntBounds(Integer.valueOf(0), Integer.valueOf(7));
    private static final int MAX_HIT_AFTER_HIT_AMOUNT = 2;
    private static final double ON_HIT_MOTION_REDICTION = 0.7;
    private static final double ON_HIT_KICK_BACK = 0.05;
    protected int ticksInChimney = 0;
    protected final IWind wind;
    private int hitAfterHitCount = 0;

    public SmokeParticle(World world, IWind wind, Vect3d pos, float intencity, float scale, ColorARGB color) {
        super(world, pos.x, pos.y, pos.z, 0.0, (double)intencity / 10.0 * CommonMath.Random.between((double)0.5, (double)1.0), 0.0, scale);
        this.wind = wind;
        this.setColor(color);
        this.field_187129_i = 0.0;
        this.field_187131_k = 0.0;
        this.field_190017_n = Smoke.canCollide;
        if (Smoke.translucentTexture) {
            this.field_82339_as = 0.99f;
        }
        ++ForgeWorld.getData((World)world).smokeParticlesCount;
    }

    public void func_187112_i() {
        --ForgeWorld.getData((World)this.field_187122_b).smokeParticlesCount;
        super.func_187112_i();
    }

    public Vect3d getPosition() {
        return Vect3d.from((double)this.field_187126_f, (double)this.field_187127_g, (double)this.field_187128_h);
    }

    public Vect3d getMotion() {
        return Vect3d.from((double)this.field_187129_i, (double)this.field_187130_j, (double)this.field_187131_k);
    }

    public void setMotion(Vect3d motion) {
        this.field_187129_i = motion.x;
        this.field_187130_j = motion.y;
        this.field_187131_k = motion.z;
    }

    public void setColor(ColorARGB color) {
        this.func_70538_b(color.getRed().toFloat(), color.getGreen().toFloat(), color.getBlue().toFloat());
    }

    public void setPosition(Vect3d pos) {
        this.func_187109_b(pos.x, pos.y, pos.z);
    }

    public BlockPos getBlockPos() {
        return new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
    }

    protected void tryColorizeWith(ColorARGB color) {
        float alpha = color.getAlpha().toFloat();
        if (CommonMath.Random.result((float)(alpha * Smoke.coloringFactor))) {
            this.setColor(color);
        }
    }

    protected void updateTextureIndex() {
        int age = this.field_70546_d - this.ticksInChimney;
        int maxAge = this.field_70547_e - this.ticksInChimney;
        int index = 7 - age * 8 / maxAge;
        this.func_70536_a(index);
    }

    public void func_189213_a() {
        IWind wind;
        this.field_187122_b.field_72984_F.func_76320_a("smokeParticle.update");
        ++this.field_70546_d;
        if (this.field_70546_d >= this.field_70547_e) {
            this.func_187112_i();
        }
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        BlockPos blockPos = this.getBlockPos();
        IBlockState state = this.field_187122_b.func_180495_p(blockPos);
        Block block = state.func_177230_c();
        boolean inSolidBlock = true;
        for (EnumFacing facing : ForgeWorld.Direction.CLOCKWISE_HORIZONTALS) {
            if (state.isSideSolid((IBlockAccess)this.field_187122_b, blockPos, facing)) continue;
            inSolidBlock = false;
            break;
        }
        boolean canSeeSky = false;
        if (!inSolidBlock) {
            for (BlockPos pos : ForgeWorld.Position.getAroundHoriz((BlockPos)blockPos, (boolean)true, (BlockPos[])new BlockPos[0])) {
                if (!this.field_187122_b.func_175678_i(pos)) continue;
                canSeeSky = true;
                break;
            }
        }
        Object object = wind = !inSolidBlock || canSeeSky ? this.wind : Wind.NONE;
        if (block instanceof ISmokeContainer) {
            ISmokeContainer container = (ISmokeContainer)block;
            if (container.isChimney(state) && CommonMath.notZero((double)this.field_187130_j) && this.field_187130_j > 0.0) {
                ColorARGB color = container.getColor();
                this.tryColorizeWith(color);
                ++this.ticksInChimney;
                if (!this.field_187132_l) {
                    ++this.field_70547_e;
                }
            } else {
                this.func_187112_i();
                this.field_187122_b.field_72984_F.func_76319_b();
                return;
            }
        }
        this.updateTextureIndex();
        this.field_187130_j += 0.004;
        Vect3d motion = this.getMotion().add(wind.getMotion());
        this.move(motion);
        this.field_187130_j *= (double)0.96f;
        this.field_187122_b.field_72984_F.func_76319_b();
    }

    public void func_187110_a(double dx, double dy, double dz) {
        this.move(Vect3d.from((double)dx, (double)dy, (double)dz));
    }

    public void move(Vect3d motion) {
        Vect3d nextPos = this.getPosition().add(motion);
        this.moveTo(nextPos);
    }

    private void moveTo(Vect3d nextPos) {
        if (this.field_190017_n) {
            BlockPos pos;
            if (this.hitAfterHitCount > 2) {
                this.func_187112_i();
                return;
            }
            Vect3d curPos = this.getPosition();
            RayTraceResult rayTrace = ForgeWorld.rayTraceBlocks((World)this.field_187122_b, (Vect3d)curPos, (Vect3d)nextPos, (boolean)false);
            if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && this.field_187122_b.func_180495_p(pos = rayTrace.func_178782_a()).func_193401_d((IBlockAccess)this.field_187122_b, pos, rayTrace.field_178784_b) == BlockFaceShape.SOLID) {
                ++this.hitAfterHitCount;
                EnumFacing.Axis axis = rayTrace.field_178784_b.func_176740_k();
                Vect3d hitVec = Vect3d.from((Vec3d)rayTrace.field_72307_f);
                Vect3d bounceVec = nextPos.subtract(hitVec);
                switch (axis) {
                    case X: {
                        bounceVec = bounceVec.invertX();
                        this.field_187129_i = -this.field_187129_i;
                        break;
                    }
                    case Z: {
                        bounceVec = bounceVec.invertZ();
                        this.field_187131_k = -this.field_187131_k;
                        break;
                    }
                    case Y: {
                        bounceVec = bounceVec.invertY();
                        CommonMath.Angle angle = CommonMath.Angle.random();
                        double motion = this.field_187130_j * this.getOnHitMotionReduction();
                        this.field_187129_i = angle.cos() * motion;
                        this.field_187131_k = angle.sin() * motion;
                        this.field_187130_j = 0.0;
                        this.field_190017_n = false;
                        this.field_187132_l = true;
                        break;
                    }
                    default: {
                        this.func_187112_i();
                        return;
                    }
                }
                nextPos = hitVec.add(bounceVec);
                this.moveTo(nextPos);
                return;
            }
        }
        this.hitAfterHitCount = 0;
        this.setPosition(nextPos);
    }

    protected double getOnHitMotionReduction() {
        return 0.7;
    }

    protected double getOnHitKickBack() {
        return 0.05;
    }

    public boolean func_187111_c() {
        return Smoke.translucentTexture;
    }
}

