/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.messages;

import com.endertech.common.Args;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.api.IWind;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.ForgeKeys;
import com.endertech.minecraft.forge.configs.ForgeNBT;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.materials.ForgeMaterial;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.tools.ForgeTool;
import com.endertech.minecraft.forge.units.ItemState;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.ForgeWorld;
import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class DevInfo {
    static final GameTime UPDATE_INTERVAL = GameTime.quaterSecond();
    static final GameTime EXCEPTION_PRINT_INTERVAL = GameTime.seconds(10);
    protected static float rayTraceDistance = 10.0f;
    protected static boolean showInventoryTooltip = false;
    protected static boolean renderGameOverlay = false;
    protected static KeyBinding keyToggleDevInfo;
    private static RayTraceResult rayTraceResult;

    @SubscribeEvent
    public static void onKeyPressed(InputEvent.KeyInputEvent event) {
        if (ForgeMain.isDebugMode() && Keyboard.isKeyDown((int)70) && Keyboard.isKeyDown((int)42)) {
            showInventoryTooltip = !showInventoryTooltip;
            renderGameOverlay = !renderGameOverlay;
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onInventoryTooltip(ItemTooltipEvent event) {
        if (!showInventoryTooltip) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (!stack.func_190926_b()) {
            List lines = event.getToolTip();
            DevInfo.addItemInfo(stack, lines);
        }
    }

    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        block11: {
            if (!renderGameOverlay) {
                return;
            }
            Minecraft mc = Minecraft.func_71410_x();
            GameSettings gs = ForgeKeys.getGameSettings();
            if (mc.field_71462_r == null && event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HOTBAR)) {
                try {
                    boolean shouldRecalcTraceResult;
                    ArrayList<String> lines = new ArrayList<String>();
                    DevInfo.addWorldInfo(mc.field_71441_e, lines);
                    lines.add("");
                    boolean bl = shouldRecalcTraceResult = rayTraceResult == null || UPDATE_INTERVAL.pastIn((World)mc.field_71441_e);
                    if (shouldRecalcTraceResult) {
                        rayTraceResult = ForgeKeys.isDown(gs.field_151444_V) ? mc.field_71476_x : ForgeEntity.rayTraceBlockBeingLookedAt((Entity)mc.field_71439_g, event.getPartialTicks(), rayTraceDistance);
                    }
                    if (rayTraceResult != null) {
                        switch (DevInfo.rayTraceResult.field_72313_a) {
                            case BLOCK: {
                                DevInfo.addBlockInfo(mc.field_71441_e, rayTraceResult.func_178782_a(), lines);
                                break;
                            }
                            case ENTITY: {
                                DevInfo.addEntityInfo(DevInfo.rayTraceResult.field_72308_g, lines);
                                break;
                            }
                        }
                    }
                    GL11.glPushMatrix();
                    GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
                    int color = -2130706433;
                    int x = 2;
                    int y = 2;
                    int step = 10;
                    for (String line : lines) {
                        mc.field_71466_p.func_175063_a(line, (float)x, (float)y, color);
                        y += step;
                    }
                    GL11.glPopMatrix();
                }
                catch (Exception e) {
                    if (!EXCEPTION_PRINT_INTERVAL.pastIn((World)mc.field_71441_e)) break block11;
                    e.printStackTrace();
                }
            }
        }
    }

    protected static void addCaptionLine(List<String> lines, String caption) {
        lines.add("==" + caption + "==");
    }

    protected static void addInfoLine(List<String> lines, String caption, Object value) {
        lines.add(DevInfo.underlined(caption + ": ") + value);
    }

    protected static void addWorldInfo(WorldClient world, List<String> lines) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        BlockPos pos = player.func_180425_c();
        Biome biome = world.func_180494_b(pos);
        ForgeWorld.WorldData data = ForgeWorld.getData((World)world);
        IWind wind = ForgeWorld.getWindAt((World)world, pos);
        DevInfo.addCaptionLine(lines, "World Info");
        DevInfo.addInfoLine(lines, "Biome", biome.getRegistryName() + ":" + Biome.func_185362_a((Biome)biome) + " (" + biome.func_185359_l() + ")");
        DevInfo.addInfoLine(lines, "Wind", Float.valueOf(wind.getStrengthIn(player.func_174811_aO())));
        DevInfo.addInfoLine(lines, "isRaining", world.func_72896_J());
        DevInfo.addInfoLine(lines, "Strength", "rain = " + world.field_73004_o + ", thunder = " + world.field_73017_q);
        DevInfo.addInfoLine(lines, "SmokeParticles", data.smokeParticlesCount);
        DevInfo.addInfoLine(lines, "Time", world.func_72820_D());
    }

    protected static void addBlockInfo(WorldClient world, BlockPos pos, List<String> lines) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        UnitId id = UnitId.from(state);
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        DevInfo.addCaptionLine(lines, "Block Info");
        lines.add(DevInfo.formatedId(id) + " (" + Args.get("dropped_meta", ForgeWorld.getBlockDroppedState((World)world, pos).getMeta()) + ")");
        DevInfo.addInfoLine(lines, "State", state);
        DevInfo.addInfoLine(lines, "StateId", Block.func_176210_f((IBlockState)state));
        DevInfo.addInfoLine(lines, "Unlocalized Name", block.func_149739_a());
        DevInfo.addInfoLine(lines, "Material", ForgeMaterial.VanillaMaterials.getNameFor(state.func_185904_a(), "???"));
        DevInfo.addInfoLine(lines, "Hardness", Float.valueOf(state.func_185887_b((World)world, pos)));
        DevInfo.addInfoLine(lines, "Resistance", Float.valueOf(block.func_149638_a((Entity)player)));
        DevInfo.addInfoLine(lines, "Harvest level", block.getHarvestLevel(state));
        DevInfo.addInfoLine(lines, "Opacity", world.getBlockLightOpacity(pos));
        DevInfo.addInfoLine(lines, "CanSeeSky", ForgeBlock.isUnderOpenSky((World)world, pos));
        DevInfo.addInfoLine(lines, "isUnderRain", ForgeBlock.isUnderRain((World)world, pos));
        DevInfo.addInfoLine(lines, "PrecipitationHeight", world.func_175725_q(pos).func_177956_o());
        DevInfo.addInfoLine(lines, "BlockPos", Args.join(Args.get("x", pos.func_177958_n()), Args.get("y", pos.func_177956_o()), Args.get("z", pos.func_177952_p())));
        EnumFacing side = DevInfo.rayTraceResult.field_178784_b;
        DevInfo.addInfoLine(lines, "Side", Args.join(Args.get("face", side), Args.get("shape", state.func_193401_d((IBlockAccess)world, pos, side)), Args.get("isSolid", state.isSideSolid((IBlockAccess)world, pos, side))));
        DevInfo.addInfoLine(lines, "CollisionBB", state.func_185890_d((IBlockAccess)world, pos));
        DevInfo.addInfoLine(lines, "TileEntity", world.func_175625_s(pos));
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            tile.func_189515_b(nbt);
            DevInfo.addCompoundInfo(nbt, lines);
        }
    }

    static void addEntityInfo(Entity entity, List<String> lines) {
        DevInfo.addCaptionLine(lines, "Entity Info");
        DevInfo.addInfoLine(lines, "id", EntityList.func_191301_a((Entity)entity));
        DevInfo.addInfoLine(lines, "name", entity.func_70005_c_());
        DevInfo.addInfoLine(lines, "isUnderRain", ForgeEntity.isUnderRain(entity));
        NBTTagCompound nbt = new NBTTagCompound();
        DevInfo.addCompoundInfo(entity.func_189511_e(nbt), lines);
    }

    protected static void addItemInfo(ItemStack stack, List<String> lines) {
        Item item = stack.func_77973_b();
        UnitId unitId = UnitId.from(ItemState.from(stack));
        if (item instanceof ForgeTool) {
            ForgeTool tool = (ForgeTool)item;
            DevInfo.addInfoLine(lines, "Harvest Level", tool.getHarvestLevel());
        }
        DevInfo.addInfoLine(lines, "Durability", stack.func_77958_k());
        lines.add(DevInfo.formatedId(unitId));
        DevInfo.addInfoLine(lines, "BurnTime", item.getItemBurnTime(stack));
        DevInfo.addInfoLine(lines, "Unlocalized name", item.func_77667_c(stack));
        Object[] oreNames = ForgeItem.getOreDictNamesFor(stack).toArray();
        DevInfo.addInfoLine(lines, "Dict", Args.join(oreNames));
        DevInfo.addCompoundInfo(stack.func_77978_p(), lines);
    }

    protected static void addCompoundInfo(NBTTagCompound compound, List<String> lines) {
        if (compound != null) {
            lines.add(DevInfo.underlined("NBT: "));
            for (String key : compound.func_150296_c()) {
                ForgeNBT.Types type = ForgeNBT.getType(compound, key);
                String line = DevInfo.reset() + type.toString() + " " + key;
                if (type.isOrdinal() || type == ForgeNBT.Types.STRING) {
                    line = line + " = " + compound.func_74781_a(key).toString();
                }
                lines.add(line);
            }
        } else {
            lines.add("no NBT");
        }
    }

    protected static String underlined(String string) {
        return ChatFormatting.UNDERLINE + string + ChatFormatting.RESET;
    }

    protected static ChatFormatting reset() {
        return ChatFormatting.RESET;
    }

    protected static String formatedId(UnitId id) {
        return DevInfo.underlined("ID: ") + id;
    }

    static {
        rayTraceResult = null;
    }
}

