/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.data.ForgeEnergy;
import com.endertech.minecraft.forge.entities.ForgeTileEntity;
import com.endertech.minecraft.forge.items.ItemGroup;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import com.endertech.minecraft.mods.adchimneys.blocks.Vent;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IEnviromentBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;

public class Pump
extends Vent {
    public static final ItemGroup ITEM_GROUP = ItemGroup.labeled((String)"pumps").changeEvery(3.0f, 6.0f);
    public static boolean invertedRedstronSignal;
    public static ForgeEnergy.StorageProps energyStorageProps;
    protected static final VoxelShape HOLES_TOP;
    protected static final VoxelShape SHAPE;

    public Pump(ForgeMod mod, UnitConfig config, Container.Properties<?> props) {
        super(mod, config, props);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new Tile();
    }

    @Override
    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public int getLightValue(BlockState state, IEnviromentBlockReader world, BlockPos pos) {
        return this.isActive((IBlockReader)world, pos) ? 1 : super.getLightValue(state, world, pos);
    }

    @Override
    public boolean isActive(IBlockReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof Tile) {
            return ((Tile)tile).isActive();
        }
        return false;
    }

    @Override
    public ISmokeContainer.Type getType() {
        return ISmokeContainer.Type.PUMP;
    }

    static {
        HOLES_TOP = VoxelShapes.func_216384_a((VoxelShape)Pump.func_208617_a((double)3.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)6.0), (VoxelShape[])new VoxelShape[]{Pump.func_208617_a((double)3.0, (double)13.0, (double)10.0, (double)13.0, (double)16.0, (double)13.0), Pump.func_208617_a((double)3.0, (double)13.0, (double)3.0, (double)6.0, (double)16.0, (double)13.0), Pump.func_208617_a((double)10.0, (double)13.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0)});
        VoxelShape core = Pump.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
        VoxelShape shape = VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)VoxelShapes.func_216384_a((VoxelShape)HOLE_CENTER, (VoxelShape[])new VoxelShape[]{HOLES_X, HOLES_Z, HOLES_TOP}), (IBooleanFunction)IBooleanFunction.field_223234_e_);
        SHAPE = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)core);
    }

    public static class Tile
    extends ForgeTileEntity
    implements ITickableTileEntity {
        public static TileEntityType<Tile> TYPE;
        protected final GameTime updateInterval = GameTime.second();
        protected final ForgeEnergy.Storage energyStorage = ForgeEnergy.Storage.with((ForgeEnergy.StorageProps)energyStorageProps);

        public Tile() {
            super(TYPE);
        }

        protected boolean isEmitterConnected() {
            Emitter emitter;
            BlockPos checkPos = this.func_174877_v().func_177984_a();
            if (GameWorld.SmokeContainers.isChimney((IWorldReader)this.field_145850_b, (BlockPos)checkPos)) {
                checkPos = GameWorld.SmokeContainers.getTopmostChimney((IWorldReader)this.field_145850_b, (BlockPos)checkPos);
                checkPos = checkPos.func_177984_a();
            }
            return (emitter = AdChimneys.getEmitters().findBy((IWorldReader)this.field_145850_b, checkPos)) != null;
        }

        public boolean isActive() {
            boolean powered = this.field_145850_b.func_175640_z(this.field_174879_c);
            if (invertedRedstronSignal) {
                boolean bl = powered = !powered;
            }
            if (this.energyStorage.isEnabled() && !this.energyStorage.hasEnoughEnergy()) {
                powered = false;
            }
            return powered;
        }

        public void func_73660_a() {
            if (GameWorld.isServerSide((IWorldReader)this.field_145850_b) && this.updateInterval.pastIn(this.field_145850_b) && this.isActive()) {
                this.energyStorage.consumeEnergy();
                BlockPos outletPos = this.field_174879_c.func_177984_a();
                BlockState outletState = this.field_145850_b.func_180495_p(outletPos);
                if (!(!outletState.isAir((IBlockReader)this.field_145850_b, outletPos) && Block.func_220056_d((BlockState)outletState, (IBlockReader)this.field_145850_b, (BlockPos)outletPos, (Direction)Direction.DOWN) || this.isEmitterConnected())) {
                    List vents = GameWorld.SmokeContainers.getVentsAround((IWorldReader)this.field_145850_b, (BlockPos)this.field_174879_c);
                    vents.add(this.field_174879_c);
                    Vent.Pipe.build(this.field_145850_b, vents, outletPos);
                }
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            if (cap == CapabilityEnergy.ENERGY && this.energyStorage.isEnabled()) {
                return LazyOptional.of(() -> this.energyStorage).cast();
            }
            return super.getCapability(cap, side);
        }

        public void readSharedData(CompoundNBT compound) {
            this.energyStorage.readFrom(compound);
        }

        public CompoundNBT writeSharedData(CompoundNBT compound) {
            this.energyStorage.writeTo(compound);
            return compound;
        }
    }
}

