/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.blocks.IWaterLoggable;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.ForgeMod;
import com.endertech.minecraft.forge.items.ItemGroup;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adchimneys.blocks.Container;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class Vent
extends Container {
    public static final ItemGroup ITEM_GROUP = ItemGroup.labeled((String)"vents").changeEvery(3.0f, 6.0f);
    protected static final VoxelShape HOLE_CENTER = Vent.func_208617_a((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    protected static final VoxelShape HOLES_Z = VoxelShapes.func_197872_a((VoxelShape)Vent.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)6.0, (double)13.0, (double)16.0), (VoxelShape)Vent.func_208617_a((double)10.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0));
    protected static final VoxelShape HOLES_X = VoxelShapes.func_197872_a((VoxelShape)Vent.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)6.0), (VoxelShape)Vent.func_208617_a((double)0.0, (double)3.0, (double)10.0, (double)16.0, (double)13.0, (double)13.0));
    protected static final VoxelShape SHAPE;

    public Vent(ForgeMod mod, UnitConfig config, Container.Properties<?> props) {
        super(mod, config, props);
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return VoxelShapes.func_197868_b();
    }

    public ISmokeContainer.Type getType() {
        return ISmokeContainer.Type.VENT;
    }

    public boolean isActive(IBlockReader world, BlockPos pos) {
        return !IWaterLoggable.isWaterlogged((BlockState)world.func_180495_p(pos));
    }

    static {
        VoxelShape core = Vent.func_208617_a((double)3.0, (double)5.0, (double)3.0, (double)13.0, (double)11.0, (double)13.0);
        VoxelShape shape = VoxelShapes.func_197882_b((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)VoxelShapes.func_216384_a((VoxelShape)HOLE_CENTER, (VoxelShape[])new VoxelShape[]{HOLES_X, HOLES_Z}), (IBooleanFunction)IBooleanFunction.field_223234_e_);
        SHAPE = VoxelShapes.func_197872_a((VoxelShape)shape, (VoxelShape)core);
    }

    public static class Pipe
    extends WorldSearch.BlockChain {
        private final BlockPos outletPos;

        protected Pipe(World world, BlockPos startPos, BlockPos outletPos) {
            super((IWorld)world, startPos, ((Integer)GameWorld.SmokeContainers.maxVentPipeLength.get()).intValue());
            this.outletPos = outletPos;
        }

        public static void build(World world, List<BlockPos> startPositions, BlockPos outletPos) {
            ArrayList<Pipe> builtPipes = new ArrayList<Pipe>();
            block0: for (BlockPos pos : startPositions) {
                for (Pipe pipe : builtPipes) {
                    if (!pipe.getChain().contains(pos)) continue;
                    continue block0;
                }
                Pipe pipe = new Pipe(world, pos, outletPos);
                pipe.build();
                builtPipes.add(pipe);
            }
        }

        protected boolean isValidPath(BlockPos pos) {
            return GameWorld.SmokeContainers.isVent((IWorldReader)this.world, (BlockPos)pos);
        }

        protected boolean isValidBlock(BlockPos pos) {
            return this.isValidPath(pos) || GameWorld.SmokeContainers.isPump((IWorldReader)this.world, (BlockPos)pos);
        }

        protected boolean onValidFound(BlockPos foundPos) {
            block0: for (Direction facing : GameWorld.Directions.getShuffledHorizontals()) {
                for (int dist = 1; dist <= (Integer)GameWorld.SmokeContainers.ventInhaleDistance.get(); ++dist) {
                    IPollutant pollutant;
                    BlockPos pos = foundPos.func_177967_a(facing, dist);
                    BlockState state = this.world.func_180495_p(pos);
                    if (state.isAir((IBlockReader)this.world, pos)) continue;
                    if (state.func_177230_c() instanceof IPollutant && (pollutant = (IPollutant)state.func_177230_c()).getPollutantType() == IPollutant.Type.AIR) {
                        if (this.pumpOutletWith(pollutant, pos, state)) continue block0;
                        return false;
                    }
                    if (Block.func_220056_d((BlockState)state, (IBlockReader)this.world, (BlockPos)pos, (Direction)facing) || Block.func_220056_d((BlockState)state, (IBlockReader)this.world, (BlockPos)pos, (Direction)facing.func_176734_d())) continue block0;
                }
            }
            return true;
        }

        private boolean pumpOutletWith(IPollutant pollutant, BlockPos pos, BlockState state) {
            int count = 0;
            if (GameWorld.SmokeContainers.isChimney((IWorldReader)this.world, (BlockPos)this.outletPos) || pollutant.canPassThrough((IWorldReader)this.world, this.outletPos, Direction.DOWN, Direction.UP)) {
                int amount = pollutant.getCarriedPollutionAmount(state);
                count += pollutant.pumpEntitiesAt(this.world, this.outletPos, amount);
            }
            if (count > 0) {
                pollutant.spend(this.world, pos, count);
            }
            return count > 0;
        }
    }
}

