/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.particles;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.forge.world.Wind;
import com.endertech.minecraft.mods.adchimneys.particles.AbstractSmokeParticle;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ModernSmokeParticle {
    public static ParticleType<Data> TYPE;

    @OnlyIn(value=Dist.CLIENT)
    public static void generate(World world, IWind wind, Smoke smoke, BlockPos pos, float factor) {
        world.func_217381_Z().func_76320_a("generateModernSmokeParticles");
        int smokeAmount = Math.round(smoke.getAmount() * factor);
        FloatBounds dyBounds = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(0.6f));
        FloatBounds dxzBounds = FloatBounds.from((Float)Float.valueOf(0.125f), (Float)Float.valueOf(0.875f)).reduce(Float.valueOf(smoke.getScale() / 10.0f));
        Data data = new Data(wind, smoke);
        for (int i = 0; i < smokeAmount; ++i) {
            double dx = dxzBounds.randomBetween().floatValue();
            double dy = dyBounds.randomBetween().floatValue();
            double dz = dxzBounds.randomBetween().floatValue();
            Vect3d smokePos = Vect3d.from((BlockPos)pos).move(dx, dy, dz);
            world.func_195590_a((IParticleData)data, true, smokePos.x, smokePos.y, smokePos.z, 0.0, 0.0, 0.0);
        }
        world.func_217381_Z().func_76319_b();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Instance
    extends AbstractSmokeParticle.Instance {
        public Instance(World world, IWind wind, Smoke smoke, Vect3d pos, Vect3d motion, float scale, IAnimatedSprite sprite) {
            super(world, wind, smoke, pos, motion, scale, sprite);
            this.field_70547_e = this.field_187136_p.nextInt(50) + 80;
            this.func_70541_f(1.5f * scale);
            this.func_82338_g(0.9f);
            this.field_70545_g = 3.0E-6f;
            this.field_187129_i = motion.x;
            this.field_187130_j = motion.y + (double)(this.field_187136_p.nextFloat() / 500.0f);
            this.field_187131_k = motion.z;
        }

        @Override
        public IParticleRenderType func_217558_b() {
            return IParticleRenderType.field_217603_c;
        }

        public float func_217561_b(float partialTicks) {
            float ageFactor = (float)(4 * this.field_70546_d) / (float)this.field_70547_e;
            return Math.max(this.field_70544_f, this.field_70544_f * ageFactor);
        }

        @Override
        public void func_189213_a() {
            super.func_189213_a();
            if (!this.inChimney) {
                this.field_187130_j *= 0.99;
            }
            if (this.field_187132_l) {
                ++this.field_70546_d;
                ++this.field_70546_d;
            }
        }

        @Override
        public void updateAnimatedSprite() {
            if (this.field_70546_d == 1) {
                this.func_217568_a(this.animatedSprite);
            }
            if (this.field_70546_d >= this.field_70547_e - 60 && this.field_82339_as > 0.01f) {
                this.field_82339_as -= 0.015f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    extends AbstractSmokeParticle.Factory<Data> {
        public Factory(IAnimatedSprite sprite) {
            super(sprite);
        }

        public Particle makeParticle(Data data, World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            double motionY = (double)data.smoke.getIntensity() / 10.0 * CommonMath.Random.between((double)0.5, (double)1.0);
            motionY = Math.max(motionY, 0.1);
            return new Instance(world, data.wind, data.smoke, Vect3d.from((double)x, (double)y, (double)z), Vect3d.from((double)0.0, (double)motionY, (double)0.0), data.smoke.getScale(), this.sprite);
        }
    }

    public static class Deserializer
    extends AbstractSmokeParticle.Deserializer<Data> {
        public Data deserialize(ParticleType<Data> particleTypeIn, StringReader reader) throws CommandSyntaxException {
            return new Data((IWind)Wind.NONE, Smoke.getNone());
        }

        public Data read(ParticleType<Data> particleTypeIn, PacketBuffer buffer) {
            return new Data((IWind)Wind.NONE, Smoke.getNone());
        }
    }

    public static class Data
    extends AbstractSmokeParticle.Data {
        public Data(IWind wind, Smoke smoke) {
            super(wind, smoke);
        }

        public ParticleType<?> func_197554_b() {
            return TYPE;
        }
    }
}

