/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.smoke;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.IWind;
import com.endertech.minecraft.forge.world.Wind;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SmokeParticle {
    public static ParticleType<Data> TYPE;
    public static final IParticleData.IDeserializer<Data> DESERIALIZER;
    private static final FloatBounds dyBounds;

    @OnlyIn(value=Dist.CLIENT)
    public static void generateIn(World world, IWind wind, Smoke smoke, BlockPos pos, float factor) {
        world.func_217381_Z().func_76320_a("renderSmoke");
        int smokeAmount = Math.round(smoke.getAmount() * factor);
        FloatBounds dxzBounds = FloatBounds.from((Float)Float.valueOf(0.125f), (Float)Float.valueOf(0.875f)).reduce(Float.valueOf(smoke.getScale() / 10.0f));
        Data data = new Data(wind, smoke);
        for (int i = 0; i < smokeAmount; ++i) {
            double dx = dxzBounds.randomBetween().floatValue();
            double dy = dyBounds.randomBetween().floatValue();
            double dz = dxzBounds.randomBetween().floatValue();
            Vect3d smokePos = Vect3d.from((BlockPos)pos).move(dx, dy, dz);
            world.func_195590_a((IParticleData)data, true, smokePos.x, smokePos.y, smokePos.z, 0.0, 0.0, 0.0);
        }
        world.func_217381_Z().func_76319_b();
    }

    static {
        DESERIALIZER = new IParticleData.IDeserializer<Data>(){

            public Data deserialize(ParticleType<Data> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                return new Data((IWind)Wind.NONE, Smoke.getNone());
            }

            public Data read(ParticleType<Data> particleTypeIn, PacketBuffer buffer) {
                return new Data((IWind)Wind.NONE, Smoke.getNone());
            }
        };
        dyBounds = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(0.6f));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Instance
    extends net.minecraft.client.particle.SmokeParticle {
        protected static final IntBounds TEXTURE_INDEX_BOUNDS = new IntBounds(Integer.valueOf(0), Integer.valueOf(7));
        private static final int MAX_HIT_AFTER_HIT_AMOUNT = 2;
        private static final double ON_HIT_MOTION_REDICTION = 0.7;
        private static final double ON_HIT_KICK_BACK = 0.05;
        protected int ticksInChimney = 0;
        protected final IWind wind;
        protected final IAnimatedSprite spriteSet;
        private int hitAfterHitCount = 0;

        public Instance(World world, Data data, Vect3d pos, Vect3d motion, float scale, IAnimatedSprite spriteSet) {
            super(world, pos.x, pos.y, pos.z, motion.x, motion.y, motion.z, scale, spriteSet);
            this.spriteSet = spriteSet;
            this.wind = data.wind;
            this.setColor(data.smoke.pickColor());
            this.field_190017_n = (Boolean)Smoke.canCollide.get();
            ++GameWorld.getData((IWorld)world).smokeParticlesCount;
        }

        public void func_187112_i() {
            --GameWorld.getData((IWorld)this.field_187122_b).smokeParticlesCount;
            super.func_187112_i();
        }

        public Vect3d getPosition() {
            return Vect3d.from((double)this.field_187126_f, (double)this.field_187127_g, (double)this.field_187128_h);
        }

        public Vect3d getMotion() {
            return Vect3d.from((double)this.field_187129_i, (double)this.field_187130_j, (double)this.field_187131_k);
        }

        public void setMotion(Vect3d motion) {
            this.field_187129_i = motion.x;
            this.field_187130_j = motion.y;
            this.field_187131_k = motion.z;
        }

        public void setColor(ColorARGB color) {
            this.func_70538_b(color.getRed().toFloat(), color.getGreen().toFloat(), color.getBlue().toFloat());
        }

        public void setPosition(Vect3d pos) {
            this.func_187109_b(pos.x, pos.y, pos.z);
        }

        public BlockPos getBlockPos() {
            return new BlockPos(this.field_187126_f, this.field_187127_g, this.field_187128_h);
        }

        protected void tryColorizeWith(ColorARGB color) {
            float alpha = color.getAlpha().toFloat();
            if (CommonMath.Random.result((float)(alpha * ((Double)Smoke.coloringFactor.get()).floatValue()))) {
                this.setColor(color);
            }
        }

        protected void updateTextureIndex() {
            int age = this.field_70546_d - this.ticksInChimney;
            int maxAge = this.field_70547_e - this.ticksInChimney;
            this.func_217567_a(this.spriteSet.func_217591_a(age, maxAge));
        }

        public void func_189213_a() {
            IWind wind;
            this.field_187122_b.func_217381_Z().func_76320_a("smokeParticle.update");
            ++this.field_70546_d;
            if (this.field_70546_d >= this.field_70547_e) {
                this.func_187112_i();
            }
            this.field_187123_c = this.field_187126_f;
            this.field_187124_d = this.field_187127_g;
            this.field_187125_e = this.field_187128_h;
            BlockPos blockPos = this.getBlockPos();
            BlockState state = this.field_187122_b.func_180495_p(blockPos);
            Block block = state.func_177230_c();
            boolean inSolidBlock = true;
            for (Direction side : GameWorld.Directions.CLOCKWISE_HORIZONTALS) {
                if (Block.func_220056_d((BlockState)state, (IBlockReader)this.field_187122_b, (BlockPos)blockPos, (Direction)side)) continue;
                inSolidBlock = false;
                break;
            }
            boolean canSeeSky = false;
            if (!inSolidBlock) {
                for (BlockPos pos : GameWorld.Positions.getAroundHoriz((BlockPos)blockPos, (boolean)true, (BlockPos[])new BlockPos[0])) {
                    if (!this.field_187122_b.func_175710_j(pos)) continue;
                    canSeeSky = true;
                    break;
                }
            }
            Object object = wind = !inSolidBlock || canSeeSky ? this.wind : Wind.NONE;
            if (block instanceof ISmokeContainer) {
                ISmokeContainer container = (ISmokeContainer)block;
                if (container.is(ISmokeContainer.Type.CHIMNEY) && CommonMath.notZero((double)this.field_187130_j) && this.field_187130_j > 0.0) {
                    ColorARGB color = container.getColor();
                    this.tryColorizeWith(color);
                    ++this.ticksInChimney;
                    if (!this.field_187132_l) {
                        ++this.field_70547_e;
                    }
                } else {
                    this.func_187112_i();
                    this.field_187122_b.func_217381_Z().func_76319_b();
                    return;
                }
            }
            this.updateTextureIndex();
            this.field_187130_j += 0.004;
            Vect3d motion = this.getMotion().add(wind.getMotion());
            this.move(motion);
            this.field_187130_j *= (double)0.96f;
            this.field_187122_b.func_217381_Z().func_76319_b();
        }

        public void func_187110_a(double dx, double dy, double dz) {
            this.move(Vect3d.from((double)dx, (double)dy, (double)dz));
        }

        public void move(Vect3d motion) {
            Vect3d nextPos = this.getPosition().add(motion);
            this.moveTo(nextPos);
        }

        private void moveTo(Vect3d nextPos) {
            if (this.field_190017_n) {
                if (this.hitAfterHitCount > 2) {
                    this.func_187112_i();
                    return;
                }
                Vect3d curPos = this.getPosition();
                BlockPos blockPos = nextPos.toBlockPos();
                BlockState blockState = this.field_187122_b.func_180495_p(blockPos);
                VoxelShape blockShape = blockState.func_196952_d((IBlockReader)this.field_187122_b, blockPos);
                BlockRayTraceResult hit = this.field_187122_b.func_217296_a(curPos.toVec3d(), nextPos.toVec3d(), blockPos, blockShape, blockState);
                if (hit != null && hit.func_216346_c() != RayTraceResult.Type.MISS) {
                    ++this.hitAfterHitCount;
                    Direction.Axis axis = hit.func_216354_b().func_176740_k();
                    Vect3d hitVec = Vect3d.from((Vec3d)hit.func_216347_e());
                    Vect3d bounceVec = nextPos.subtract(hitVec);
                    switch (axis) {
                        case X: {
                            bounceVec = bounceVec.invertX();
                            this.field_187129_i = -this.field_187129_i;
                            break;
                        }
                        case Z: {
                            bounceVec = bounceVec.invertZ();
                            this.field_187131_k = -this.field_187131_k;
                            break;
                        }
                        case Y: {
                            bounceVec = bounceVec.invertY();
                            CommonMath.Angle angle = CommonMath.Angle.random();
                            double motion = this.field_187130_j * this.getOnHitMotionReduction();
                            this.field_187129_i = angle.cos() * motion;
                            this.field_187131_k = angle.sin() * motion;
                            this.field_187130_j = 0.0;
                            this.field_190017_n = false;
                            this.field_187132_l = true;
                            break;
                        }
                        default: {
                            this.func_187112_i();
                            return;
                        }
                    }
                    nextPos = hitVec.add(bounceVec);
                    this.moveTo(nextPos);
                    return;
                }
            }
            this.hitAfterHitCount = 0;
            this.setPosition(nextPos);
        }

        protected double getOnHitMotionReduction() {
            return 0.7;
        }

        protected double getOnHitKickBack() {
            return 0.05;
        }

        public IParticleRenderType func_217558_b() {
            return super.func_217558_b();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements IParticleFactory<Data> {
        private final IAnimatedSprite spriteSet;

        public Factory(IAnimatedSprite spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle makeParticle(Data data, World world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            double motionY = (double)data.smoke.getIntensity() / 10.0 * CommonMath.Random.between((double)0.5, (double)1.0);
            return new Instance(world, data, Vect3d.from((double)x, (double)y, (double)z), Vect3d.from((double)0.0, (double)motionY, (double)0.0), data.smoke.getScale(), this.spriteSet);
        }
    }

    public static class Data
    implements IParticleData {
        public final IWind wind;
        public final Smoke smoke;

        public Data(IWind wind, Smoke smoke) {
            this.wind = wind;
            this.smoke = smoke;
        }

        public ParticleType<?> func_197554_b() {
            return TYPE;
        }

        public void func_197553_a(PacketBuffer buffer) {
        }

        public String func_197555_a() {
            return Registry.field_212632_u.func_177774_c(this.func_197554_b()).toString();
        }
    }
}

