/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.world;

import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adchimneys.AdChimneys;
import com.endertech.minecraft.mods.adchimneys.network.SmokePosMsg;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.world.Events;
import com.endertech.minecraft.mods.adchimneys.world.SmokeLocations;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class WorldData {
    static final Map<IWorld, WorldData> DATA_MAP = new ConcurrentHashMap<IWorld, WorldData>();
    final SmokeLocations smokeLocations = new SmokeLocations();
    final IWorld world;

    public WorldData(IWorld world) {
        this.world = world;
    }

    @Nonnull
    public static WorldData getData(IWorld world) {
        WorldData data = DATA_MAP.get(world);
        if (data == null) {
            data = new WorldData(world);
            DATA_MAP.put(world, data);
        }
        return data;
    }

    public float getParticlesReductionFactor() {
        float factor = 1.0f;
        int particlesCount = GameWorld.getData((IWorld)this.getWorld()).smokeParticlesCount;
        if (particlesCount > (Integer)Smoke.maxRenderedParticlesAmount.get()) {
            factor = (float)((Integer)Smoke.maxRenderedParticlesAmount.get()).intValue() / (float)particlesCount;
        }
        return factor;
    }

    public void updateSmokeEmitterAt(BlockPos emitterPos) {
        if (GameWorld.isClientSide((IWorldReader)this.world)) {
            return;
        }
        if (emitterPos instanceof BlockPos.MutableBlockPos) {
            return;
        }
        if (!this.world.func_175667_e(emitterPos)) {
            this.getSmokeLocations().remove(emitterPos);
            return;
        }
        Emitter emitter = AdChimneys.getEmitters().findBy((IWorldReader)this.world, emitterPos);
        Smoke emitterSmoke = this.getSmokeLocations().get(emitterPos);
        if (emitter != null) {
            if (emitterSmoke == null || emitterSmoke.getLifeTime().moreThan(Events.serverToClientUpdateTime.getInterval())) {
                Smoke outletSmoke;
                int outletsCount;
                emitterSmoke = emitter.getSmoke((IWorldReader)this.world, emitterPos, true, true);
                ArrayList<BlockPos> outlets = new ArrayList<BlockPos>();
                int maxOutletsAmount = (int)emitterSmoke.getAmount();
                WorldSearch.VentPipe.PumpFunc addOutlets = (worldIn, posIn, maxAmount) -> {
                    outlets.add(posIn);
                    return 1;
                };
                WorldSearch.TileNeighbors neighbors = WorldSearch.TileNeighbors.from((IWorld)this.world, (BlockPos)emitterPos, (Set)emitter.getRelatedBlocks());
                WorldSearch.VentPipe.pump((IWorld)this.world, (List)neighbors.getActiveVents(), (int)maxOutletsAmount, (WorldSearch.BlockChain.BlockFunc)WorldSearch.VentPipe.VALID_CHIMNEY_BLOCK, (WorldSearch.VentPipe.PumpFunc)addOutlets);
                if (outlets.isEmpty()) {
                    outlets.addAll(WorldData.getTopChimneys(neighbors, emitter.getMaxGapLength()));
                }
                if (emitter.canEmitAside()) {
                    outlets.addAll(neighbors.getSideChimneys());
                    if (outlets.isEmpty()) {
                        WorldSearch.VentPipe.pump((IWorld)this.world, (List)neighbors.getPassiveVents(), (int)maxOutletsAmount, (WorldSearch.BlockChain.BlockFunc)WorldSearch.VentPipe.VALID_CHIMNEY_BLOCK, (WorldSearch.VentPipe.PumpFunc)addOutlets);
                    }
                }
                if ((outletsCount = Math.min(outlets.size(), maxOutletsAmount)) == 0 && emitter.emitWithoutChimney()) {
                    outlets.add(emitterPos);
                    outletsCount = outlets.size();
                }
                this.getSmokeLocations().add(emitterPos, emitterSmoke);
                if (outletsCount > 0 && (outletSmoke = emitterSmoke.devideInto(outletsCount)).hasParticles()) {
                    int count = 1;
                    for (BlockPos pos : outlets) {
                        if (count <= outletsCount) {
                            SmokePosMsg message = new SmokePosMsg(pos, outletSmoke);
                            AdChimneys.getInstance().getConnection().sendToAllAround((Object)message, (IWorldReader)this.world, pos, ((Integer)Smoke.maxRenderDistance.get()).intValue());
                            ++count;
                            continue;
                        }
                        break;
                    }
                }
            }
        } else if (emitterSmoke != null) {
            this.getSmokeLocations().remove(emitterPos);
        }
    }

    private static List<BlockPos> getTopChimneys(WorldSearch.TileNeighbors neighbors, int maxGapLength) {
        IWorld world = neighbors.getWorld();
        ArrayList<BlockPos> chimneys = new ArrayList<BlockPos>();
        block0: for (BlockPos startPos : neighbors.getAboveBlocks()) {
            for (int i = 0; i <= maxGapLength; ++i) {
                BlockPos pos = startPos.func_177981_b(i);
                if (GameWorld.SmokeContainers.isChimney((IWorldReader)world, (BlockPos)pos)) {
                    chimneys.add(pos);
                    continue block0;
                }
                if (!GameWorld.isAirBlock((IWorldReader)world, (BlockPos)pos)) continue block0;
            }
        }
        return chimneys;
    }

    public IWorld getWorld() {
        return this.world;
    }

    public SmokeLocations getSmokeLocations() {
        return this.smokeLocations;
    }
}

