/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client;

import com.endertech.minecraft.forge.data.GamePath;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public final class GameRendering {
    public static final ResourceLocation EMPTY_TEXTURE = GamePath.texture((GamePath.Folders)GamePath.Folders.NONE, (ResourceLocation)new ResourceLocation((String)"forgeendertech", (String)"empty"), (String[])new String[0]).location;

    public static void bindTexture(ResourceLocation resource) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resource);
    }

    public static void renderItemLayerIn2D(int width, int height, float thickness, float minX, float minY, float maxX, float maxY, float minU, float minV, float maxU, float maxV, double layerOffsetX, double layerOffsetY, double layerOffsetZ) {
        double v;
        double y;
        double u;
        double x;
        int i;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        double x1 = (double)minX + layerOffsetX;
        double x2 = (double)maxX - layerOffsetX;
        double y1 = (double)minY + layerOffsetY;
        double y2 = (double)maxY - layerOffsetY;
        double z1 = 0.0 - layerOffsetZ;
        double z2 = layerOffsetZ - (double)thickness;
        GlStateManager.normal3f((float)0.0f, (float)0.0f, (float)1.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x1, y1, z1).func_187315_a((double)minU, (double)minV).func_181675_d();
        buffer.func_181662_b(x2, y1, z1).func_187315_a((double)maxU, (double)minV).func_181675_d();
        buffer.func_181662_b(x2, y2, z1).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        buffer.func_181662_b(x1, y2, z1).func_187315_a((double)minU, (double)maxV).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.normal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b(x1, y2, z2).func_187315_a((double)minU, (double)maxV).func_181675_d();
        buffer.func_181662_b(x2, y2, z2).func_187315_a((double)maxU, (double)maxV).func_181675_d();
        buffer.func_181662_b(x2, y1, z2).func_187315_a((double)maxU, (double)minV).func_181675_d();
        buffer.func_181662_b(x1, y1, z2).func_187315_a((double)minU, (double)minV).func_181675_d();
        tessellator.func_78381_a();
        float halfPixelWidth = 0.5f * (minU - maxU) / (float)width;
        float halfPixelHeight = 0.5f * (minV - maxV) / (float)height;
        GlStateManager.normal3f((float)-1.0f, (float)0.0f, (float)0.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < width; ++i) {
            x = (float)i / (float)width;
            u = (double)minU + (double)(maxU - minU) * x - (double)halfPixelWidth;
            x = x1 + (double)i * ((double)(maxX - minX) - 2.0 * layerOffsetX) / (double)width;
            buffer.func_181662_b(x, y1, z2).func_187315_a(u, (double)minV).func_181675_d();
            buffer.func_181662_b(x, y1, z1).func_187315_a(u, (double)minV).func_181675_d();
            buffer.func_181662_b(x, y2, z1).func_187315_a(u, (double)maxV).func_181675_d();
            buffer.func_181662_b(x, y2, z2).func_187315_a(u, (double)maxV).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.normal3f((float)1.0f, (float)0.0f, (float)0.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < width; ++i) {
            x = (float)i / (float)width;
            u = (double)minU + (double)(maxU - minU) * x - (double)halfPixelWidth;
            x = x1 + (double)((float)i + 1.0f) * ((double)(maxX - minX) - 2.0 * layerOffsetX) / (double)width;
            buffer.func_181662_b(x, y2, z2).func_187315_a(u, (double)maxV).func_181675_d();
            buffer.func_181662_b(x, y2, z1).func_187315_a(u, (double)maxV).func_181675_d();
            buffer.func_181662_b(x, y1, z1).func_187315_a(u, (double)minV).func_181675_d();
            buffer.func_181662_b(x, y1, z2).func_187315_a(u, (double)minV).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < height; ++i) {
            y = (float)i / (float)height;
            v = (double)minV + (double)(maxV - minV) * y - (double)halfPixelHeight;
            y = y1 + (double)((float)i + 1.0f) * ((double)(maxY - minY) - 2.0 * layerOffsetY) / (double)height;
            buffer.func_181662_b(x1, y, z1).func_187315_a((double)minU, v).func_181675_d();
            buffer.func_181662_b(x2, y, z1).func_187315_a((double)maxU, v).func_181675_d();
            buffer.func_181662_b(x2, y, z2).func_187315_a((double)maxU, v).func_181675_d();
            buffer.func_181662_b(x1, y, z2).func_187315_a((double)minU, v).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.normal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        for (i = 0; i < height; ++i) {
            y = (float)i / (float)height;
            v = (double)minV + (double)(maxV - minV) * y - (double)halfPixelHeight;
            y = y1 + (double)i * ((double)(maxY - minY) - 2.0 * layerOffsetY) / (double)height;
            buffer.func_181662_b(x2, y, z1).func_187315_a((double)maxU, v).func_181675_d();
            buffer.func_181662_b(x1, y, z1).func_187315_a((double)minU, v).func_181675_d();
            buffer.func_181662_b(x1, y, z2).func_187315_a((double)minU, v).func_181675_d();
            buffer.func_181662_b(x2, y, z2).func_187315_a((double)maxU, v).func_181675_d();
        }
        tessellator.func_78381_a();
    }

    public static void renderBlock(double x, double y, double z, double width, double height, double length, double rotateX, double rotateY, double rotateZ, double red, double green, double blue, double alpha) {
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.enableRescaleNormal();
        GlStateManager.rotatef((float)((float)rotateX), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.rotatef((float)((float)rotateY), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)((float)rotateZ), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.scaled((double)width, (double)height, (double)length);
        GlStateManager.color4f((float)((float)red), (float)((float)green), (float)((float)blue), (float)((float)alpha));
        GlStateManager.begin((int)9);
        GlStateManager.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.vertex3f((float)-0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.vertex3f((float)-0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.vertex3f((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.vertex3f((float)0.5f, (float)0.5f, (float)-0.5f);
        GlStateManager.vertex3f((float)-0.5f, (float)0.5f, (float)-0.5f);
        GlStateManager.end();
        GL11.glBegin((int)9);
        GlStateManager.normal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.vertex3f((float)0.5f, (float)-0.5f, (float)0.5f);
        GlStateManager.vertex3f((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.vertex3f((float)-0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.vertex3f((float)-0.5f, (float)-0.5f, (float)0.5f);
        GlStateManager.end();
        GL11.glBegin((int)9);
        GlStateManager.normal3f((float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.vertex3f((float)0.5f, (float)0.5f, (float)-0.5f);
        GlStateManager.vertex3f((float)0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.vertex3f((float)0.5f, (float)-0.5f, (float)0.5f);
        GlStateManager.vertex3f((float)0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.end();
        GL11.glBegin((int)9);
        GlStateManager.normal3f((float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.vertex3f((float)-0.5f, (float)-0.5f, (float)0.5f);
        GlStateManager.vertex3f((float)-0.5f, (float)0.5f, (float)0.5f);
        GlStateManager.vertex3f((float)-0.5f, (float)0.5f, (float)-0.5f);
        GlStateManager.vertex3f((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.end();
        GL11.glBegin((int)9);
        GlStateManager.normal3f((float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.vertex3f((float)0.5f, (float)-0.5f, (float)0.5f);
        GlStateManager.vertex3f((float)-0.5f, (float)-0.5f, (float)0.5f);
        GlStateManager.vertex3f((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.vertex3f((float)0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.end();
        GL11.glBegin((int)9);
        GlStateManager.normal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.vertex3f((float)0.5f, (float)0.5f, (float)-0.5f);
        GlStateManager.vertex3f((float)0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.vertex3f((float)-0.5f, (float)-0.5f, (float)-0.5f);
        GlStateManager.vertex3f((float)-0.5f, (float)0.5f, (float)-0.5f);
        GlStateManager.end();
        GlStateManager.popMatrix();
    }

    @Deprecated
    public static class MeterIndicators {
        public static final ResourceLocation TEXTURE = GamePath.itemTexture((ResourceLocation)new ResourceLocation((String)"forgeendertech", (String)"meter_indicators"), (String[])new String[0]).location;

        public static void beforeRender(float meterThickness) {
            GlStateManager.pushMatrix();
            GlStateManager.translatef((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.translatef((float)0.0f, (float)0.0f, (float)(-meterThickness / 2.0f));
            GlStateManager.disableLighting();
            GlStateManager.disableCull();
            GameRendering.bindTexture(TEXTURE);
        }

        public static void afterRender() {
            GameRendering.bindTexture(AtlasTexture.field_110575_b);
            GlStateManager.enableLighting();
            GlStateManager.enableCull();
            GlStateManager.popMatrix();
        }
    }
}

