/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys;

import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeCreativeTab;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ModConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.WorldData;
import com.endertech.minecraft.mods.adchimneys.blocks.Chimney;
import com.endertech.minecraft.mods.adchimneys.blocks.Smoker;
import com.endertech.minecraft.mods.adchimneys.init.Chimneys;
import com.endertech.minecraft.mods.adchimneys.init.Conductors;
import com.endertech.minecraft.mods.adchimneys.init.Emitters;
import com.endertech.minecraft.mods.adchimneys.smoke.Conductor;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.item.Item;

@Mod(modid="adchimneys", name="Advanced Chimneys", version="1.7.10-2.16.8.0", acceptedMinecraftVersions="[1.7.10]", dependencies="required-after:forgeendertech@[1.7.10-1.9.2.0,)")
public class Main
extends ForgeMod {
    public static final String ID = "adchimneys";
    public static final String NAME = "Advanced Chimneys";
    public static final ForgeCreativeTab CHIMNEYS_TAB = new ForgeCreativeTab("adchimneys");
    public static final int RENDER_ID = RenderingRegistry.getNextAvailableRenderId();
    @Mod.Instance(value="adchimneys")
    public static Main instance;
    Smoker smoker;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        this.setConfig(new ModConfig(this.getId(), event));
        this.initSmokeGlobals();
        Chimneys.values();
        Chimneys.initCustom();
        this.smoker = new Smoker(this, new UnitConfig(this.getConfig().getConfigDir(), Smoker.class.getSimpleName().toLowerCase(Locale.ROOT)));
        super.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        CHIMNEYS_TAB.setIcon((Block)Chimneys.cobblestone.instance);
        this.getRegistrator().registerInEventBus((Object)this);
        super.init(event);
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void initClient(FMLInitializationEvent event) {
        Chimney.Renderer renderer = new Chimney.Renderer();
        RenderingRegistry.registerBlockHandler((int)RENDER_ID, (ISimpleBlockRenderingHandler)renderer);
        FMLCommonHandler.instance().bus().register((Object)renderer);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.printInitMsg((FMLEvent)event);
        Conductors.initCustom();
        for (Conductors conductors : Conductors.values()) {
            WorldData.smokeConductors.register(conductors.conductor);
        }
        for (Conductor conductor : Conductors.custom) {
            WorldData.smokeConductors.register(conductor);
        }
        Emitters.initCustom();
        for (Emitters emitters : Emitters.values()) {
            WorldData.smokeEmitters.register(emitters.emitter);
        }
        for (Emitter emitter : Emitters.custom) {
            WorldData.smokeEmitters.register(emitter);
        }
        super.postInit(event);
    }

    void initSmokeGlobals() {
        String category = Smoke.class.getSimpleName();
        Smoke.defaultColor = this.getConfig().getColorARGB(category, "defaultColor", ColorARGB.DEFAULT, "Default smoke color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)");
        Smoke.maxAmount = this.getConfig().getFloat(category, "maxAmount", Smoke.maxAmount, new FloatBounds(Float.valueOf(1.0f), Float.valueOf(100.0f)), "Maximum smoke particles amount per chimney");
        Smoke.maxIntencity = this.getConfig().getFloat(category, "maxIntencity", Smoke.maxIntencity, new FloatBounds(Float.valueOf(0.0f), Float.valueOf(20.0f)), "Maximum smoke blow out distance");
        Smoke.maxScale = this.getConfig().getFloat(category, "maxScale", Smoke.maxScale, new FloatBounds(Float.valueOf(1.0f), Float.valueOf(10.0f)), "Maximum smoke particles scale");
        Smoke.maxGapLength = this.getConfig().getFloat(category, "maxGapLength", Smoke.maxGapLength, new FloatBounds(Float.valueOf(0.0f), Float.valueOf(20.0f)), "If > 0 it allows smoke to blow through gaps in pipelines");
        Smoke.maxRenderDistance = this.getConfig().getInt(category, "maxRenderDistance", Smoke.maxRenderDistance, new IntBounds(Integer.valueOf(16), Integer.valueOf(256)), "Maximum smoke particles render distance");
        Smoke.maxRenderedParticlesAmount = this.getConfig().getFloat(category, "maxRenderedParticlesAmount", Smoke.maxRenderedParticlesAmount, new FloatBounds(Float.valueOf(0.0f), Float.valueOf(2000.0f)), "Maximum smoke particles that can be rendered at scene.\nIf exceeded, smoke amount will be reduced proportionally for each rendered chimney");
        Smoke.clientUpdateInterval = this.getConfig().getInt(category, "clientUpdateInterval", Smoke.clientUpdateInterval, new IntBounds(Integer.valueOf(1), Integer.valueOf(1000)), "Defines how frequently the smoke will be generated on clients (in milliseconds)");
        Smoke.clientWaitForUpdateTime = this.getConfig().getInt(category, "clientWaitForUpdateTime", Smoke.clientWaitForUpdateTime, new IntBounds(Integer.valueOf(100), Integer.valueOf(10000)), "Defines how long client will wait for server update before remove chimney from render list");
        Smoke.serverToClientUpdateInterval = this.getConfig().getInt(category, "serverToClientUpdateInterval", Smoke.serverToClientUpdateInterval, new IntBounds(Integer.valueOf(100), Integer.valueOf(10000)), "Defines how frequently the server will send data of chimneys that need to be updated (in milliseconds)");
        Smoke.serverScheduleTickInterval = this.getConfig().getInt(category, "serverScheduleTickInterval", Smoke.serverScheduleTickInterval, new IntBounds(Integer.valueOf(1), Integer.valueOf(1000)), "Defines delays between scheduled block updates");
        this.getConfig().save();
    }

    @Mod.EventHandler
    public void onMissingMappings(FMLMissingMappingsEvent event) {
        String chimneyStr = "chimney";
        HashMap<UnitId, Chimney> chimneyMap = new HashMap<UnitId, Chimney>();
        for (Object chimney : Chimneys.values()) {
            UnitId relatedUnitId = chimney.instance.getRelatedUnitId();
            UnitId chimneyId = UnitId.from((String)this.getId(), (String)("chimney" + relatedUnitId.getRegName().toLowerCase(Locale.ROOT)));
            chimneyMap.put(chimneyId, chimney.instance);
        }
        chimneyMap.put(UnitId.from((String)this.getId(), (String)"chimneyendstone"), Chimneys.end_stone.instance);
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.getAll()) {
            Object chimney;
            UnitId oldId = UnitId.from((String)mapping.name.toLowerCase(Locale.ROOT));
            chimney = (Chimney)((Object)chimneyMap.get(oldId));
            if (chimney == null) continue;
            switch (mapping.type) {
                case BLOCK: {
                    mapping.remap((Block)chimney);
                    break;
                }
                case ITEM: {
                    mapping.remap(Item.func_150898_a((Block)chimney));
                    break;
                }
            }
        }
    }

    public String getId() {
        return ID;
    }

    public String getName() {
        return NAME;
    }

    public ForgeMod getInstance() {
        return instance;
    }
}

