/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.ForgeBounds;
import com.endertech.minecraft.forge.ForgeWorld;
import com.endertech.minecraft.forge.math.BlockPos;
import com.endertech.minecraft.forge.units.BlockState;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.Main;
import com.endertech.minecraft.mods.adchimneys.blocks.Chimney;
import com.endertech.minecraft.mods.adchimneys.smoke.Collector;
import com.endertech.minecraft.mods.adchimneys.smoke.Conductor;
import com.endertech.minecraft.mods.adchimneys.smoke.Emitter;
import com.endertech.minecraft.mods.adchimneys.smoke.IEmitter;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import org.apache.logging.log4j.Logger;

public final class WorldData {
    private static final String FORMAT_REGISTERED_AS = "registered: <{}> as {}";
    private static final String FORMAT_ALREADY_REGISTERED_AS = "already registered: <{}> as {}!";
    private static final String FORMAT_SKIPPED_NO_RELATED_BLOCK = "SKIPPED: <{}> because no related block found.";
    public static SmokeLocations activeChimneys = new SmokeLocations();
    public static SmokeLocations renderChimneys = new SmokeLocations();
    public static SmokeContainers<Emitter> smokeEmitters = new SmokeContainers<Emitter>(Emitter.class){

        @Override
        @Nullable
        public Emitter find(World world, BlockPos pos) {
            BlockState state = ForgeWorld.getBlockState((World)world, (BlockPos)pos);
            if (state.getBlock() instanceof IEmitter) {
                return ((IEmitter)state.getBlock()).getEmitter(world, pos);
            }
            return (Emitter)super.find(world, pos);
        }
    };
    public static SmokeContainers<Conductor> smokeConductors = new SmokeContainers<Conductor>(Conductor.class);
    private static final Logger LOGGER = Main.instance.getLogger();

    public static boolean coveredBySmoketightBlock(World world, BlockPos pos) {
        if (world == null || pos == null) {
            return false;
        }
        BlockPos checkPos = pos.up();
        if (ForgeWorld.getBlockState((World)world, (BlockPos)checkPos).getBlock() == Blocks.field_150350_a) {
            return false;
        }
        Conductor conductor = smokeConductors.find(world, checkPos);
        if (conductor != null) {
            return conductor.isSmoketight();
        }
        Emitter emitter = smokeEmitters.find(world, checkPos);
        if (emitter != null) {
            return emitter.isSmoketight();
        }
        return ForgeWorld.isVerticalOpaque((World)world, (BlockPos)pos.up());
    }

    public static boolean coveredByChimney(World world, BlockPos pos) {
        return WorldData.isChimney(world, pos.up());
    }

    public static Smoke transferSmokeFromSideEmitter(World world, BlockPos pos, Conductor conductor) {
        Smoke smoke = Smoke.getNone();
        Emitter emitter = smokeEmitters.find(world, pos);
        if (emitter != null) {
            smoke = emitter.getSmoke(world, pos, false, true);
            smoke = conductor.getTransferredSmoke(smoke);
        }
        return smoke;
    }

    public static boolean isChimney(World world, BlockPos pos) {
        return ForgeWorld.getBlock((World)world, (BlockPos)pos) instanceof Chimney;
    }

    public static Smoke getSmokeFrom(World world, BlockPos pos, int gapLen) {
        if (pos == null || pos.getY() <= 0 || (float)gapLen > Smoke.maxGapLength) {
            return Smoke.getNone();
        }
        Collector collector = new Collector();
        Block block = ForgeWorld.getBlock((World)world, (BlockPos)pos);
        if (block instanceof Chimney) {
            Conductor conductor = ((Chimney)block).getConductor();
            collector.addSmoke(WorldData.transferSmokeFromSideEmitter(world, pos.east(), conductor));
            collector.addSmoke(WorldData.transferSmokeFromSideEmitter(world, pos.west(), conductor));
            collector.addSmoke(WorldData.transferSmokeFromSideEmitter(world, pos.north(), conductor));
            collector.addSmoke(WorldData.transferSmokeFromSideEmitter(world, pos.south(), conductor));
            collector.addSmoke(conductor.getTransferredSmoke(WorldData.getSmokeFrom(world, pos.down(), 0)));
        } else {
            Emitter emitter = smokeEmitters.find(world, pos);
            if (emitter != null) {
                if (emitter.isAllowGaps() || gapLen == 0) {
                    collector.addSmoke(emitter.getSmoke(world, pos, true, false));
                }
                collector.addSmoke(emitter.getTransferredSmoke(WorldData.getSmokeFrom(world, pos.down(), gapLen)));
            } else {
                Conductor conductor = smokeConductors.find(world, pos);
                if (conductor != null) {
                    collector.addSmoke(conductor.getTransferredSmoke(WorldData.getSmokeFrom(world, pos.down(), gapLen + 1)));
                }
            }
        }
        return collector.getSmoke();
    }

    public static class SmokeContainers<C extends Conductor> {
        private final Map<BlockState, C> map = new ConcurrentHashMap<BlockState, C>();
        private final String name;

        public SmokeContainers(Class<C> containerClass) {
            this.name = containerClass.getSimpleName();
        }

        @Nullable
        public C find(World world, BlockPos pos) {
            BlockState state = ForgeWorld.getBlockState((World)world, (BlockPos)pos);
            Conductor container = (Conductor)this.map.get(state);
            return (C)(container != null ? container : (Conductor)this.map.get(state.withMetaAll()));
        }

        public void register(C container) {
            if (container != null) {
                UnitId id = ((Conductor)container).getRelatedUnitId();
                if (id.getBlockState().exists()) {
                    if (this.map.putIfAbsent(id.getBlockState(), container) == null) {
                        LOGGER.info(WorldData.FORMAT_REGISTERED_AS, new Object[]{id, container});
                    } else {
                        LOGGER.warn(WorldData.FORMAT_ALREADY_REGISTERED_AS, new Object[]{id, this.name});
                    }
                } else {
                    LOGGER.info(WorldData.FORMAT_SKIPPED_NO_RELATED_BLOCK, new Object[]{id});
                }
            } else {
                LOGGER.error("{} is NULL!", new Object[]{this.name});
            }
        }
    }

    public static class SmokeLocations {
        private Map<BlockPos, Smoke> map = new ConcurrentHashMap<BlockPos, Smoke>();
        private float totalParticlesAmount = 0.0f;

        public void add(BlockPos pos, Smoke smoke) {
            Smoke prevSmoke = this.map.put(pos, smoke);
            if (prevSmoke != null) {
                this.totalParticlesAmount -= prevSmoke.getAmount();
            }
            this.totalParticlesAmount += smoke.getAmount();
        }

        public void remove(BlockPos pos) {
            Smoke prevSmoke = this.map.remove(pos);
            if (prevSmoke != null) {
                this.totalParticlesAmount -= prevSmoke.getAmount();
            }
        }

        public float getTotalParticlesAmount() {
            return this.totalParticlesAmount;
        }

        public float getParticlesReductionFactor() {
            float factor = 0.0f;
            if (CommonMath.notZero((double)this.totalParticlesAmount)) {
                factor = Smoke.maxRenderedParticlesAmount / this.totalParticlesAmount;
            }
            return ForgeBounds.FACTOR.getFloatBounds().enclose(Float.valueOf(factor)).floatValue();
        }

        public Map<BlockPos, Smoke> getMap() {
            return Collections.unmodifiableMap(this.map);
        }

        @Nullable
        public Smoke get(BlockPos pos) {
            return this.map.get(pos);
        }
    }
}

