/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adchimneys.blocks;

import com.endertech.common.Args;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.ForgeMain;
import com.endertech.minecraft.forge.ForgeMod;
import com.endertech.minecraft.forge.ForgeRendering;
import com.endertech.minecraft.forge.ForgeWorld;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.ForgeConfig;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.materials.CraftingRecipe;
import com.endertech.minecraft.forge.math.BlockPos;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.forge.messages.UpdateBlockMsg;
import com.endertech.minecraft.forge.units.ForgeBlock;
import com.endertech.minecraft.forge.units.IRelatedUnitId;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adchimneys.Main;
import com.endertech.minecraft.mods.adchimneys.WorldData;
import com.endertech.minecraft.mods.adchimneys.smoke.Conductor;
import com.endertech.minecraft.mods.adchimneys.smoke.Smoke;
import com.endertech.minecraft.mods.adchimneys.smoke.SmokeParticle;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class Chimney
extends ForgeBlock
implements IRelatedUnitId {
    protected static final double WALL_THICKNESS = 0.125;
    private final Conductor conductor;
    public static int MAX_ACTIVE_THREADS_AMOUNT = 0;
    private static AtomicInteger activeThreadsAmount = new AtomicInteger(0);

    public Chimney(ForgeMod mod, UnitConfig config, String name, UnitId relatedBlockId, float patency, ColorARGB smokeAddColor, int stackSize) {
        super(mod, config, name, Material.field_151576_e, (CreativeTabs)Main.CHIMNEYS_TAB);
        this.conductor = new Conductor(config, relatedBlockId, smokeAddColor, patency);
        this.func_149675_a(true);
        this.func_149663_c(UnitId.buildRegName((String[])new String[]{this.getId().getRegName(), ((Object)((Object)this)).getClass().getSimpleName()}));
        String textureName = this.getConductor().getRelatedUnitId().withNewName(this.getId().getRegName()).toResLoc().toString();
        textureName = ForgeConfig.getStr((ForgeConfig)config, (String)this.getClassCategory(), (String)"textureName", (String)textureName, (String)"Defines the name of the texture for the chimney.");
        this.func_149658_d(textureName);
        CraftingRecipe recipe = CraftingRecipe.CreateMain((ForgeConfig)config, (String)"101 101 101", (String)this.getStringId(), (int)stackSize, (String[])new String[]{this.getConductor().getRelatedUnitId().toString()});
        this.getMod().getRegistrator().addCrafting(recipe);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aaBB, List list, Entity entity) {
        float thickness = 0.125f;
        this.func_149676_a(0.0f, 0.0f, 0.0f, thickness, 1.0f, 1.0f);
        super.func_149743_a(world, x, y, z, aaBB, list, entity);
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, thickness);
        super.func_149743_a(world, x, y, z, aaBB, list, entity);
        this.func_149676_a(1.0f - thickness, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        super.func_149743_a(world, x, y, z, aaBB, list, entity);
        this.func_149676_a(0.0f, 0.0f, 1.0f - thickness, 1.0f, 1.0f, 1.0f);
        super.func_149743_a(world, x, y, z, aaBB, list, entity);
        this.func_149683_g();
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public String getClassRegName() {
        return "";
    }

    public int func_149645_b() {
        return Main.RENDER_ID;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        switch (side) {
            case DOWN: 
            case UP: {
                return false;
            }
        }
        return true;
    }

    public void func_149651_a(IIconRegister registrator) {
        this.field_149761_L = registrator.func_94245_a(this.func_149641_N());
    }

    public boolean isReadyToRegister() {
        return this.getConductor().getRelatedUnitId().getBlockState().exists();
    }

    public void func_149726_b(World world, int x, int y, int z) {
        this.func_149674_a(world, x, y, z, (Random)CommonMath.RANDOM);
        super.func_149726_b(world, x, y, z);
    }

    public void func_149664_b(World world, int x, int y, int z, int meta) {
        BlockPos pos = BlockPos.from((int)x, (int)y, (int)z);
        WorldData.activeChimneys.remove(pos);
        WorldData.renderChimneys.remove(pos);
        super.func_149664_b(world, x, y, z, meta);
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion explosion) {
        BlockPos pos = BlockPos.from((int)x, (int)y, (int)z);
        WorldData.activeChimneys.remove(pos);
        WorldData.renderChimneys.remove(pos);
        super.func_149723_a(world, x, y, z, explosion);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        this.func_149674_a(world, x, y, z, rand);
        super.func_149734_b(world, x, y, z, rand);
    }

    public void func_149674_a(World world, int x, int y, int z, Random rand) {
        BlockPos pos = BlockPos.from((int)x, (int)y, (int)z);
        if (MAX_ACTIVE_THREADS_AMOUNT > 0) {
            if (activeThreadsAmount.get() < MAX_ACTIVE_THREADS_AMOUNT) {
                new Updater(world, pos);
            }
        } else {
            Chimney.updateOn(world, pos);
        }
        if (this.isServerSide(world)) {
            world.func_147464_a(x, y, z, (Block)this, Smoke.serverScheduleTickInterval);
        }
        super.func_149674_a(world, x, y, z, rand);
    }

    private static void updateOn(World world, BlockPos pos) {
        Smoke smoke;
        boolean covered;
        boolean bl = covered = WorldData.coveredByChimney(world, pos) || WorldData.coveredBySmoketightBlock(world, pos);
        if (ForgeWorld.isServerSide((World)world) && !covered && ((smoke = WorldData.activeChimneys.get(pos)) == null || smoke.getLifeTime().inMillis() >= (long)Smoke.serverToClientUpdateInterval)) {
            smoke = WorldData.getSmokeFrom(world, pos, 0);
            WorldData.activeChimneys.add(pos, smoke);
            if (smoke.hasParticles()) {
                Chimney.meltSnowAround(world, pos, smoke);
                UpdateBlockMsg message = new UpdateBlockMsg(pos);
                NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)Smoke.maxRenderDistance);
                ForgeMain.instance.getRegistrator().networkChannel.sendToAllAround((IMessage)message, point);
            }
        }
        if (ForgeWorld.isClientSide((World)world)) {
            if (!covered) {
                smoke = WorldData.getSmokeFrom(world, pos, 0);
                if (smoke != null && smoke.hasParticles()) {
                    WorldData.renderChimneys.add(pos, smoke);
                } else {
                    WorldData.renderChimneys.remove(pos);
                }
            } else {
                WorldData.renderChimneys.remove(pos);
            }
        }
    }

    private static void meltSnowAround(World world, BlockPos pos, Smoke smoke) {
        if (ForgeWorld.isServerSide((World)world)) {
            BlockPos startPos;
            boolean shouldMelt;
            boolean bl = shouldMelt = CommonMath.Random.between((float)0.0f, (float)Smoke.maxAmount) < smoke.getAmount();
            if (shouldMelt && (startPos = (BlockPos)CommonMath.Random.from((List)ForgeWorld.Position.getAllAround((BlockPos)pos, (boolean)true))) != null) {
                int maxOffset = Math.max(1, Math.round(smoke.getIntencity()));
                for (int offset = 0; offset <= maxOffset; ++offset) {
                    BlockPos snowPos = startPos.up(offset);
                    if (ForgeWorld.SnowMelter.isSnow((World)world, (BlockPos)snowPos)) {
                        ForgeWorld.SnowMelter.meltLayerAt((World)world, (BlockPos)snowPos);
                        break;
                    }
                    BlockPos checkPos = pos.up(offset + 1);
                    if (WorldData.isChimney(world, checkPos) || ForgeWorld.isVerticalOpaque((World)world, (BlockPos)checkPos) || ForgeWorld.getBlock((World)world, (BlockPos)checkPos) == Blocks.field_150359_w) break;
                }
            }
        }
    }

    public void onInit() {
        Block relatedBlock = this.getConductor().getRelatedUnitId().getBlockState().getBlock();
        if (relatedBlock != null) {
            int lightValue = relatedBlock.func_149750_m();
            this.setLightValue(lightValue);
            float resistance = relatedBlock.func_149638_a(null) * 5.0f;
            this.setResistance(resistance);
            float hardness = relatedBlock.func_149712_f(null, 0, 0, 0);
            this.func_149711_c(hardness);
        }
        super.onInit();
    }

    public String toString() {
        return Chimney.class.getSimpleName() + Args.group((Object[])new Object[]{this.getConductor()}) + Args.extend((Object)super.toString());
    }

    public UnitId getRelatedUnitId() {
        return this.getConductor().getRelatedUnitId();
    }

    public Conductor getConductor() {
        return this.conductor;
    }

    @SideOnly(value=Side.CLIENT)
    public static class Renderer
    implements ISimpleBlockRenderingHandler {
        private static final FloatBounds dyBounds = new FloatBounds(Float.valueOf(0.0f), Float.valueOf(0.6f));
        private static final FloatBounds dxzBounds = new FloatBounds(Float.valueOf(0.4f), Float.valueOf(0.6f));
        private static final double d = 0.001;
        private static final double D = 0.001;
        public static final double SIDE_WIDTH = 0.16;
        private CommonTime.Stamp lastUpdate = CommonTime.Stamp.now();

        @SubscribeEvent
        public void onPlayerTick(TickEvent.PlayerTickEvent event) {
            if (CommonTime.Time.passedFrom((CommonTime.Stamp)this.lastUpdate).inMillis() >= (long)Smoke.clientUpdateInterval) {
                for (Map.Entry<BlockPos, Smoke> entry : WorldData.renderChimneys.getMap().entrySet()) {
                    BlockPos pos = entry.getKey();
                    Smoke smoke = entry.getValue();
                    double distance = ForgeEntity.getCurPosition((Entity)Minecraft.func_71410_x().field_71451_h).distance(Vect3d.from((BlockPos)pos));
                    float totalParticlesAmount = WorldData.renderChimneys.getTotalParticlesAmount();
                    if (totalParticlesAmount > 0.0f && smoke.hasParticles() && smoke.getLifeTime().inMillis() <= (long)Smoke.clientWaitForUpdateTime && distance <= (double)Smoke.maxRenderDistance) {
                        float factor = WorldData.renderChimneys.getParticlesReductionFactor();
                        this.renderSmoke(event.player.field_70170_p, smoke, pos, factor);
                        continue;
                    }
                    WorldData.renderChimneys.remove(pos);
                }
                this.lastUpdate = CommonTime.Stamp.now();
            }
        }

        public void renderSmoke(World world, Smoke smoke, BlockPos pos, float factor) {
            int smokeAmount = Math.round(smoke.getAmount() * factor);
            for (int i = 0; i < smokeAmount; ++i) {
                double dx = dxzBounds.randomBetween().floatValue();
                double dy = dyBounds.randomBetween().floatValue();
                double dz = dxzBounds.randomBetween().floatValue();
                Vect3d smokePos = Vect3d.from((BlockPos)pos).move(dx, dy, dz);
                SmokeParticle smokeParticle = new SmokeParticle(world, smokePos, smoke.getIntencity(), smoke.getScale(), smoke.pickColor());
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)smokeParticle);
            }
        }

        public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
            Tessellator tess = Tessellator.field_78398_a;
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tess.func_78382_b();
            this.renderChimneyItem(tess, block, 0, 0, 0, renderer);
            tess.func_78381_a();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }

        public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
            this.renderChimneyBlock(block, x, y, z, renderer);
            return true;
        }

        public void renderChimneyBlock(Block block, int x, int y, int z, RenderBlocks renderer) {
            renderer.func_147753_b(true);
            ForgeRendering.setRenderBounds((RenderBlocks)renderer, (AxisAlignedBB)ChimneySides.east.bounds);
            renderer.func_147784_q(block, x, y, z);
            ForgeRendering.setRenderBounds((RenderBlocks)renderer, (AxisAlignedBB)ChimneySides.west.bounds);
            renderer.func_147784_q(block, x, y, z);
            ForgeRendering.setRenderBounds((RenderBlocks)renderer, (AxisAlignedBB)ChimneySides.north.bounds);
            renderer.func_147784_q(block, x, y, z);
            ForgeRendering.setRenderBounds((RenderBlocks)renderer, (AxisAlignedBB)ChimneySides.south.bounds);
            renderer.func_147784_q(block, x, y, z);
        }

        public void renderChimneyItem(Tessellator tess, Block block, int x, int y, int z, RenderBlocks renderer) {
            this.drawSide(tess, ChimneySides.east, x, y, z, block.func_149691_a(ForgeRendering.Faces.east.ordinal(), 0));
            this.drawSide(tess, ChimneySides.west, x, y, z, block.func_149691_a(ForgeRendering.Faces.west.ordinal(), 0));
            this.drawSide(tess, ChimneySides.north, x, y, z, block.func_149691_a(ForgeRendering.Faces.north.ordinal(), 0));
            this.drawSide(tess, ChimneySides.south, x, y, z, block.func_149691_a(ForgeRendering.Faces.south.ordinal(), 0));
        }

        public void drawSide(Tessellator tessellator, ChimneySides side, int x, int y, int z, IIcon icon) {
            AxisAlignedBB bounds = side.bounds.func_72325_c((double)x, (double)y, (double)z);
            FloatBounds u = new FloatBounds(Float.valueOf(icon.func_94209_e()), Float.valueOf(icon.func_94212_f()));
            FloatBounds v = new FloatBounds(Float.valueOf(icon.func_94206_g()), Float.valueOf(icon.func_94210_h()));
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            tessellator.func_78374_a(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72339_c, (double)u.max.floatValue(), (double)v.max.floatValue());
            tessellator.func_78374_a(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72339_c, (double)u.max.floatValue(), (double)v.min.floatValue());
            tessellator.func_78374_a(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f, (double)u.min.floatValue(), (double)v.min.floatValue());
            tessellator.func_78374_a(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72334_f, (double)u.min.floatValue(), (double)v.max.floatValue());
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            tessellator.func_78374_a(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72334_f, (double)u.max.floatValue(), (double)v.max.floatValue());
            tessellator.func_78374_a(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72334_f, (double)u.max.floatValue(), (double)v.min.floatValue());
            tessellator.func_78374_a(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72339_c, (double)u.min.floatValue(), (double)v.min.floatValue());
            tessellator.func_78374_a(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c, (double)u.min.floatValue(), (double)v.max.floatValue());
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            tessellator.func_78374_a(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c, (double)u.max.floatValue(), (double)v.max.floatValue());
            tessellator.func_78374_a(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72339_c, (double)u.max.floatValue(), (double)v.min.floatValue());
            tessellator.func_78374_a(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72339_c, (double)u.min.floatValue(), (double)v.min.floatValue());
            tessellator.func_78374_a(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72339_c, (double)u.min.floatValue(), (double)v.max.floatValue());
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            tessellator.func_78374_a(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72334_f, (double)u.max.floatValue(), (double)v.max.floatValue());
            tessellator.func_78374_a(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f, (double)u.max.floatValue(), (double)v.min.floatValue());
            tessellator.func_78374_a(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72334_f, (double)u.min.floatValue(), (double)v.min.floatValue());
            tessellator.func_78374_a(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72334_f, (double)u.min.floatValue(), (double)v.max.floatValue());
            switch (side) {
                case east: 
                case west: {
                    float min = u.approxUp((float)side.bounds.field_72340_a).floatValue();
                    float max = u.approxUp((float)side.bounds.field_72336_d).floatValue();
                    u = new FloatBounds(Float.valueOf(min), Float.valueOf(max));
                    break;
                }
                case north: 
                case south: {
                    float min = v.approxUp((float)side.bounds.field_72339_c).floatValue();
                    float max = v.approxUp((float)side.bounds.field_72334_f).floatValue();
                    v = new FloatBounds(Float.valueOf(min), Float.valueOf(max));
                    break;
                }
            }
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            tessellator.func_78374_a(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72334_f, (double)u.max.floatValue(), (double)v.max.floatValue());
            tessellator.func_78374_a(bounds.field_72336_d, bounds.field_72337_e, bounds.field_72339_c, (double)u.max.floatValue(), (double)v.min.floatValue());
            tessellator.func_78374_a(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72339_c, (double)u.min.floatValue(), (double)v.min.floatValue());
            tessellator.func_78374_a(bounds.field_72340_a, bounds.field_72337_e, bounds.field_72334_f, (double)u.min.floatValue(), (double)v.max.floatValue());
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            tessellator.func_78374_a(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72334_f, (double)u.max.floatValue(), (double)v.max.floatValue());
            tessellator.func_78374_a(bounds.field_72336_d, bounds.field_72338_b, bounds.field_72339_c, (double)u.max.floatValue(), (double)v.min.floatValue());
            tessellator.func_78374_a(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72339_c, (double)u.min.floatValue(), (double)v.min.floatValue());
            tessellator.func_78374_a(bounds.field_72340_a, bounds.field_72338_b, bounds.field_72334_f, (double)u.min.floatValue(), (double)v.max.floatValue());
        }

        public boolean shouldRender3DInInventory(int modelId) {
            return true;
        }

        public int getRenderId() {
            return Main.RENDER_ID;
        }

        static enum ChimneySides {
            east(0.84, 0.0, 0.001, 1.0, 1.0, 0.999),
            west(0.0, 0.0, 0.001, 0.16, 1.0, 0.999),
            north(0.001, 0.001, 0.0, 0.999, 0.999, 0.16),
            south(0.001, 0.001, 0.84, 0.999, 0.999, 1.0);

            public final AxisAlignedBB bounds;

            private ChimneySides(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
                this.bounds = AxisAlignedBB.func_72330_a((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            }
        }
    }

    private static class Updater
    extends Thread {
        private final World world;
        private final BlockPos pos;

        public Updater(World world, BlockPos pos) {
            this.world = world;
            this.pos = pos;
            this.setName("updater");
            this.setPriority(1);
            activeThreadsAmount.incrementAndGet();
            this.start();
        }

        @Override
        public void run() {
            Chimney.updateOn(this.world, this.pos);
            activeThreadsAmount.decrementAndGet();
        }
    }
}

